package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolListRspBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolRspBO;
import com.tydic.dyc.act.repository.api.DycActRelSkuPoolRepository;
import com.tydic.dyc.act.repository.dao.ActRelSkuPoolMapper;
import com.tydic.dyc.act.repository.po.ActRelSkuPoolExtPO;
import com.tydic.dyc.act.repository.po.ActRelSkuPoolPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("actRelSkuPoolService")
public class DycActRelSkuPoolRepositoryImpl implements DycActRelSkuPoolRepository {

    @Autowired
    ActRelSkuPoolMapper actRelSkuPoolMapper;

    @Override
    public ActRelSkuPoolRspBO queryActRelSkuPoolSingle(ActRelSkuPoolReqBO actRelSkuPoolReqBO){
        ActRelSkuPoolRspBO rspBO = new ActRelSkuPoolRspBO();
        ActRelSkuPoolExtPO selectActRelSkuPoolPO = new ActRelSkuPoolExtPO();
        BeanUtils.copyProperties(actRelSkuPoolReqBO, selectActRelSkuPoolPO);
        List<ActRelSkuPoolPO> actRelSkuPoolList = this.actRelSkuPoolMapper.selectByCondition(selectActRelSkuPoolPO);
        if (actRelSkuPoolList.size() == 1) {
            ActRelSkuPoolBO actRelSkuPoolBO = new ActRelSkuPoolBO();
            BeanUtils.copyProperties(actRelSkuPoolList.get(0), actRelSkuPoolBO);
            rspBO.setData(actRelSkuPoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actRelSkuPoolList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActRelSkuPoolListRspBO queryActRelSkuPoolList(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        ActRelSkuPoolListRspBO rspBO = new ActRelSkuPoolListRspBO();
        ActRelSkuPoolExtPO selectActRelSkuPoolPO = new ActRelSkuPoolExtPO();
        BeanUtils.copyProperties(actRelSkuPoolReqBO, selectActRelSkuPoolPO);
        List<ActRelSkuPoolPO> actRelSkuPoolPOList = this.actRelSkuPoolMapper.selectByCondition(selectActRelSkuPoolPO);

        List<ActRelSkuPoolBO> actRelSkuPoolBOList = new ArrayList<>();
        for (ActRelSkuPoolPO actRelSkuPoolPO : actRelSkuPoolPOList) {
            ActRelSkuPoolBO actRelSkuPoolBO = new ActRelSkuPoolBO();
            BeanUtils.copyProperties(actRelSkuPoolPO, actRelSkuPoolBO);
            actRelSkuPoolBOList.add(actRelSkuPoolBO);
        }

        rspBO.setData(actRelSkuPoolBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActRelSkuPoolBO> queryActRelSkuPoolListPage(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        if (actRelSkuPoolReqBO.getPageNo() < 1) {
            actRelSkuPoolReqBO.setPageNo(1);
        }
        if (actRelSkuPoolReqBO.getPageSize() < 1) {
            actRelSkuPoolReqBO.setPageSize(10);
        }

        ActRelSkuPoolExtPO selectActRelSkuPoolPO = new ActRelSkuPoolExtPO();
        BeanUtils.copyProperties(actRelSkuPoolReqBO, selectActRelSkuPoolPO);
        Page<ActRelSkuPoolPO> page = PageHelper.startPage(actRelSkuPoolReqBO.getPageNo(), actRelSkuPoolReqBO.getPageSize()).doSelectPage(() -> this.actRelSkuPoolMapper.selectByCondition(selectActRelSkuPoolPO));

        //封装集合
        List<ActRelSkuPoolBO> actRelSkuPoolBOList = new ArrayList<>();
        for (ActRelSkuPoolPO actRelSkuPoolPO : page.getResult()) {
            ActRelSkuPoolBO actRelSkuPoolBO = new ActRelSkuPoolBO();
            BeanUtils.copyProperties(actRelSkuPoolPO, actRelSkuPoolBO);
            actRelSkuPoolBOList.add(actRelSkuPoolBO);
        }

        RspPage<ActRelSkuPoolBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actRelSkuPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActRelSkuPoolRspBO addActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        ActRelSkuPoolRspBO rspBO = new ActRelSkuPoolRspBO();

        ActRelSkuPoolPO insertActRelSkuPoolPO = new ActRelSkuPoolPO();
        BeanUtils.copyProperties(actRelSkuPoolReqBO, insertActRelSkuPoolPO);
        long id = Sequence.getInstance().nextId();
        insertActRelSkuPoolPO.setRelId(id);
        //TODO 封装其它信息

        int num = this.actRelSkuPoolMapper.insert(insertActRelSkuPoolPO);
        if (num == 1) {
            ActRelSkuPoolBO ActRelSkuPoolBO = new ActRelSkuPoolBO();
            BeanUtils.copyProperties(insertActRelSkuPoolPO, ActRelSkuPoolBO);
            rspBO.setData(ActRelSkuPoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActRelSkuPoolListRspBO addListActRelSkuPool(List<ActRelSkuPoolReqBO> actRelSkuPoolReqBO) {
        ActRelSkuPoolListRspBO rspBO = new ActRelSkuPoolListRspBO();
        for(int i = 0;i < actRelSkuPoolReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actRelSkuPoolReqBO.get(i).setRelId(id);
                }

        List<ActRelSkuPoolPO> insertActRelSkuPoolPO = JSONObject.parseArray(JSONObject.toJSONString(actRelSkuPoolReqBO),ActRelSkuPoolPO.class);


        int num = this.actRelSkuPoolMapper.allInsert(insertActRelSkuPoolPO);
        if (num == actRelSkuPoolReqBO.size()) {
            List<ActRelSkuPoolBO> lActRelSkuPoolBO = JSONObject.parseArray(JSONObject.toJSONString(insertActRelSkuPoolPO),ActRelSkuPoolBO.class);
            rspBO.setData(lActRelSkuPoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActRelSkuPoolRspBO updateActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        ActRelSkuPoolRspBO rspBO = new ActRelSkuPoolRspBO();
        ActRelSkuPoolExtPO selectActRelSkuPoolPO = new ActRelSkuPoolExtPO();
        selectActRelSkuPoolPO.setRelId(actRelSkuPoolReqBO.getRelId());
        List<ActRelSkuPoolPO> actRelSkuPoolList = this.actRelSkuPoolMapper.selectByCondition(selectActRelSkuPoolPO);
        if (actRelSkuPoolList.size() == 1) {
            ActRelSkuPoolPO updateActRelSkuPoolPO = new ActRelSkuPoolPO();
            BeanUtils.copyProperties(actRelSkuPoolReqBO, updateActRelSkuPoolPO);

            int num = this.actRelSkuPoolMapper.update(updateActRelSkuPoolPO);
            if (num == 1) {
                ActRelSkuPoolBO actRelSkuPoolBO = new ActRelSkuPoolBO();
                BeanUtils.copyProperties(updateActRelSkuPoolPO, actRelSkuPoolBO);
                rspBO.setData(actRelSkuPoolBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actRelSkuPoolList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActRelSkuPoolRspBO saveActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        //新增信息
        if (actRelSkuPoolReqBO.getRelId() == null) {
            return this.addActRelSkuPool(actRelSkuPoolReqBO);
        }
        //修改信息
        else {
            return this.updateActRelSkuPool(actRelSkuPoolReqBO);
        }
    }

    @Override
    public ActRelSkuPoolRspBO deleteActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        ActRelSkuPoolRspBO rspBO = new ActRelSkuPoolRspBO();
        ActRelSkuPoolExtPO selectActRelSkuPoolPO = new ActRelSkuPoolExtPO();
        selectActRelSkuPoolPO.setRelId(actRelSkuPoolReqBO.getRelId());
        List<ActRelSkuPoolPO> actRelSkuPoolList = this.actRelSkuPoolMapper.selectByCondition(selectActRelSkuPoolPO);
        if (actRelSkuPoolList.size() == 1) {
            ActRelSkuPoolPO deleteActRelSkuPoolPO = new ActRelSkuPoolPO();
            BeanUtils.copyProperties(actRelSkuPoolReqBO, deleteActRelSkuPoolPO);

            int num = this.actRelSkuPoolMapper.delete(deleteActRelSkuPoolPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actRelSkuPoolList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActRelSkuPoolRspBO deleteListActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        ActRelSkuPoolRspBO rspBO = new ActRelSkuPoolRspBO();
        ActRelSkuPoolExtPO deleteActRelSkuPoolPO = new ActRelSkuPoolExtPO();
        deleteActRelSkuPoolPO.setSkuIdList(actRelSkuPoolReqBO.getSkuIdList());
        deleteActRelSkuPoolPO.setPoolId(actRelSkuPoolReqBO.getPoolId());
        actRelSkuPoolMapper.allDelete(deleteActRelSkuPoolPO);
        return rspBO;
    }

}
