package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActSkuDetailBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailReqBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailRspBO;
import com.tydic.dyc.act.repository.api.DycActSkuDetailRepository;
import com.tydic.dyc.act.repository.dao.ActSkuDetailMapper;
import com.tydic.dyc.act.repository.po.ActSkuDetailPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("actSkuDetailService")
public class DycActSkuDetailRepositoryImpl implements DycActSkuDetailRepository {

    @Autowired
    ActSkuDetailMapper actSkuDetailMapper;

    @Override
    public ActSkuDetailRspBO queryActSkuDetailSingle(ActSkuDetailReqBO actSkuDetailReqBO){
        ActSkuDetailRspBO rspBO = new ActSkuDetailRspBO();
        ActSkuDetailPO selectActSkuDetailPO = new ActSkuDetailPO();
        BeanUtils.copyProperties(actSkuDetailReqBO, selectActSkuDetailPO);
        List<ActSkuDetailPO> actSkuDetailList = this.actSkuDetailMapper.selectByCondition(selectActSkuDetailPO);
        if (actSkuDetailList.size() == 1) {
            ActSkuDetailBO actSkuDetailBO = new ActSkuDetailBO();
            BeanUtils.copyProperties(actSkuDetailList.get(0), actSkuDetailBO);
            rspBO.setData(actSkuDetailBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuDetailList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuDetailListRspBO queryActSkuDetailList(ActSkuDetailReqBO actSkuDetailReqBO) {
        ActSkuDetailListRspBO rspBO = new ActSkuDetailListRspBO();
        ActSkuDetailPO selectActSkuDetailPO = new ActSkuDetailPO();
        BeanUtils.copyProperties(actSkuDetailReqBO, selectActSkuDetailPO);
        List<ActSkuDetailPO> actSkuDetailPOList = this.actSkuDetailMapper.selectByCondition(selectActSkuDetailPO);

        List<ActSkuDetailBO> actSkuDetailBOList = new ArrayList<>();
        for (ActSkuDetailPO actSkuDetailPO : actSkuDetailPOList) {
            ActSkuDetailBO actSkuDetailBO = new ActSkuDetailBO();
            BeanUtils.copyProperties(actSkuDetailPO, actSkuDetailBO);
            actSkuDetailBOList.add(actSkuDetailBO);
        }

        rspBO.setData(actSkuDetailBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActSkuDetailBO> queryActSkuDetailListPage(ActSkuDetailReqBO actSkuDetailReqBO) {
        if (actSkuDetailReqBO.getPageNo() < 1) {
            actSkuDetailReqBO.setPageNo(1);
        }
        if (actSkuDetailReqBO.getPageSize() < 1) {
            actSkuDetailReqBO.setPageSize(10);
        }

        ActSkuDetailPO selectActSkuDetailPO = new ActSkuDetailPO();
        BeanUtils.copyProperties(actSkuDetailReqBO, selectActSkuDetailPO);
        Page<ActSkuDetailPO> page = PageHelper.startPage(actSkuDetailReqBO.getPageNo(), actSkuDetailReqBO.getPageSize()).doSelectPage(() -> this.actSkuDetailMapper.selectByCondition(selectActSkuDetailPO));

        //封装集合
        List<ActSkuDetailBO> actSkuDetailBOList = new ArrayList<>();
        for (ActSkuDetailPO actSkuDetailPO : page.getResult()) {
            ActSkuDetailBO actSkuDetailBO = new ActSkuDetailBO();
            BeanUtils.copyProperties(actSkuDetailPO, actSkuDetailBO);
            actSkuDetailBOList.add(actSkuDetailBO);
        }

        RspPage<ActSkuDetailBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuDetailBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActSkuDetailRspBO addActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO) {
        ActSkuDetailRspBO rspBO = new ActSkuDetailRspBO();

        ActSkuDetailPO insertActSkuDetailPO = new ActSkuDetailPO();
        BeanUtils.copyProperties(actSkuDetailReqBO, insertActSkuDetailPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuDetailPO.setSkuId(id);
        //TODO 封装其它信息

        int num = this.actSkuDetailMapper.insert(insertActSkuDetailPO);
        if (num == 1) {
            ActSkuDetailBO ActSkuDetailBO = new ActSkuDetailBO();
            BeanUtils.copyProperties(insertActSkuDetailPO, ActSkuDetailBO);
            rspBO.setData(ActSkuDetailBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuDetailListRspBO addListActSkuDetail(List<ActSkuDetailReqBO> actSkuDetailReqBO) {
        ActSkuDetailListRspBO rspBO = new ActSkuDetailListRspBO();
        for(int i = 0;i < actSkuDetailReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuDetailReqBO.get(i).setSkuId(id);
                }

        List<ActSkuDetailPO> insertActSkuDetailPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuDetailReqBO),ActSkuDetailPO.class);


        int num = this.actSkuDetailMapper.allInsert(insertActSkuDetailPO);
        if (num == actSkuDetailReqBO.size()) {
            List<ActSkuDetailBO> lActSkuDetailBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuDetailPO),ActSkuDetailBO.class);
            rspBO.setData(lActSkuDetailBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuDetailRspBO updateActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO) {
        ActSkuDetailRspBO rspBO = new ActSkuDetailRspBO();
        ActSkuDetailPO selectActSkuDetailPO = new ActSkuDetailPO();
        selectActSkuDetailPO.setSkuId(actSkuDetailReqBO.getSkuId());
        List<ActSkuDetailPO> actSkuDetailList = this.actSkuDetailMapper.selectByCondition(selectActSkuDetailPO);
        if (actSkuDetailList.size() == 1) {
            ActSkuDetailPO updateActSkuDetailPO = new ActSkuDetailPO();
            BeanUtils.copyProperties(actSkuDetailReqBO, updateActSkuDetailPO);

            int num = this.actSkuDetailMapper.update(updateActSkuDetailPO);
            if (num == 1) {
                ActSkuDetailBO actSkuDetailBO = new ActSkuDetailBO();
                BeanUtils.copyProperties(updateActSkuDetailPO, actSkuDetailBO);
                rspBO.setData(actSkuDetailBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuDetailList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuDetailRspBO saveActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO) {
        //新增信息
        if (actSkuDetailReqBO.getSkuId() == null) {
            return this.addActSkuDetail(actSkuDetailReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuDetail(actSkuDetailReqBO);
        }
    }

    @Override
    public ActSkuDetailRspBO deleteActSkuDetail(ActSkuDetailReqBO actSkuDetailReqBO) {
        ActSkuDetailRspBO rspBO = new ActSkuDetailRspBO();
        ActSkuDetailPO selectActSkuDetailPO = new ActSkuDetailPO();
        selectActSkuDetailPO.setSkuId(actSkuDetailReqBO.getSkuId());
        List<ActSkuDetailPO> actSkuDetailList = this.actSkuDetailMapper.selectByCondition(selectActSkuDetailPO);
        if (actSkuDetailList.size() == 1) {
            ActSkuDetailPO deleteActSkuDetailPO = new ActSkuDetailPO();
            BeanUtils.copyProperties(actSkuDetailReqBO, deleteActSkuDetailPO);

            int num = this.actSkuDetailMapper.delete(deleteActSkuDetailPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuDetailList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

}
