package com.tydic.dyc.act.repository.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.repository.dao.ActSkuInfoMapper;
import com.tydic.dyc.act.repository.po.ActSkuInfoExtPO;
import com.tydic.dyc.act.repository.po.ActSkuInfoPO;
import org.springframework.beans.BeanUtils;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActSkuGuideRepository;
import com.tydic.dyc.act.repository.dao.ActSkuGuideMapper;
import com.tydic.dyc.act.repository.po.ActSkuGuideExtPO;
import com.tydic.dyc.act.repository.po.ActSkuGuidePO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListRspBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service("actSkuGuideService")
public class DycActSkuGuideRepositoryImpl implements DycActSkuGuideRepository {

    @Autowired
    ActSkuGuideMapper actSkuGuideMapper;
    @Autowired
    private ActSkuInfoMapper actSkuInfoMapper;

    @Override
    public ActSkuGuideRspBO queryActSkuGuideSingle(ActSkuGuideReqBO actSkuGuideReqBO){
        ActSkuGuideRspBO rspBO = new ActSkuGuideRspBO();
        ActSkuGuidePO selectActSkuGuidePO = new ActSkuGuidePO();
        BeanUtils.copyProperties(actSkuGuideReqBO, selectActSkuGuidePO);
        List<ActSkuGuidePO> actSkuGuideList = this.actSkuGuideMapper.selectByCondition(selectActSkuGuidePO);
        if (actSkuGuideList.size() == 1) {
            ActSkuGuideBO actSkuGuideBO = new ActSkuGuideBO();
            BeanUtils.copyProperties(actSkuGuideList.get(0), actSkuGuideBO);
            rspBO.setData(actSkuGuideBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuGuideList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuGuideListRspBO queryActSkuGuideList(ActSkuGuideReqBO actSkuGuideReqBO) {
        ActSkuGuideListRspBO rspBO = new ActSkuGuideListRspBO();
        ActSkuGuidePO selectActSkuGuidePO = new ActSkuGuidePO();
        BeanUtils.copyProperties(actSkuGuideReqBO, selectActSkuGuidePO);
        List<ActSkuGuidePO> actSkuGuidePOList = this.actSkuGuideMapper.selectByCondition(selectActSkuGuidePO);

        List<ActSkuGuideBO> actSkuGuideBOList = new ArrayList<>();
        for (ActSkuGuidePO actSkuGuidePO : actSkuGuidePOList) {
            ActSkuGuideBO actSkuGuideBO = new ActSkuGuideBO();
            BeanUtils.copyProperties(actSkuGuidePO, actSkuGuideBO);
            actSkuGuideBOList.add(actSkuGuideBO);
        }

        rspBO.setData(actSkuGuideBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActSkuGuideBO> queryActSkuGuideListPage(ActSkuGuideReqBO actSkuGuideReqBO) {
        if (actSkuGuideReqBO.getPageNo() < 1) {
            actSkuGuideReqBO.setPageNo(1);
        }
        if (actSkuGuideReqBO.getPageSize() < 1) {
            actSkuGuideReqBO.setPageSize(10);
        }

        ActSkuGuidePO selectActSkuGuidePO = new ActSkuGuidePO();
        BeanUtils.copyProperties(actSkuGuideReqBO, selectActSkuGuidePO);
        Page<ActSkuGuidePO> page = PageHelper.startPage(actSkuGuideReqBO.getPageNo(), actSkuGuideReqBO.getPageSize()).doSelectPage(() -> this.actSkuGuideMapper.selectByCondition(selectActSkuGuidePO));

        //封装集合
        List<ActSkuGuideBO> actSkuGuideBOList = new ArrayList<>();
        for (ActSkuGuidePO actSkuGuidePO : page.getResult()) {
            ActSkuGuideBO actSkuGuideBO = new ActSkuGuideBO();
            BeanUtils.copyProperties(actSkuGuidePO, actSkuGuideBO);
            actSkuGuideBOList.add(actSkuGuideBO);
        }

        RspPage<ActSkuGuideBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuGuideBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActSkuGuideRspBO addActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO) {
        ActSkuGuideRspBO rspBO = new ActSkuGuideRspBO();

        ActSkuGuidePO insertActSkuGuidePO = new ActSkuGuidePO();
        BeanUtils.copyProperties(actSkuGuideReqBO, insertActSkuGuidePO);
        long id = Sequence.getInstance().nextId();
        insertActSkuGuidePO.setGuideCatalogId(id);
        //校验类目名称重复
        ActSkuGuidePO guidePO = new ActSkuGuidePO();
        guidePO.setCatalogName(actSkuGuideReqBO.getCatalogName());
        List<ActSkuGuidePO> actSkuGuidePOS = actSkuGuideMapper.selectByCondition(guidePO);
        if(!CollectionUtils.isEmpty(actSkuGuidePOS)){
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            rspBO.setSameName(true);
            return rspBO;
        }

        //dealOrder(actSkuGuideReqBO);
        //查询同级类目最大排序
        ActSkuGuidePO uccCatalogDealPO = new ActSkuGuidePO();
        uccCatalogDealPO.setUpperCatalogId(actSkuGuideReqBO.getUpperCatalogId());
        List<ActSkuGuidePO> uccCatalogDealPOList = actSkuGuideMapper.selectByCondition(uccCatalogDealPO);
        if (uccCatalogDealPOList == null || uccCatalogDealPOList.size() == 0) {
            //如果此父类目无子类目，则不用排序，直接插入0
            insertActSkuGuidePO.setViewOrder(0);
        }else {
            //查询按照viewOrder倒序，最大值直接取第一条数据
            insertActSkuGuidePO.setViewOrder(uccCatalogDealPOList.get(uccCatalogDealPOList.size()-1).getViewOrder()+1);
        }
        insertActSkuGuidePO.setCreateOperName(actSkuGuideReqBO.getName());
        insertActSkuGuidePO.setCreateTime(new Date());
        int num = this.actSkuGuideMapper.insert(insertActSkuGuidePO);
        if (num == 1) {
            ActSkuGuideBO ActSkuGuideBO = new ActSkuGuideBO();
            BeanUtils.copyProperties(insertActSkuGuidePO, ActSkuGuideBO);
            rspBO.setData(ActSkuGuideBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    /**
     * 解决排序问题
     *
     * @param reqBO
     */
    private void dealOrder(ActSkuGuideReqBO reqBO) {
        //查询父级类目下的所有子类目
        ActSkuGuidePO uccCatalogDealPO = new ActSkuGuidePO();
        uccCatalogDealPO.setUpperCatalogId(reqBO.getUpperCatalogId());
        List<ActSkuGuidePO> uccCatalogDealPOList = actSkuGuideMapper.selectByCondition(uccCatalogDealPO);
        if (uccCatalogDealPOList == null || uccCatalogDealPOList.size() == 0) {
            //如果此父类目无子类目，则不用排序，直接插入0
            reqBO.setViewOrder(0);
            return;
        }
        if (uccCatalogDealPOList != null && uccCatalogDealPOList.size() > 0) {

            //获得最大序号
            Integer maxOrder = uccCatalogDealPOList.get(uccCatalogDealPOList.size() - 1).getViewOrder();
            if (maxOrder == null) {
                return;
            }

            if (reqBO.getOrderConfSolution() != null) {
                //排序方式不为空，则选择在目标之前还是互换
                if (reqBO.getOrderConfSolution() == 0) {
                    //排在目标之前
                    ActSkuGuideExtPO extPO = new ActSkuGuideExtPO();
                    extPO.setUpperCatalogId(reqBO.getUpperCatalogId());
                    extPO.setViewOrder(reqBO.getViewOrder());
                    actSkuGuideMapper.modifyOrder(extPO);
                }
            }

        }
    }


    @Override
    public ActSkuGuideListRspBO addListActSkuGuide(List<ActSkuGuideReqBO> actSkuGuideReqBO) {
        ActSkuGuideListRspBO rspBO = new ActSkuGuideListRspBO();
        for(int i = 0;i < actSkuGuideReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuGuideReqBO.get(i).setGuideCatalogId(id);
                }

        List<ActSkuGuidePO> insertActSkuGuidePO = JSONObject.parseArray(JSONObject.toJSONString(actSkuGuideReqBO),ActSkuGuidePO.class);


        int num = this.actSkuGuideMapper.allInsert(insertActSkuGuidePO);
        if (num == actSkuGuideReqBO.size()) {
            List<ActSkuGuideBO> lActSkuGuideBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuGuidePO),ActSkuGuideBO.class);
            rspBO.setData(lActSkuGuideBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuGuideRspBO updateActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO) {
        ActSkuGuideRspBO rspBO = new ActSkuGuideRspBO();
        ActSkuGuidePO selectActSkuGuidePO = new ActSkuGuidePO();
        selectActSkuGuidePO.setGuideCatalogId(actSkuGuideReqBO.getGuideCatalogId());
        List<ActSkuGuidePO> actSkuGuideList = this.actSkuGuideMapper.selectByCondition(selectActSkuGuidePO);
        if (actSkuGuideList.size() == 1) {
            //校验类目名称重复
            ActSkuGuidePO guidePO = new ActSkuGuidePO();
            guidePO.setCatalogName(actSkuGuideReqBO.getCatalogName());
            List<ActSkuGuidePO> actSkuGuidePOS = actSkuGuideMapper.selectByCondition(guidePO);
            if(!CollectionUtils.isEmpty(actSkuGuidePOS)){
                if(!actSkuGuideReqBO.getGuideCatalogId().equals(actSkuGuidePOS.get(0).getGuideCatalogId())){
                    rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                    rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
                    rspBO.setSameName(true);
                    return rspBO;
                }
            }

            //判断类目状态是否发生变更
            if(actSkuGuideReqBO.getCatalogStatus() != actSkuGuideList.get(0).getCatalogStatus()){
                updateGuideState(actSkuGuideReqBO,actSkuGuideList.get(0));
            }

            ActSkuGuidePO updateActSkuGuidePO = new ActSkuGuidePO();
            updateActSkuGuidePO.setCatalogName(actSkuGuideReqBO.getCatalogName());
            updateActSkuGuidePO.setCatalogStatus(actSkuGuideReqBO.getCatalogStatus());
            updateActSkuGuidePO.setUpdateOperName(actSkuGuideReqBO.getName());
            updateActSkuGuidePO.setUpdateTime(new Date());
            updateActSkuGuidePO.setGuideCatalogId(actSkuGuideReqBO.getGuideCatalogId());
            int num = this.actSkuGuideMapper.update(updateActSkuGuidePO);
            if (num == 1) {
                ActSkuGuideBO actSkuGuideBO = new ActSkuGuideBO();
                BeanUtils.copyProperties(updateActSkuGuidePO, actSkuGuideBO);
                rspBO.setData(actSkuGuideBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }


        } else if (actSkuGuideList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    private void updateGuideState(ActSkuGuideReqBO actSkuGuideReqBO,ActSkuGuidePO actSkuGuidePO){
        ActSkuGuidePO updateActSkuGuidePO = new ActSkuGuidePO();
        updateActSkuGuidePO.setCatalogStatus(actSkuGuideReqBO.getCatalogStatus());
        updateActSkuGuidePO.setUpdateOperName(actSkuGuideReqBO.getName());
        updateActSkuGuidePO.setUpdateTime(new Date());
        updateActSkuGuidePO.setGuideCatalogId(actSkuGuideReqBO.getGuideCatalogId());
        this.actSkuGuideMapper.update(updateActSkuGuidePO);
        //判断类目等级，需要停启用一二级下的所有类目

        if(DycActivityConstants.CatalogLevel.ONE == actSkuGuidePO.getCatalogLevel()){
            //一级类目，查询所属的全部三级类目
            ActSkuGuidePO po1 = new ActSkuGuidePO();
            po1.setUpperCatalogId(actSkuGuidePO.getGuideCatalogId());
            List<ActSkuGuidePO> guidePOS2 = actSkuGuideMapper.selectByCondition(po1);
            if(!CollectionUtils.isEmpty(guidePOS2)){
                List<Long> catalogIds2 = guidePOS2.stream().map(a -> a.getGuideCatalogId()).collect(Collectors.toList());
                for (Long aLong : catalogIds2) {
                    ActSkuGuidePO updateActSkuGuidePO1 = new ActSkuGuidePO();
                    updateActSkuGuidePO1.setCatalogStatus(actSkuGuideReqBO.getCatalogStatus());
                    updateActSkuGuidePO1.setUpdateOperName(actSkuGuideReqBO.getName());
                    updateActSkuGuidePO1.setUpdateTime(new Date());
                    updateActSkuGuidePO1.setGuideCatalogId(aLong);
                    this.actSkuGuideMapper.update(updateActSkuGuidePO1);
                }
                ActSkuGuideExtPO extPO = new ActSkuGuideExtPO();
                extPO.setCatalogIds(catalogIds2);
                List<ActSkuGuideExtPO> guidePOS3 = actSkuGuideMapper.selectByIds(extPO);
                if(!CollectionUtils.isEmpty(guidePOS3)){
                    List<Long> catalogIds3 = guidePOS3.stream().map(a -> a.getGuideCatalogId()).collect(Collectors.toList());
                    for (Long aLong : catalogIds3) {
                        ActSkuGuidePO updateActSkuGuidePO1 = new ActSkuGuidePO();
                        updateActSkuGuidePO1.setCatalogStatus(actSkuGuideReqBO.getCatalogStatus());
                        updateActSkuGuidePO1.setUpdateOperName(actSkuGuideReqBO.getName());
                        updateActSkuGuidePO1.setUpdateTime(new Date());
                        updateActSkuGuidePO1.setGuideCatalogId(aLong);
                        this.actSkuGuideMapper.update(updateActSkuGuidePO1);
                    }
                }
            }
        }

        if(DycActivityConstants.CatalogLevel.TWO == actSkuGuidePO.getCatalogLevel()){
            //二级类目，查询所属的全部三级类目
            ActSkuGuidePO po1 = new ActSkuGuidePO();
            po1.setUpperCatalogId(actSkuGuidePO.getGuideCatalogId());
            List<ActSkuGuidePO> guidePOS3 = actSkuGuideMapper.selectByCondition(po1);
            if(!CollectionUtils.isEmpty(guidePOS3)){
                //判断三级类目对应有无商品数据
                List<Long> catalogIds3 = guidePOS3.stream().map(a -> a.getGuideCatalogId()).collect(Collectors.toList());
                for (Long aLong : catalogIds3) {
                    ActSkuGuidePO updateActSkuGuidePO1 = new ActSkuGuidePO();
                    updateActSkuGuidePO1.setCatalogStatus(actSkuGuideReqBO.getCatalogStatus());
                    updateActSkuGuidePO1.setUpdateOperName(actSkuGuideReqBO.getName());
                    updateActSkuGuidePO1.setUpdateTime(new Date());
                    updateActSkuGuidePO1.setGuideCatalogId(aLong);
                    this.actSkuGuideMapper.update(updateActSkuGuidePO1);
                }
            }
        }

    }


    @Override
    public ActSkuGuideRspBO saveActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO) {
        //新增信息
        if (actSkuGuideReqBO.getGuideCatalogId() == null) {
            return this.addActSkuGuide(actSkuGuideReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuGuide(actSkuGuideReqBO);
        }
    }

    @Override
    public ActSkuGuideRspBO deleteActSkuGuide(ActSkuGuideReqBO actSkuGuideReqBO) {
        ActSkuGuideRspBO rspBO = new ActSkuGuideRspBO();
        ActSkuGuidePO selectActSkuGuidePO = new ActSkuGuidePO();
        selectActSkuGuidePO.setGuideCatalogId(actSkuGuideReqBO.getGuideCatalogId());
        List<ActSkuGuidePO> actSkuGuideList = this.actSkuGuideMapper.selectByCondition(selectActSkuGuidePO);
        if (actSkuGuideList.size() == 1) {
            ActSkuGuidePO deleteActSkuGuidePO = new ActSkuGuidePO();
            deleteActSkuGuidePO.setGuideCatalogId(actSkuGuideReqBO.getGuideCatalogId());
            int num = this.actSkuGuideMapper.delete(deleteActSkuGuidePO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuGuideList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public DycActGuideDO qryGuideTree(DycActGuideQryDO reqBO) {
        DycActGuideDO dycActGuideDO = new DycActGuideDO();
        ActSkuGuideExtPO po = new ActSkuGuideExtPO();
        po.setPoolId(reqBO.getPoolId());
        if(reqBO.isExitStatus()){
            po.setCatalogStatus(1);
        }
        List<ActSkuGuideExtPO> actSkuGuideExtPOS = actSkuGuideMapper.selectGuideTree(po);
        List<DycActQueryCatalogTreeBO> catalogTreeList =  JUtil.jsl(actSkuGuideExtPOS, DycActQueryCatalogTreeBO.class);
        dycActGuideDO.setCatalogTreeList(catalogTreeList);
        return dycActGuideDO;
    }

    @Override
    public ActSkuGuideListRspBO getCatalogBOByCatalogIds(ActSkuGuideReqBO actSkuGuideReqBO) {
        ActSkuGuideExtPO po = new ActSkuGuideExtPO();
        po.setGuideCatalogIdList(actSkuGuideReqBO.getGuideCatalogIdList());
        List<ActSkuGuideExtPO> list = actSkuGuideMapper.getCatalogBOByCatalogIds(po);
        ActSkuGuideListRspBO rspBO = new ActSkuGuideListRspBO();
        if (!CollectionUtil.isEmpty(list)) {
            List<ActSkuGuideBO> jsl = ActRu.jsl(list, ActSkuGuideBO.class);
            Map<Long, ActSkuGuideBO> map = jsl.stream().collect(Collectors.toMap(ActSkuGuideBO::getGuideCatalogId, e -> e));
            rspBO.setCatalogBOByCatalogIds(map);
        }
        return rspBO;
    }

    @Override
    public DycActQueryCatalogListRspBO getCatalogNotChildSearch(DycActQueryCatalogListReqBO reqBO) {
        DycActQueryCatalogListRspBO rspBO = new DycActQueryCatalogListRspBO();
        List<DycActQueryCatalogListBO> rows = new ArrayList<>();

        if(reqBO.check()){
            //有条件搜索
            ActSkuGuidePO actSkuGuidePO  = JUtil.js(reqBO,ActSkuGuidePO.class);
            List<ActSkuGuidePO> actSkuGuidePOS = this.actSkuGuideMapper.selectByCondition(actSkuGuidePO);
            if (CollectionUtil.isEmpty(actSkuGuidePOS)) {
                rspBO.setRows(Collections.emptyList());
                rspBO.setPageNo(0);
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
                return rspBO;
            }
            rows = actSkuGuidePOS.stream().map(e -> JSON.parseObject(JSON.toJSONString(e), DycActQueryCatalogListBO.class)).collect(Collectors.toList());
        }

        // 存放最终树结构结果
        List<DycActQueryCatalogListBO> result = new ArrayList<>();
        // 查出所有的层级
        List<ActSkuGuidePO> queryAllCatalog = actSkuGuideMapper.selectByCondition(null);
        List<DycActQueryCatalogListBO> uccGuideCatalogBOList =
                queryAllCatalog.stream().map(e -> JUtil.js(e, DycActQueryCatalogListBO.class)).collect(Collectors.toList());

        // 将所有前台类目分组
//        Map<Long, List<UccGuideCatalogBO>> allPGroupMap = uccGuideCatalogBOList.stream().collect(Collectors.groupingBy(UccGuideCatalogBO::getUpperCatalogId));
        BuildTree buildTree;
        if (reqBO.check()) {
            // 根据level倒序排序
            List<DycActQueryCatalogListBO> sortByLevelUccGuideCatalogBOList = rows.stream().sorted(Comparator.comparing(DycActQueryCatalogListBO::getCatalogLevel).reversed()).collect(Collectors.toList());
            // 根据pId分组
            Map<Long, List<DycActQueryCatalogListBO>> pIdGroupMap = rows.stream().collect(Collectors.groupingBy(DycActQueryCatalogListBO::getUpperCatalogId));
            // 从子节点递归
            buildTree = new FromChildren();
            sortByLevelUccGuideCatalogBOList.forEach(e -> {
                if (Boolean.FALSE.equals(e.isFlag())) {
                    buildTree.buildTree(e, uccGuideCatalogBOList, result, pIdGroupMap);
                } else {
                    // 子节点向下递归
                    BuildTree fromRoot = new FromRoot();
                    fromRoot.buildTree(e, uccGuideCatalogBOList, result, pIdGroupMap);
                }
            });
            List<DycActQueryCatalogListBO> resultList = result.stream().sorted(Comparator.comparing(DycActQueryCatalogListBO::getViewOrder)).collect(Collectors.toList());
            rows = ListUtil.page(reqBO.getPageNo() - 1, reqBO.getPageSize(), resultList);
            rspBO.setRecordsTotal(resultList.size());
            rspBO.setRows(rows);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(rows.size());

        } else {
            ActSkuGuidePO po = new ActSkuGuidePO();
            po.setUpperCatalogId(0L);
            if(reqBO.getPageNo() == -1){
                List<ActSkuGuidePO>  uccCatalogDealPOList  = actSkuGuideMapper.selectByCondition(po);
                rows = uccCatalogDealPOList.stream().map(e -> {
                    DycActQueryCatalogListBO uccGuideCatalogBO = JUtil.js(e, DycActQueryCatalogListBO.class);
                    return uccGuideCatalogBO;
                }).collect(Collectors.toList());
                // 从根节点递归
                buildTree = new FromRoot();
                List<DycActQueryCatalogListBO> rootList = rows.stream().filter(e -> Long.valueOf(0).equals(e.getUpperCatalogId())).collect(Collectors.toList());
                rootList.forEach(e -> buildTree.buildTree(e, uccGuideCatalogBOList, result, null));
                rspBO.setRows(rows);
                rspBO.setPageNo(-1);
                rspBO.setTotal(-1);
                rspBO.setRecordsTotal(-1);
            }else {
                Page<ActSkuGuidePO>  uccCatalogDealPOList = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actSkuGuideMapper.selectByCondition(po));
                rows = uccCatalogDealPOList.stream().map(e -> {
                    DycActQueryCatalogListBO uccGuideCatalogBO = JUtil.js(e, DycActQueryCatalogListBO.class);
                    return uccGuideCatalogBO;
                }).collect(Collectors.toList());
                // 从根节点递归
                buildTree = new FromRoot();
                List<DycActQueryCatalogListBO> rootList = rows.stream().filter(e -> Long.valueOf(0).equals(e.getUpperCatalogId())).collect(Collectors.toList());
                rootList.forEach(e -> buildTree.buildTree(e, uccGuideCatalogBOList, result, null));
                rspBO.setRows(rows);
                rspBO.setPageNo(uccCatalogDealPOList.getPageNum());
                rspBO.setTotal(uccCatalogDealPOList.getPages());
                rspBO.setRecordsTotal((int)uccCatalogDealPOList.getTotal());
            }


        }

        return rspBO;
    }

    @Override
    public ActSkuGuideCheckDelRspBO checkDelCatalog(ActSkuGuideCheckDelReqBO reqBO) {
        ActSkuGuideCheckDelRspBO rspBO = new ActSkuGuideCheckDelRspBO();
        if(DycActivityConstants.CatalogLevel.ONE == reqBO.getCatalogLevel()){
            //一级类目，查询所属的全部三级类目
            ActSkuGuidePO po1 = new ActSkuGuidePO();
            po1.setUpperCatalogId(reqBO.getGuideCatalogId());
            List<ActSkuGuidePO> guidePOS2 = actSkuGuideMapper.selectByCondition(po1);
            if(CollectionUtils.isEmpty(guidePOS2)){
                //下级类目为空，则可以删除
                rspBO.setCheckFlag(true);
            }else {
                List<Long> catalogIds2 = guidePOS2.stream().map(a -> a.getGuideCatalogId()).collect(Collectors.toList());
                ActSkuGuideExtPO extPO = new ActSkuGuideExtPO();
                extPO.setCatalogIds(catalogIds2);
                List<ActSkuGuideExtPO> guidePOS3 = actSkuGuideMapper.selectByIds(extPO);
                if(CollectionUtils.isEmpty(guidePOS3)){
                    //下级类目为空，则可以删除
                    rspBO.setCheckFlag(true);
                }else {
                    //判断三级类目对应有无商品数据
                    List<Long> catalogIds3 = guidePOS3.stream().map(a -> a.getGuideCatalogId()).collect(Collectors.toList());
                    List<ActSkuInfoExtPO> actSkuInfoExtPOS = actSkuInfoMapper.selectByCatalogIds(catalogIds3);
                    if(!CollectionUtils.isEmpty(actSkuInfoExtPOS)){
                        rspBO.setCheckFlag(false);
                    }else {
                        rspBO.setCheckFlag(true);
                    }
                }
            }
        }

        if(DycActivityConstants.CatalogLevel.TWO == reqBO.getCatalogLevel()){
            //二级类目，查询所属的全部三级类目
            ActSkuGuidePO po1 = new ActSkuGuidePO();
            po1.setUpperCatalogId(reqBO.getGuideCatalogId());
            List<ActSkuGuidePO> guidePOS3 = actSkuGuideMapper.selectByCondition(po1);
            if(CollectionUtils.isEmpty(guidePOS3)){
                //下级类目为空，则可以删除
                rspBO.setCheckFlag(true);
            }else {
                //判断三级类目对应有无商品数据
                List<Long> catalogIds3 = guidePOS3.stream().map(a -> a.getGuideCatalogId()).collect(Collectors.toList());
                List<ActSkuInfoExtPO> actSkuInfoExtPOS = actSkuInfoMapper.selectByCatalogIds(catalogIds3);
                if(!CollectionUtils.isEmpty(actSkuInfoExtPOS)){
                    rspBO.setCheckFlag(false);
                }else {
                    rspBO.setCheckFlag(true);
                }
            }
        }

        if(DycActivityConstants.CatalogLevel.THREE == reqBO.getCatalogLevel()){
            //判断三级类目对应有无商品数据
            List<Long> catalogIds3 = new ArrayList<>();
            catalogIds3.add(reqBO.getGuideCatalogId());
            List<ActSkuInfoExtPO> actSkuInfoExtPOS = actSkuInfoMapper.selectByCatalogIds(catalogIds3);
            if(!CollectionUtils.isEmpty(actSkuInfoExtPOS)){
                rspBO.setCheckFlag(false);
            }else {
                rspBO.setCheckFlag(true);
            }
        }

        return rspBO;
    }

    @Override
    public ActSkuSortGuideRspBO changeCatalogOrder(ActSkuSortGuideReqBO reqBO) {
        ActSkuSortGuideRspBO rspBO = new ActSkuSortGuideRspBO();
        //查询上级类目id
        ActSkuGuidePO upperBo = new ActSkuGuidePO();
        upperBo.setGuideCatalogId(reqBO.getGuideCatalogId());
        List<ActSkuGuidePO> upperPos = actSkuGuideMapper.selectByCondition(upperBo);
        //查询得到自身类目的排序值
        ActSkuGuidePO uccCatalogDealPO = new ActSkuGuidePO();
        uccCatalogDealPO.setUpperCatalogId(upperPos.get(0).getUpperCatalogId());
        List<ActSkuGuidePO> actSkuGuidePOS = actSkuGuideMapper.selectByCondition(uccCatalogDealPO);
        if(!CollectionUtils.isEmpty(actSkuGuidePOS)){
            for (int i = 0; i < actSkuGuidePOS.size(); i++) {
                if (reqBO.getGuideCatalogId().equals(actSkuGuidePOS.get(i).getGuideCatalogId())) {
                    // 判断是不是最后一个或者第一个不做处理
                    if (reqBO.getOrderDesc() == 1) {
                        // 如果是第一个不做处理
                        if (i == 0) {
                            break;
                        }
                        ActSkuGuidePO mobilePO = new ActSkuGuidePO();
                        mobilePO.setGuideCatalogId(reqBO.getGuideCatalogId());
                        mobilePO.setViewOrder(actSkuGuidePOS.get(i - 1).getViewOrder());
                        mobilePO.setUpdateTime(new Date());
                        mobilePO.setUpdateOperName(reqBO.getName());
                        actSkuGuideMapper.update(mobilePO);
                        mobilePO.setGuideCatalogId(actSkuGuidePOS.get(i - 1).getGuideCatalogId());
                        mobilePO.setViewOrder(actSkuGuidePOS.get(i).getViewOrder());
                        mobilePO.setUpdateTime(new Date());
                        mobilePO.setUpdateOperName(reqBO.getName());
                        actSkuGuideMapper.update(mobilePO);
                    } else if (reqBO.getOrderDesc() == 2) {
                        // 如果是最后一个不做处理
                        if (i == actSkuGuidePOS.size() - 1) {
                            break;
                        }

                        ActSkuGuidePO mobilePO = new ActSkuGuidePO();
                        mobilePO.setGuideCatalogId(reqBO.getGuideCatalogId());
                        mobilePO.setViewOrder(actSkuGuidePOS.get(i + 1).getViewOrder());
                        mobilePO.setUpdateTime(new Date());
                        mobilePO.setUpdateOperName(reqBO.getName());
                        actSkuGuideMapper.update(mobilePO);
                        mobilePO.setGuideCatalogId(actSkuGuidePOS.get(i + 1).getGuideCatalogId());
                        mobilePO.setViewOrder(actSkuGuidePOS.get(i).getViewOrder());
                        mobilePO.setUpdateTime(new Date());
                        mobilePO.setUpdateOperName(reqBO.getName());
                        actSkuGuideMapper.update(mobilePO);
                    }
                    break;
                }
            }
        }
        return rspBO;
    }

    @Override
    public ActSkuSortGuideRspBO importGuide(List<DycActQueryCatalogListBO> guideBOList) {
        ActSkuSortGuideRspBO rspBO = new ActSkuSortGuideRspBO();
        addGuide(guideBOList);
        return rspBO;
    }

    @Override
    public ActSkuSortGuideRspBO importGuideTwo(List<DycActQueryCatalogListBO> guideBOList) {
        ActSkuSortGuideRspBO rspBO = new ActSkuSortGuideRspBO();
        addGuideTwo(guideBOList);
        return rspBO;
    }

    @Override
    public ActQueryCatalogDetailRspBO qryCatalogDetail(ActQueryCatalogDetailReqBO reqBO) {
        ActQueryCatalogDetailRspBO rspBO = new ActQueryCatalogDetailRspBO();

        ActSkuGuidePO po = new ActSkuGuidePO();
        po.setGuideCatalogId(reqBO.getGuideCatalogId());
        List<ActSkuGuidePO> actSkuGuidePOS = actSkuGuideMapper.selectByCondition(po);
        if(!CollectionUtils.isEmpty(actSkuGuidePOS)){
            rspBO.setCatalogName(actSkuGuidePOS.get(0).getCatalogName());
            rspBO.setGuideId(actSkuGuidePOS.get(0).getGuideCatalogId());
        }

        return rspBO;
    }

    /**
     * 新增前台类目信息
     * @param guideCatalogBOS
     */
    private void addGuide(List<DycActQueryCatalogListBO> guideCatalogBOS){
        List<Long> idList  = new ArrayList<>();
        List<ActSkuGuideExtPO> listAdd = new ArrayList<>();
        List<ActSkuGuidePO> record = new ArrayList<>();
        for (DycActQueryCatalogListBO guideCatalogBO : guideCatalogBOS) {
            if(!idList.contains(guideCatalogBO.getId())){
                ActSkuGuideExtPO po1 = new ActSkuGuideExtPO();
                po1.setGuideCatalogId(guideCatalogBO.getId());
                po1.setUpperCatalogId(0l);
                po1.setCatalogName(guideCatalogBO.getName());
                po1.setCatalogCode(guideCatalogBO.getId().toString());
                po1.setCatalogLevel(1);
                po1.setCatalogStatus(1);
                listAdd.add(po1);
                idList.add(guideCatalogBO.getId());
            }

            if(!idList.contains(guideCatalogBO.getId2())){
                ActSkuGuideExtPO po1 = new ActSkuGuideExtPO();
                po1.setGuideCatalogId(guideCatalogBO.getId2());
                po1.setUpperCatalogId(guideCatalogBO.getId());
                po1.setCatalogName(guideCatalogBO.getName2());
                po1.setCatalogCode(guideCatalogBO.getId2().toString());
                po1.setCatalogLevel(2);
                po1.setCatalogStatus(1);
                po1.setViewOrder(guideCatalogBO.getViewOrder2());
                listAdd.add(po1);
                idList.add(guideCatalogBO.getId2());
            }

            if(!idList.contains(guideCatalogBO.getId3())){
                ActSkuGuideExtPO po1 = new ActSkuGuideExtPO();
                po1.setGuideCatalogId(guideCatalogBO.getId3());
                po1.setUpperCatalogId(guideCatalogBO.getId2());
                po1.setCatalogName(guideCatalogBO.getName3());
                po1.setCatalogCode(guideCatalogBO.getId3().toString());
                po1.setCatalogLevel(3);
                po1.setCatalogStatus(1);
                po1.setViewOrder(guideCatalogBO.getViewOrder3());
                listAdd.add(po1);
                idList.add(guideCatalogBO.getId3());

            }
        }
        //对一级类目进行排序
//        List<ActSkuGuideExtPO> guide1List = listAdd.stream().filter(e -> e.getCatalogLevel() == 1).collect(Collectors.toList());
//        guide1List.stream()
//                .sorted(Comparator.comparingLong(ActSkuGuideExtPO::getGuideCatalogId).reversed())
//                .collect(Collectors.toList());
        for (int i = 0;i<listAdd.size();i++) {
            if(listAdd.get(i).getCatalogLevel() == 1){
                listAdd.get(i).setViewOrder(i);
                ActSkuGuidePO po = JUtil.js(listAdd.get(i), ActSkuGuidePO.class);
                record.add(po);
            }
        }

        //对二级类目排序
        Map<Long, List<ActSkuGuideExtPO>> map2 = listAdd.stream().filter(e -> e.getCatalogLevel() == 2).collect(Collectors.groupingBy(ActSkuGuideExtPO::getUpperCatalogId));
        for (Map.Entry<Long, List<ActSkuGuideExtPO>> entry : map2.entrySet()) {
            for (int i = 0;i<entry.getValue().size();i++) {
                entry.getValue().get(i).setViewOrder(i);
                ActSkuGuidePO po = JUtil.js(entry.getValue().get(i), ActSkuGuidePO.class);
                record.add(po);
            }
        }

        //对二级类目排序
        Map<Long, List<ActSkuGuideExtPO>> map3 = listAdd.stream().filter(e -> e.getCatalogLevel() == 3).collect(Collectors.groupingBy(ActSkuGuideExtPO::getUpperCatalogId));
        for (Map.Entry<Long, List<ActSkuGuideExtPO>> entry : map3.entrySet()) {
            for (int i = 0;i<entry.getValue().size();i++) {
                entry.getValue().get(i).setViewOrder(i);
                ActSkuGuidePO po = JUtil.js(entry.getValue().get(i), ActSkuGuidePO.class);
                record.add(po);
            }
        }

        actSkuGuideMapper.allInsertCopy(record);
    }

    /**
     * 新增前台类目信息
     * @param guideCatalogBOS
     */
    private void addGuideTwo(List<DycActQueryCatalogListBO> guideCatalogBOS){
        List<String> codeList  = new ArrayList<>();
        List<ActSkuGuideExtPO> listAdd = new ArrayList<>();
        List<ActSkuGuidePO> record = new ArrayList<>();
        Map<String,Long> codeToIdMap = new HashMap<>();
        for (DycActQueryCatalogListBO guideCatalogBO : guideCatalogBOS) {
            if(!codeList.contains(guideCatalogBO.getCode())){
                Long id1 = null;
                if (!codeToIdMap.containsKey(guideCatalogBO.getCode())) {
                    id1 = Sequence.getInstance().nextId();
                    codeToIdMap.put(guideCatalogBO.getCode(),id1);
                } else {
                    id1 = codeToIdMap.get(guideCatalogBO.getCode());
                }
                ActSkuGuideExtPO po1 = new ActSkuGuideExtPO();
                po1.setGuideCatalogId(id1);
                po1.setUpperCatalogId(0l);
                po1.setCatalogName(guideCatalogBO.getName());
                po1.setCatalogCode(guideCatalogBO.getCode());
                po1.setCatalogLevel(1);
                po1.setCatalogStatus(1);
                po1.setShopCatalogType(guideCatalogBO.getShopCatalogType());
                listAdd.add(po1);
                codeList.add(guideCatalogBO.getCode());
            }

            if(!codeList.contains(guideCatalogBO.getCode2())){
                Long id2 = null;
                if (!codeToIdMap.containsKey(guideCatalogBO.getCode2())) {
                    id2 = Sequence.getInstance().nextId();
                    codeToIdMap.put(guideCatalogBO.getCode2(),id2);
                } else {
                    id2 = codeToIdMap.get(guideCatalogBO.getCode2());
                }
                ActSkuGuideExtPO po2 = new ActSkuGuideExtPO();
                po2.setGuideCatalogId(id2);
                po2.setUpperCatalogId(codeToIdMap.get(guideCatalogBO.getCode()));
                po2.setCatalogName(guideCatalogBO.getName2());
                po2.setCatalogCode(guideCatalogBO.getCode2());
                po2.setCatalogLevel(2);
                po2.setCatalogStatus(1);
                po2.setViewOrder(guideCatalogBO.getViewOrder2());
                po2.setShopCatalogType(guideCatalogBO.getShopCatalogType());
                listAdd.add(po2);
                codeList.add(guideCatalogBO.getCode2());
            }

            if(!codeList.contains(guideCatalogBO.getCode3())){
                Long id3 = Sequence.getInstance().nextId();
                Long id2 = codeToIdMap.get(guideCatalogBO.getCode2());
                ActSkuGuideExtPO po3 = new ActSkuGuideExtPO();
                po3.setGuideCatalogId(id3);
                po3.setUpperCatalogId(id2);
                po3.setCatalogName(guideCatalogBO.getName3());
                po3.setCatalogCode(guideCatalogBO.getCode3());
                po3.setCatalogLevel(3);
                po3.setCatalogStatus(1);
                po3.setViewOrder(guideCatalogBO.getViewOrder3());
                po3.setShopCatalogType(guideCatalogBO.getShopCatalogType());
                listAdd.add(po3);
                codeList.add(guideCatalogBO.getCode3());

            }
        }
        //对一级类目进行排序
//        List<ActSkuGuideExtPO> guide1List = listAdd.stream().filter(e -> e.getCatalogLevel() == 1).collect(Collectors.toList());
//        guide1List.stream()
//                .sorted(Comparator.comparingLong(ActSkuGuideExtPO::getGuideCatalogId).reversed())
//                .collect(Collectors.toList());
        for (int i = 0;i<listAdd.size();i++) {
            if(listAdd.get(i).getCatalogLevel() == 1){
                listAdd.get(i).setViewOrder(i);
                ActSkuGuidePO po = JUtil.js(listAdd.get(i), ActSkuGuidePO.class);
                record.add(po);
            }
        }

        //对二级类目排序
        Map<Long, List<ActSkuGuideExtPO>> map2 = listAdd.stream().filter(e -> e.getCatalogLevel() == 2).collect(Collectors.groupingBy(ActSkuGuideExtPO::getUpperCatalogId));
        for (Map.Entry<Long, List<ActSkuGuideExtPO>> entry : map2.entrySet()) {
            for (int i = 0;i<entry.getValue().size();i++) {
                entry.getValue().get(i).setViewOrder(i);
                ActSkuGuidePO po = JUtil.js(entry.getValue().get(i), ActSkuGuidePO.class);
                record.add(po);
            }
        }

        //对二级类目排序
        Map<Long, List<ActSkuGuideExtPO>> map3 = listAdd.stream().filter(e -> e.getCatalogLevel() == 3).collect(Collectors.groupingBy(ActSkuGuideExtPO::getUpperCatalogId));
        for (Map.Entry<Long, List<ActSkuGuideExtPO>> entry : map3.entrySet()) {
            for (int i = 0;i<entry.getValue().size();i++) {
                entry.getValue().get(i).setViewOrder(i);
                ActSkuGuidePO po = JUtil.js(entry.getValue().get(i), ActSkuGuidePO.class);
                record.add(po);
            }
        }

        actSkuGuideMapper.allInsertCopyTwo(record);
    }

}
