package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogRspBO;
import com.tydic.dyc.act.repository.api.DycActSkuPriceLogRepository;
import com.tydic.dyc.act.repository.dao.ActSkuPriceLogMapper;
import com.tydic.dyc.act.repository.po.ActSkuPriceLogExtPO;
import com.tydic.dyc.act.repository.po.ActSkuPriceLogPO;
import com.tydic.dyc.act.utils.ActRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("actSkuPriceLogService")
public class DycActSkuPriceLogRepositoryImpl implements DycActSkuPriceLogRepository {

    @Autowired
    ActSkuPriceLogMapper actSkuPriceLogMapper;

    @Override
    public ActSkuPriceLogRspBO queryActSkuPriceLogSingle(ActSkuPriceLogReqBO actSkuPriceLogReqBO){
        ActSkuPriceLogRspBO rspBO = new ActSkuPriceLogRspBO();
        ActSkuPriceLogPO selectActSkuPriceLogPO = new ActSkuPriceLogPO();
        BeanUtils.copyProperties(actSkuPriceLogReqBO, selectActSkuPriceLogPO);
        List<ActSkuPriceLogPO> actSkuPriceLogList = this.actSkuPriceLogMapper.selectByCondition(selectActSkuPriceLogPO);
        if (actSkuPriceLogList.size() == 1) {
            ActSkuPriceLogBO actSkuPriceLogBO = new ActSkuPriceLogBO();
            BeanUtils.copyProperties(actSkuPriceLogList.get(0), actSkuPriceLogBO);
            rspBO.setData(actSkuPriceLogBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuPriceLogList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuPriceLogListRspBO queryActSkuPriceLogList(ActSkuPriceLogReqBO actSkuPriceLogReqBO) {
        ActSkuPriceLogListRspBO rspBO = new ActSkuPriceLogListRspBO();
        ActSkuPriceLogPO selectActSkuPriceLogPO = new ActSkuPriceLogPO();
        BeanUtils.copyProperties(actSkuPriceLogReqBO, selectActSkuPriceLogPO);
        List<ActSkuPriceLogPO> actSkuPriceLogPOList = this.actSkuPriceLogMapper.selectByCondition(selectActSkuPriceLogPO);

        List<ActSkuPriceLogBO> actSkuPriceLogBOList = new ArrayList<>();
        for (ActSkuPriceLogPO actSkuPriceLogPO : actSkuPriceLogPOList) {
            ActSkuPriceLogBO actSkuPriceLogBO = new ActSkuPriceLogBO();
            BeanUtils.copyProperties(actSkuPriceLogPO, actSkuPriceLogBO);
            actSkuPriceLogBOList.add(actSkuPriceLogBO);
        }

        rspBO.setData(actSkuPriceLogBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActSkuPriceLogBO> queryActSkuPriceLogListPage(ActSkuPriceLogReqBO actSkuPriceLogReqBO) {
        if (actSkuPriceLogReqBO.getPageNo() < 1) {
            actSkuPriceLogReqBO.setPageNo(1);
        }
        if (actSkuPriceLogReqBO.getPageSize() < 1) {
            actSkuPriceLogReqBO.setPageSize(10);
        }

        ActSkuPriceLogPO selectActSkuPriceLogPO = new ActSkuPriceLogPO();
        BeanUtils.copyProperties(actSkuPriceLogReqBO, selectActSkuPriceLogPO);
        Page<ActSkuPriceLogPO> page = PageHelper.startPage(actSkuPriceLogReqBO.getPageNo(), actSkuPriceLogReqBO.getPageSize()).doSelectPage(() -> this.actSkuPriceLogMapper.selectByCondition(selectActSkuPriceLogPO));

        //封装集合
        List<ActSkuPriceLogBO> actSkuPriceLogBOList = new ArrayList<>();
        for (ActSkuPriceLogPO actSkuPriceLogPO : page.getResult()) {
            ActSkuPriceLogBO actSkuPriceLogBO = new ActSkuPriceLogBO();
            BeanUtils.copyProperties(actSkuPriceLogPO, actSkuPriceLogBO);
            actSkuPriceLogBOList.add(actSkuPriceLogBO);
        }

        RspPage<ActSkuPriceLogBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuPriceLogBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActSkuPriceLogRspBO addActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO) {
        ActSkuPriceLogRspBO rspBO = new ActSkuPriceLogRspBO();

        ActSkuPriceLogPO insertActSkuPriceLogPO = new ActSkuPriceLogPO();
        BeanUtils.copyProperties(actSkuPriceLogReqBO, insertActSkuPriceLogPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuPriceLogPO.setSkuId(id);
        //TODO 封装其它信息

        int num = this.actSkuPriceLogMapper.insert(insertActSkuPriceLogPO);
        if (num == 1) {
            ActSkuPriceLogBO ActSkuPriceLogBO = new ActSkuPriceLogBO();
            BeanUtils.copyProperties(insertActSkuPriceLogPO, ActSkuPriceLogBO);
            rspBO.setData(ActSkuPriceLogBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuPriceLogListRspBO addListActSkuPriceLog(List<ActSkuPriceLogReqBO> actSkuPriceLogReqBO) {
        ActSkuPriceLogListRspBO rspBO = new ActSkuPriceLogListRspBO();
        for(int i = 0;i < actSkuPriceLogReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuPriceLogReqBO.get(i).setSkuId(id);
                }

        List<ActSkuPriceLogPO> insertActSkuPriceLogPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuPriceLogReqBO),ActSkuPriceLogPO.class);


        int num = this.actSkuPriceLogMapper.allInsert(insertActSkuPriceLogPO);
        if (num == actSkuPriceLogReqBO.size()) {
            List<ActSkuPriceLogBO> lActSkuPriceLogBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuPriceLogPO),ActSkuPriceLogBO.class);
            rspBO.setData(lActSkuPriceLogBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuPriceLogRspBO updateActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO) {
        ActSkuPriceLogRspBO rspBO = new ActSkuPriceLogRspBO();
        ActSkuPriceLogPO selectActSkuPriceLogPO = new ActSkuPriceLogPO();
        selectActSkuPriceLogPO.setSkuId(actSkuPriceLogReqBO.getSkuId());
        List<ActSkuPriceLogPO> actSkuPriceLogList = this.actSkuPriceLogMapper.selectByCondition(selectActSkuPriceLogPO);
        if (actSkuPriceLogList.size() == 1) {
            ActSkuPriceLogPO updateActSkuPriceLogPO = new ActSkuPriceLogPO();
            BeanUtils.copyProperties(actSkuPriceLogReqBO, updateActSkuPriceLogPO);

            int num = this.actSkuPriceLogMapper.update(updateActSkuPriceLogPO);
            if (num == 1) {
                ActSkuPriceLogBO actSkuPriceLogBO = new ActSkuPriceLogBO();
                BeanUtils.copyProperties(updateActSkuPriceLogPO, actSkuPriceLogBO);
                rspBO.setData(actSkuPriceLogBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuPriceLogList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuPriceLogRspBO saveActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO) {
        //新增信息
        if (actSkuPriceLogReqBO.getSkuId() == null) {
            return this.addActSkuPriceLog(actSkuPriceLogReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuPriceLog(actSkuPriceLogReqBO);
        }
    }

    @Override
    public ActSkuPriceLogRspBO deleteActSkuPriceLog(ActSkuPriceLogReqBO actSkuPriceLogReqBO) {
        ActSkuPriceLogRspBO rspBO = new ActSkuPriceLogRspBO();
        ActSkuPriceLogPO selectActSkuPriceLogPO = new ActSkuPriceLogPO();
        selectActSkuPriceLogPO.setSkuId(actSkuPriceLogReqBO.getSkuId());
        List<ActSkuPriceLogPO> actSkuPriceLogList = this.actSkuPriceLogMapper.selectByCondition(selectActSkuPriceLogPO);
        if (actSkuPriceLogList.size() == 1) {
            ActSkuPriceLogPO deleteActSkuPriceLogPO = new ActSkuPriceLogPO();
            BeanUtils.copyProperties(actSkuPriceLogReqBO, deleteActSkuPriceLogPO);

            int num = this.actSkuPriceLogMapper.delete(deleteActSkuPriceLogPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuPriceLogList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuPriceLogListRspBO qrySkuPriceLog(ActSkuPriceLogReqBO reqBO) {
        ActSkuPriceLogListRspBO rspBO = new ActSkuPriceLogListRspBO();
        ActSkuPriceLogExtPO po = ActRu.js(reqBO, ActSkuPriceLogExtPO.class);
        List<ActSkuPriceLogPO> logPOList = actSkuPriceLogMapper.qrySkuPriceLog(po);
        List<ActSkuPriceLogBO> actSkuPriceLogBOList = new ArrayList<>();
        for (ActSkuPriceLogPO actSkuPriceLogPO : logPOList) {
            ActSkuPriceLogBO actSkuPriceLogBO = new ActSkuPriceLogBO();
            BeanUtils.copyProperties(actSkuPriceLogPO, actSkuPriceLogBO);
            actSkuPriceLogBOList.add(actSkuPriceLogBO);
        }
        rspBO.setData(actSkuPriceLogBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

}
