package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActSkuSpecBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecReqBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecRspBO;
import com.tydic.dyc.act.repository.api.DycActSkuSpecRepository;
import com.tydic.dyc.act.repository.dao.ActSkuSpecMapper;
import com.tydic.dyc.act.repository.po.ActSkuSpecPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("actSkuSpecService")
public class DycActSkuSpecRepositoryImpl implements DycActSkuSpecRepository {

    @Autowired
    ActSkuSpecMapper actSkuSpecMapper;

    @Override
    public ActSkuSpecRspBO queryActSkuSpecSingle(ActSkuSpecReqBO actSkuSpecReqBO){
        ActSkuSpecRspBO rspBO = new ActSkuSpecRspBO();
        ActSkuSpecPO selectActSkuSpecPO = new ActSkuSpecPO();
        BeanUtils.copyProperties(actSkuSpecReqBO, selectActSkuSpecPO);
        List<ActSkuSpecPO> actSkuSpecList = this.actSkuSpecMapper.selectByCondition(selectActSkuSpecPO);
        if (actSkuSpecList.size() == 1) {
            ActSkuSpecBO actSkuSpecBO = new ActSkuSpecBO();
            BeanUtils.copyProperties(actSkuSpecList.get(0), actSkuSpecBO);
            rspBO.setData(actSkuSpecBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuSpecList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuSpecListRspBO queryActSkuSpecList(ActSkuSpecReqBO actSkuSpecReqBO) {
        ActSkuSpecListRspBO rspBO = new ActSkuSpecListRspBO();
        ActSkuSpecPO selectActSkuSpecPO = new ActSkuSpecPO();
        BeanUtils.copyProperties(actSkuSpecReqBO, selectActSkuSpecPO);
        List<ActSkuSpecPO> actSkuSpecPOList = this.actSkuSpecMapper.selectByCondition(selectActSkuSpecPO);

        List<ActSkuSpecBO> actSkuSpecBOList = new ArrayList<>();
        for (ActSkuSpecPO actSkuSpecPO : actSkuSpecPOList) {
            ActSkuSpecBO actSkuSpecBO = new ActSkuSpecBO();
            BeanUtils.copyProperties(actSkuSpecPO, actSkuSpecBO);
            actSkuSpecBOList.add(actSkuSpecBO);
        }

        rspBO.setData(actSkuSpecBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActSkuSpecBO> queryActSkuSpecListPage(ActSkuSpecReqBO actSkuSpecReqBO) {
        if (actSkuSpecReqBO.getPageNo() < 1) {
            actSkuSpecReqBO.setPageNo(1);
        }
        if (actSkuSpecReqBO.getPageSize() < 1) {
            actSkuSpecReqBO.setPageSize(10);
        }

        ActSkuSpecPO selectActSkuSpecPO = new ActSkuSpecPO();
        BeanUtils.copyProperties(actSkuSpecReqBO, selectActSkuSpecPO);
        Page<ActSkuSpecPO> page = PageHelper.startPage(actSkuSpecReqBO.getPageNo(), actSkuSpecReqBO.getPageSize()).doSelectPage(() -> this.actSkuSpecMapper.selectByCondition(selectActSkuSpecPO));

        //封装集合
        List<ActSkuSpecBO> actSkuSpecBOList = new ArrayList<>();
        for (ActSkuSpecPO actSkuSpecPO : page.getResult()) {
            ActSkuSpecBO actSkuSpecBO = new ActSkuSpecBO();
            BeanUtils.copyProperties(actSkuSpecPO, actSkuSpecBO);
            actSkuSpecBOList.add(actSkuSpecBO);
        }

        RspPage<ActSkuSpecBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuSpecBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActSkuSpecRspBO addActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO) {
        ActSkuSpecRspBO rspBO = new ActSkuSpecRspBO();

        ActSkuSpecPO insertActSkuSpecPO = new ActSkuSpecPO();
        BeanUtils.copyProperties(actSkuSpecReqBO, insertActSkuSpecPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuSpecPO.setSkuSpecId(id);
        //TODO 封装其它信息

        int num = this.actSkuSpecMapper.insert(insertActSkuSpecPO);
        if (num == 1) {
            ActSkuSpecBO ActSkuSpecBO = new ActSkuSpecBO();
            BeanUtils.copyProperties(insertActSkuSpecPO, ActSkuSpecBO);
            rspBO.setData(ActSkuSpecBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuSpecListRspBO addListActSkuSpec(List<ActSkuSpecReqBO> actSkuSpecReqBO) {
        ActSkuSpecListRspBO rspBO = new ActSkuSpecListRspBO();
        for(int i = 0;i < actSkuSpecReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuSpecReqBO.get(i).setSkuSpecId(id);
                }

        List<ActSkuSpecPO> insertActSkuSpecPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuSpecReqBO),ActSkuSpecPO.class);


        int num = this.actSkuSpecMapper.allInsert(insertActSkuSpecPO);
        if (num == actSkuSpecReqBO.size()) {
            List<ActSkuSpecBO> lActSkuSpecBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuSpecPO),ActSkuSpecBO.class);
            rspBO.setData(lActSkuSpecBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuSpecRspBO updateActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO) {
        ActSkuSpecRspBO rspBO = new ActSkuSpecRspBO();
        ActSkuSpecPO selectActSkuSpecPO = new ActSkuSpecPO();
        selectActSkuSpecPO.setSkuSpecId(actSkuSpecReqBO.getSkuSpecId());
        List<ActSkuSpecPO> actSkuSpecList = this.actSkuSpecMapper.selectByCondition(selectActSkuSpecPO);
        if (actSkuSpecList.size() == 1) {
            ActSkuSpecPO updateActSkuSpecPO = new ActSkuSpecPO();
            BeanUtils.copyProperties(actSkuSpecReqBO, updateActSkuSpecPO);

            int num = this.actSkuSpecMapper.update(updateActSkuSpecPO);
            if (num == 1) {
                ActSkuSpecBO actSkuSpecBO = new ActSkuSpecBO();
                BeanUtils.copyProperties(updateActSkuSpecPO, actSkuSpecBO);
                rspBO.setData(actSkuSpecBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuSpecList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuSpecRspBO saveActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO) {
        //新增信息
        if (actSkuSpecReqBO.getSkuSpecId() == null) {
            return this.addActSkuSpec(actSkuSpecReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuSpec(actSkuSpecReqBO);
        }
    }

    @Override
    public ActSkuSpecRspBO deleteActSkuSpec(ActSkuSpecReqBO actSkuSpecReqBO) {
        ActSkuSpecRspBO rspBO = new ActSkuSpecRspBO();
        ActSkuSpecPO selectActSkuSpecPO = new ActSkuSpecPO();
        selectActSkuSpecPO.setSkuSpecId(actSkuSpecReqBO.getSkuSpecId());
        List<ActSkuSpecPO> actSkuSpecList = this.actSkuSpecMapper.selectByCondition(selectActSkuSpecPO);
        if (actSkuSpecList.size() == 1) {
            ActSkuSpecPO deleteActSkuSpecPO = new ActSkuSpecPO();
            BeanUtils.copyProperties(actSkuSpecReqBO, deleteActSkuSpecPO);

            int num = this.actSkuSpecMapper.delete(deleteActSkuSpecPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuSpecList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

}
