package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActSkuVendorBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorReqBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorRspBO;
import com.tydic.dyc.act.repository.api.DycActSkuVendorRepository;
import com.tydic.dyc.act.repository.dao.ActRelSourcePoolMapper;
import com.tydic.dyc.act.repository.dao.ActSkuInfoMapper;
import com.tydic.dyc.act.repository.dao.ActSkuVendorMapper;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolNotRelVendorPageListBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolNotRelVendorPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolNotRelVendorPageListRspBO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("actSkuVendorService")
public class DycActSkuVendorRepositoryImpl implements DycActSkuVendorRepository {

    @Autowired
    ActSkuVendorMapper actSkuVendorMapper;
    @Autowired
    private ActSkuInfoMapper actSkuInfoMapper;
    @Autowired
    private ActRelSourcePoolMapper actRelSourcePoolMapper;

    @Override
    public ActSkuVendorRspBO queryActSkuVendorSingle(ActSkuVendorReqBO actSkuVendorReqBO){
        ActSkuVendorRspBO rspBO = new ActSkuVendorRspBO();
        ActSkuVendorExtPO selectActSkuVendorPO = new ActSkuVendorExtPO();
        BeanUtils.copyProperties(actSkuVendorReqBO, selectActSkuVendorPO);
        List<ActSkuVendorPO> actSkuVendorList = this.actSkuVendorMapper.selectByCondition(selectActSkuVendorPO);
        if (actSkuVendorList.size() == 1) {
            ActSkuVendorBO actSkuVendorBO = new ActSkuVendorBO();
            BeanUtils.copyProperties(actSkuVendorList.get(0), actSkuVendorBO);
            rspBO.setData(actSkuVendorBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuVendorList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuVendorListRspBO queryActSkuVendorList(ActSkuVendorReqBO actSkuVendorReqBO) {
        ActSkuVendorListRspBO rspBO = new ActSkuVendorListRspBO();
        ActSkuVendorExtPO selectActSkuVendorPO = new ActSkuVendorExtPO();
        BeanUtils.copyProperties(actSkuVendorReqBO, selectActSkuVendorPO);
        List<ActSkuVendorPO> actSkuVendorPOList = this.actSkuVendorMapper.selectByCondition(selectActSkuVendorPO);

        List<ActSkuVendorBO> actSkuVendorBOList = new ArrayList<>();
        for (ActSkuVendorPO actSkuVendorPO : actSkuVendorPOList) {
            ActSkuVendorBO actSkuVendorBO = new ActSkuVendorBO();
            BeanUtils.copyProperties(actSkuVendorPO, actSkuVendorBO);
            actSkuVendorBOList.add(actSkuVendorBO);
        }

        rspBO.setData(actSkuVendorBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActSkuVendorBO> queryActSkuVendorListPage(ActSkuVendorReqBO actSkuVendorReqBO) {
        if (actSkuVendorReqBO.getPageNo() < 1) {
            actSkuVendorReqBO.setPageNo(1);
        }
        if (actSkuVendorReqBO.getPageSize() < 1) {
            actSkuVendorReqBO.setPageSize(10);
        }

        ActSkuVendorExtPO selectActSkuVendorPO = new ActSkuVendorExtPO();
        BeanUtils.copyProperties(actSkuVendorReqBO, selectActSkuVendorPO);
        Page<ActSkuVendorPO> page = PageHelper.startPage(actSkuVendorReqBO.getPageNo(), actSkuVendorReqBO.getPageSize()).doSelectPage(() -> this.actSkuVendorMapper.selectByCondition(selectActSkuVendorPO));

        //封装集合
        List<ActSkuVendorBO> actSkuVendorBOList = new ArrayList<>();
        for (ActSkuVendorPO actSkuVendorPO : page.getResult()) {
            ActSkuVendorBO actSkuVendorBO = new ActSkuVendorBO();
            BeanUtils.copyProperties(actSkuVendorPO, actSkuVendorBO);
            actSkuVendorBOList.add(actSkuVendorBO);
        }

        RspPage<ActSkuVendorBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuVendorBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActSkuVendorRspBO addActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO) {
        ActSkuVendorRspBO rspBO = new ActSkuVendorRspBO();

        ActSkuVendorPO insertActSkuVendorPO = new ActSkuVendorPO();
        BeanUtils.copyProperties(actSkuVendorReqBO, insertActSkuVendorPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuVendorPO.setId(id);
        //TODO 封装其它信息

        int num = this.actSkuVendorMapper.insert(insertActSkuVendorPO);
        if (num == 1) {
            ActSkuVendorBO ActSkuVendorBO = new ActSkuVendorBO();
            BeanUtils.copyProperties(insertActSkuVendorPO, ActSkuVendorBO);
            rspBO.setData(ActSkuVendorBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuVendorListRspBO addListActSkuVendor(List<ActSkuVendorReqBO> actSkuVendorReqBO) {
        ActSkuVendorListRspBO rspBO = new ActSkuVendorListRspBO();
        for(int i = 0;i < actSkuVendorReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuVendorReqBO.get(i).setId(id);
                }

        List<ActSkuVendorPO> insertActSkuVendorPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuVendorReqBO),ActSkuVendorPO.class);


        int num = this.actSkuVendorMapper.allInsert(insertActSkuVendorPO);
        if (num == actSkuVendorReqBO.size()) {
            List<ActSkuVendorBO> lActSkuVendorBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuVendorPO),ActSkuVendorBO.class);
            rspBO.setData(lActSkuVendorBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuVendorRspBO updateActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO) {
        ActSkuVendorRspBO rspBO = new ActSkuVendorRspBO();
        ActSkuVendorExtPO selectActSkuVendorPO = new ActSkuVendorExtPO();
        selectActSkuVendorPO.setId(actSkuVendorReqBO.getId());
        List<ActSkuVendorPO> actSkuVendorList = this.actSkuVendorMapper.selectByCondition(selectActSkuVendorPO);
        if (actSkuVendorList.size() == 1) {
            ActSkuVendorPO updateActSkuVendorPO = new ActSkuVendorPO();
            BeanUtils.copyProperties(actSkuVendorReqBO, updateActSkuVendorPO);

            int num = this.actSkuVendorMapper.update(updateActSkuVendorPO);
            if (num == 1) {
                ActSkuVendorBO actSkuVendorBO = new ActSkuVendorBO();
                BeanUtils.copyProperties(updateActSkuVendorPO, actSkuVendorBO);
                rspBO.setData(actSkuVendorBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuVendorList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuVendorRspBO saveActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO) {
        //新增信息
        if (actSkuVendorReqBO.getId() == null) {
            return this.addActSkuVendor(actSkuVendorReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuVendor(actSkuVendorReqBO);
        }
    }

    @Override
    public ActSkuVendorRspBO deleteActSkuVendor(ActSkuVendorReqBO actSkuVendorReqBO) {
        ActSkuVendorRspBO rspBO = new ActSkuVendorRspBO();
        ActSkuVendorExtPO selectActSkuVendorPO = new ActSkuVendorExtPO();
        selectActSkuVendorPO.setId(actSkuVendorReqBO.getId());
        List<ActSkuVendorPO> actSkuVendorList = this.actSkuVendorMapper.selectByCondition(selectActSkuVendorPO);
        if (actSkuVendorList.size() == 1) {
            ActSkuVendorPO deleteActSkuVendorPO = new ActSkuVendorPO();
            BeanUtils.copyProperties(actSkuVendorReqBO, deleteActSkuVendorPO);

            int num = this.actSkuVendorMapper.delete(deleteActSkuVendorPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuVendorList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public DycActQuerySkuPoolNotRelVendorPageListRspBO querySkuPoolNotRelVendorPageList(DycActQuerySkuPoolNotRelVendorPageListReqBO reqBO) {
        DycActQuerySkuPoolNotRelVendorPageListRspBO rspBO = new DycActQuerySkuPoolNotRelVendorPageListRspBO();
        //查询商品池已关联供应商
        ActRelSourcePoolExtPO sourcePoolPO = new ActRelSourcePoolExtPO();
        sourcePoolPO.setPoolId(reqBO.getPoolId());
        List<ActRelSourcePoolPO> actRelSourcePoolPOS = actRelSourcePoolMapper.selectByCondition(sourcePoolPO);
        List<Long> vendorIds = new ArrayList<>();
        if(!CollectionUtils.isEmpty(actRelSourcePoolPOS)){
            vendorIds = actRelSourcePoolPOS.stream().map(a->a.getSourceId()).collect(Collectors.toList());
        }
        if(null != reqBO.getVendorId()){
            //查询单条供应商数据
            if(vendorIds.contains(reqBO.getVendorId())){
                //查询的该供应商已关联过该商品池
                rspBO.setPageNo(1);
                rspBO.setRows(new ArrayList<>());
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
            }else {
                ActSkuVendorPO vendorPO = new ActSkuVendorPO();
                vendorPO.setVendorId(reqBO.getVendorId());
                Page<ActSkuVendorPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actSkuVendorMapper.selectByPool(vendorPO));
                //封装集合
                List<DycActQuerySkuPoolNotRelVendorPageListBO> actSkuVendorBOList = new ArrayList<>();
                for (ActSkuVendorPO actSkuVendorPO : page.getResult()) {
                    DycActQuerySkuPoolNotRelVendorPageListBO bo = new DycActQuerySkuPoolNotRelVendorPageListBO();
                    bo.setVendorId(actSkuVendorPO.getVendorId());
                    bo.setVendorName(actSkuVendorPO.getVendorName());
                    //查询供应商对应商品数量
                    ActSkuInfoExtPO extPO = new ActSkuInfoExtPO();
                    extPO.setSupplierId(actSkuVendorPO.getVendorId());
                    List<ActSkuInfoPO> actSkuInfoPOS = actSkuInfoMapper.selectByCondition(extPO);
                    bo.setSkuNum(actSkuInfoPOS.size());
                    actSkuVendorBOList.add(bo);
                }
                rspBO.setPageNo(page.getPageNum());
                rspBO.setRows(actSkuVendorBOList);
                rspBO.setTotal(page.getPages());
                rspBO.setRecordsTotal((int) page.getTotal());
            }
        }else {
            ActSkuVendorPO vendorPO = new ActSkuVendorPO();
            vendorPO.setExtVendorIds(vendorIds);
            Page<ActSkuVendorPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actSkuVendorMapper.selectByPool(vendorPO));
            //封装集合
            List<DycActQuerySkuPoolNotRelVendorPageListBO> actSkuVendorBOList = new ArrayList<>();
            for (ActSkuVendorPO actSkuVendorPO : page.getResult()) {
                DycActQuerySkuPoolNotRelVendorPageListBO bo = new DycActQuerySkuPoolNotRelVendorPageListBO();
                bo.setVendorId(actSkuVendorPO.getVendorId());
                bo.setVendorName(actSkuVendorPO.getVendorName());
                //查询供应商对应商品数量
                ActSkuInfoExtPO extPO = new ActSkuInfoExtPO();
                extPO.setSupplierId(actSkuVendorPO.getVendorId());
                List<ActSkuInfoPO> actSkuInfoPOS = actSkuInfoMapper.selectByCondition(extPO);
                bo.setSkuNum(actSkuInfoPOS.size());
                actSkuVendorBOList.add(bo);
            }
            rspBO.setPageNo(page.getPageNum());
            rspBO.setRows(actSkuVendorBOList);
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal((int) page.getTotal());
        }
        return rspBO;
    }

}
