package com.tydic.dyc.act.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: ActActivitySkuChangePriceLogPO
 * @Description: ActActivitySkuChangePriceLogPO
 * @author: liaoyang
 * @date: 2024年05月16日10:30:46
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActActivitySkuChangePriceLogPO implements Serializable {
	private static final long serialVersionUID = 1L;
	/**
	 * 主键
	 */
    private Long id;
	/**
	 * 活动ID
	 */
    private Long activityId;
	/**
	 * 单品ID
	 */
    private Long skuId;
	/**
	 * 外部单品ID
	 */
    private String extSkuId;
	/**
	 * 单品名称
	 */
    private String skuName;
	/**
	 * 单品主图路径
	 */
    private String skuPicUrl;
	/**
	 * 销售单位
	 */
    private String measureName;
	/**
	 * 69码
	 */
    private String upc;
	/**
	 * 变动时间
	 */
    private Date changeTime;
	/**
	 * 变动前价格
	 */
    private BigDecimal changeBeforePrice;
	/**
	 * 变动后价格
	 */
    private BigDecimal changeAfterPrice;
	/**
	 * 变动标识 1涨价 2降价
	 */
	private Integer changeFlag;

}