package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActFscInvoicePO
 * @Description: ActFscInvoicePO
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActFscInvoicePO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 发票主键ID
	 */
    private Long invoiceId;
	/**
	 * 结算单ID
	 */
    private Long fscOrderId;
	/**
	 * 开票日期
	 */
    private String billDate;
	/**
	 * 税额
	 */
    private BigDecimal taxAmt;
	/**
	 * 发票金额
	 */
    private BigDecimal amt;
	/**
	 * 发票金额(不含税)
	 */
    private BigDecimal untaxAmt;
	/**
	 * 发票编号
	 */
    private String invoiceNo;
	/**
	 * 发票代码
	 */
    private String invoiceCode;
	/**
	 * 发票抬头
	 */
    private String buyName;
	/**
	 * 纳税识别号
	 */
    private String taxNo;
	/**
	 * 发票类型 00增值税专用发票 01普通发票
	 */
    private String invoiceType;
	/**
	 * 发票类别 1纸质发票 2电子发票
	 */
    private Integer invoiceCategory;
	/**
	 * 开户银行
	 */
    private String bank;
	/**
	 * 开户账号
	 */
    private String account;
	/**
	 * 地址
	 */
    private String address;
	/**
	 * 电话
	 */
    private String phone;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人用户id
	 */
    private String createUserId;
	/**
	 * 创建人用户名称
	 */
    private String createUserName;
	/**
	 * 创建人机构ID
	 */
    private Long createOrgId;
	/**
	 * 创建人机构名称
	 */
    private String createOrgName;
	/**
	 * 创建人单位ID
	 */
    private Long createCompanyId;
	/**
	 * 创建人单位名称
	 */
    private String createCompanyName;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 更新工号
	 */
    private String updateOperId;
	/**
	 * 发票校验码
	 */
    private String verificationCode;
	/**
	 * 是否删除 1是 0否
	 */
    private Integer delFlag;
	/**
	 * 是否获取发票明细：0未获取，1已获取
	 */
    private Integer invoiceItemFlag;
	/**
	 * 任务ID
	 */
	private Long taskId;
	/**
	 * 发票ID集合
	 */
	private List<Long> invoiceIds;
}