package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;

/**
 * @ClassName: ActFscOrderInvoicePO
 * @Description: ActFscOrderInvoicePO
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActFscOrderInvoicePO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 结算单ID
	 */
    private Long fscOrderId;
	/**
	 * 发票抬头
	 */
    private String buyName;
	/**
	 * 纳税识别号
	 */
    private String taxNo;
	/**
	 * 发票类型 00增值税专用发票 01普通发票
	 */
    private String invoiceType;
	/**
	 * 发票类别 1纸质发票 2电子发票
	 */
    private Integer invoiceCategory;
	/**
	 * 开户银行
	 */
    private String bank;
	/**
	 * 开户账号
	 */
    private String account;
	/**
	 * 地址
	 */
    private String address;
	/**
	 * 电话
	 */
    private String phone;
	/**
	 * 省
	 */
    private String province;
	/**
	 * 市
	 */
    private String city;
	/**
	 * 区
	 */
    private String area;
	/**
	 * 乡镇
	 */
    private String town;
	/**
	 * 省编码
	 */
    private String provinceCode;
	/**
	 * 市编码
	 */
    private String cityCode;
	/**
	 * 区编码
	 */
    private String areaCode;
	/**
	 * 乡镇编码
	 */
    private String townCode;
	/**
	 * 详细地址
	 */
    private String receiveAddr;
	/**
	 * 收票人
	 */
    private String receiveName;
	/**
	 * 收票电话
	 */
    private String receivePhone;
	/**
	 * 收票邮箱
	 */
    private String receiveEmail;

}