package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: ActivityBaseInfoPO
 * @Description: ActivityBaseInfoPO
 * @author: zhoulu
 * @date: 2023年12月11日16:44:00
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActivityBaseInfoTimePO extends ActivityBaseInfoPO implements Serializable {


	private static final long serialVersionUID = -6997032197626712294L;
	/**
	 * 当前登录人Id
	 */
	private Long userId;
	/**
	 * 页签Id：1：待审批；2：已审批；3：全部
	 */
	private String tabId;
	/**
	 * 活动创建开始时间
	 */
	private Date createStartTime;
	/**
	 * 活动创建结束时间
	 */
	private Date createEndTime;
	/**
	 * 活动更新开始时间
	 */
	private Date updateStartTime;
	/**
	 * 活动更新结束时间
	 */
	private Date updateEndTime;
	/**
	 * 当前节点状态1审批中2已审批
	 */
	private Integer CurrentNodeStatus;
	/**
	 * 待审批人id
	 */
	private Long pendingAuditUserId;

	private Integer taskStatus;

}