package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActivityChangeRelaCommodityPO
 * @Description: ActivityChangeRelaCommodityPO
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActivityChangeRelaCommodityCatalogInComPO implements Serializable {


	private static final long serialVersionUID = -5877030138716617289L;
	/**
	 * 关联ID
	 */
    private Long relaId;

	/**
	 * 关联id集合
	 */
	private List<Long> relaIdList;
	/**
	 * 变更单ID
	 */
    private Long changeId;

	/**
	 * 商品池名称
	 */
    private String commodityPoolName;

	/**
	 * 单品ID
	 */
    private Long skuId;
	/**
	 * 单品编码
	 */
    private String skuCode;
	/**
	 * 单品名称
	 */
    private String skuName;

	/**
	 * 单品图片地址
	 */
	private String skuUrl;
	/**
	 * 单品详情
	 */
    private String skuDetails;

	/**
	 * 一级类目id
	 */
	private String firstCatalogId;

	/**
	 * 一级类目名称
	 */
	private String firstCatalogName;

	/**
	 * 二级类目id
	 */
	private String secondCatalogId;

	/**
	 * 二级类目名称
	 */
	private String secondCatalogName;

	/**
	 * 三级类目id
	 */
	private String threeCatalogId;

	/**
	 * 三级类目名称
	 */
	private String threeCatalogName;

	/**
	 * C端链接
	 */
	private String cterminalUrl;

	/**
	 * 品牌
	 */
	private String brand;

	/**
	 * 价格
	 */
	private BigDecimal price;

	/**
	 * 好评率
	 */
	private Double favorableRate;

	/**
	 * 删除标志
            0:未删除；1：已删除
	 */
    private Integer delFlag;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 创建人ID
	 */
    private Long createUserId;
	/**
	 * 创建人名称
	 */
    private String createUserName;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 更新人名称
	 */
    private String updateUserName;
	/**
	 * 更新人ID
	 */
    private Long updateUserId;
	/**
	 * 单品状态：1：已上架 2：已下架 0 ：已删除'
	 */
	private Integer skuStatus;
	/**
	 * 创建时间
	 */
	private Date createTimeEnd;
	/**
	 * 创建时间
	 */
	private Date createTimeStart;
	/**
	 * 更新时间
	 */
	private Date updateTimeStart;
	/**
	 * 更新时间
	 */
	private Date updateTimeEnd;

	/**
	 * 排序
	 */
	private String orderBy;

	private String extSkuId;

	/**
	 * 三级类目id集合
	 */
	private List<String> threeCatalogIds;

	private Integer comCount;
}