package com.tydic.dyc.act.repository.dao;


import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.act.repository.po.ActActivityAppraiseInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题：ActActivityAppraiseInfoPO
 * 说明：活动评价MAPPER
 * 时间：2024/5/8 4:43 下午
 * 作者：汪成松
 */
@Mapper
@Repository
public interface ActActivityAppraiseInfoMapper {

	/**
	 * 插入单条数据
	 *
	 * @param actActivityAppraiseInfoPo 参数对象
	 * @return int 影响数量
	 */
	int insert(ActActivityAppraiseInfoPO actActivityAppraiseInfoPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param actActivityAppraiseInfoPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(ActActivityAppraiseInfoPO actActivityAppraiseInfoPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param actActivityAppraiseInfoPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(ActActivityAppraiseInfoPO actActivityAppraiseInfoPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") ActActivityAppraiseInfoPO set, @Param("where") ActActivityAppraiseInfoPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param actActivityAppraiseInfoPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(ActActivityAppraiseInfoPO actActivityAppraiseInfoPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param actActivityAppraiseInfoPo 参数对象
	 * @return ActActivityAppraiseInfoPO 结果对象
	 */
	ActActivityAppraiseInfoPO getModelBy(ActActivityAppraiseInfoPO actActivityAppraiseInfoPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param actActivityAppraiseInfoPo 参数对象
	 * @return List<ActActivityAppraiseInfoPO> 结果对象
	 */
	List<ActActivityAppraiseInfoPO> getList(ActActivityAppraiseInfoPO actActivityAppraiseInfoPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param actActivityAppraiseInfoPo 参数对象
	 * @param page 分页参数
	 * @return List<ActActivityAppraiseInfoPO> 结果对象
	 */
	List<ActActivityAppraiseInfoPO> getListPage(ActActivityAppraiseInfoPO actActivityAppraiseInfoPo, Page<ActActivityAppraiseInfoPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<ActActivityAppraiseInfoPO> list);

}
