package com.tydic.dyc.act.repository.dao;


import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.act.repository.po.ActActivityChangeUserScoresChangePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * 描述：活动变更用户积分变动表
 * 
 * @author ZhouYuyan
 * @date 2024-04-16 19:48
 **/
@Mapper
@Repository
public interface ActActivityChangeUserScoresChangeMapper {

	/**
	 * 插入单条数据
	 *
	 * @param actActivityChangeUserScoresChangePo 参数对象
	 * @return int 影响数量
	 */
	int insert(ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo);

	/**
	 * 根据条件删除数据
	 *
	 * @param actActivityChangeUserScoresChangePo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param actActivityChangeUserScoresChangePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") ActActivityChangeUserScoresChangePO set, @Param("where") ActActivityChangeUserScoresChangePO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param actActivityChangeUserScoresChangePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param actActivityChangeUserScoresChangePo 参数对象
	 * @return ActActivityChangeUserScoresChangePO 结果对象
	 */
	ActActivityChangeUserScoresChangePO getModelBy(ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param actActivityChangeUserScoresChangePo 参数对象
	 * @return List<ActActivityChangeUserScoresChangePO> 结果对象
	 */
	List<ActActivityChangeUserScoresChangePO> getList(ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param actActivityChangeUserScoresChangePo 参数对象
	 * @param page 分页参数
	 * @return List<ActActivityChangeUserScoresChangePO> 结果对象
	 */
	List<ActActivityChangeUserScoresChangePO> getListPage(ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo, Page<ActActivityChangeUserScoresChangePO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<ActActivityChangeUserScoresChangePO> list);

}
