package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.model.bo.DycActFscInvoiceAmt;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceAmtDO;
import com.tydic.dyc.act.repository.po.ActFscInvoicePO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActFscInvoiceMapper
 * @Description: ActFscInvoiceMapper
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActFscInvoiceMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActFscInvoicePO>
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    List<ActFscInvoicePO> selectByCondition(ActFscInvoicePO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int delete(ActFscInvoicePO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int insert(ActFscInvoicePO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int allInsert(List<ActFscInvoicePO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int update(ActFscInvoicePO record);
    /**
     * 描述: 根据条件查询单条数据
     *
     * @throws
     * @param: po
     * @return: List<ActFscInvoicePO>
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    ActFscInvoicePO selectOneByCondition(ActFscInvoicePO record);

    List<DycActFscInvoiceAmt> getInvoiceAmtByFscOrderIds(DycActFscInvoiceAmtDO record);

    ActFscInvoicePO getSumAmtByFscOrderId(ActFscInvoicePO record);

    int getCountUnGetItem(ActFscInvoicePO record);

    List<ActFscInvoicePO> getInvoiceIdByTaskId(ActFscInvoicePO record);
}
