package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActFscOrderPO;
import com.tydic.dyc.act.repository.po.ActFscOrderQryPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActFscOrderMapper
 * @Description: ActFscOrderMapper
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActFscOrderMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActFscOrderPO>
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    List<ActFscOrderPO> selectByCondition(ActFscOrderPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int delete(ActFscOrderPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int insert(ActFscOrderPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int allInsert(List<ActFscOrderPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int update(ActFscOrderPO record);

    /**
     * 根据结算单ID查询单个结算单
     * @param record
     * @return
     */
    ActFscOrderPO getFscOrderOne(ActFscOrderPO record);

    /**
     * 查询未签收的结算单
     * @param record
     * @return
     */
    List<Long> getUnSignFscOrder(ActFscOrderPO record);
    /**
     * 查询未付款的结算单
     * @param record
     * @return
     */
    List<Long> getUnPayFscOrder(ActFscOrderPO record);

    int updateAlertType(ActFscOrderPO record);

    /**
     * 获取预警结算单
     * @return
     */
    List<ActFscOrderPO> getFscOrderWarning(ActFscOrderQryPO record);

    int clearAlertType(ActFscOrderPO record);

    ActFscOrderPO getActivityCreateInfo(ActFscOrderPO record);
}
