package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActSkuPoolExtPO;
import com.tydic.dyc.act.repository.po.ActSkuPoolPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActSkuPoolMapper
 * @Description: ActSkuPoolMapper
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActSkuPoolMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActSkuPoolPO>
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    List<ActSkuPoolPO> selectByCondition(ActSkuPoolExtPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int delete(ActSkuPoolPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int insert(ActSkuPoolPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int allInsert(List<ActSkuPoolPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int update(ActSkuPoolPO record);

    List<ActSkuPoolExtPO> selectBySkuIdsCondition(@Param("skuIds") List<Long> skuIds);

    List<ActSkuPoolExtPO> getListPage(ActSkuPoolExtPO qryPO);

    List<ActSkuPoolExtPO> getSkuNum(ActSkuPoolExtPO qryPO);

    List<ActSkuPoolExtPO> getListSkuPool(ActSkuPoolExtPO qryPo);

    /**
     * 查询商品池 act_rel_sku_pool关联
     * @param qryPo
     * @return
     */
    List<ActSkuPoolExtPO> getListSkuPoolRelSku(ActSkuPoolExtPO qryPo);

    /**
     * 查询商品池 act_rel_source_pool关联
     * @param qryPo
     * @return
     */
    List<ActSkuPoolExtPO> getListSkuPoolRelSource(ActSkuPoolExtPO qryPo);

    List<ActSkuPoolExtPO> getPoolNameBySkuId(ActSkuPoolExtPO skuByName);

    List<ActSkuPoolExtPO> getPoolNameBySupplierId(ActSkuPoolExtPO supplierByName);

    List<ActSkuPoolExtPO> getPoolNameByGuideId(ActSkuPoolExtPO guideByName);
}
