package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityChangeSupplierInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityChangeSupplierInfoMapper
 * @Description: ActivityChangeSupplierInfoMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:44:00
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityChangeSupplierInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityChangeSupplierInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityChangeSupplierInfoPO> selectByCondition(ActivityChangeSupplierInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int delete(ActivityChangeSupplierInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int insert(ActivityChangeSupplierInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int allInsert(List<ActivityChangeSupplierInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int update(ActivityChangeSupplierInfoPO record);

    /**
     * 活动变更供应商移除（批量）服务
     * @param record
     * @return
     */
    int batchRemoveActivityChangeSupplier(List<ActivityChangeSupplierInfoPO> record);

    /**
     * 插入单条数据
     *
     * @param activityChangeSupplierInfoPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityChangeSupplierInfoPO activityChangeSupplierInfoPo);


    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityChangeSupplierInfoPO set, @Param("where") ActivityChangeSupplierInfoPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityChangeSupplierInfoPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityChangeSupplierInfoPO activityChangeSupplierInfoPo);

    /**
     * 根据条件查询单条数据
     *
     * @param activityChangeSupplierInfoPo 参数对象
     * @return ActActivityChangeSupplierInfoPO 结果对象
     */
    ActivityChangeSupplierInfoPO getModelBy(ActivityChangeSupplierInfoPO activityChangeSupplierInfoPo);

    /**
     * 根据条件查询列表数据
     *
     * @param activityChangeSupplierInfoPo 参数对象
     * @return List<ActActivityChangeSupplierInfoPO> 结果对象
     */
    List<ActivityChangeSupplierInfoPO> getList(ActivityChangeSupplierInfoPO activityChangeSupplierInfoPo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityChangeSupplierInfoPO> list);
}
