package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityFlowTaskPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityFlowTaskMapper
 * @Description: ActivityFlowTaskMapper
 * @author: zhoulu
 * @date: 2023年12月19日15:49:50
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityFlowTaskMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityFlowTaskPO>
     * @author: zhoulu
     * @date: 2023年12月19日15:49:50
     */
    List<ActivityFlowTaskPO> selectByCondition(ActivityFlowTaskPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月19日15:49:50
     */
    int delete(ActivityFlowTaskPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月19日15:49:50
     */
    int insert(ActivityFlowTaskPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月19日15:49:50
     */
    int allInsert(List<ActivityFlowTaskPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月19日15:49:50
     */
    int update(ActivityFlowTaskPO record);

    int updateBatchState(@Param("taskId") List<String> taskId);
	
}
