package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivitySupplierInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivitySupplierInfoMapper
 * @Description: ActivitySupplierInfoMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivitySupplierInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivitySupplierInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivitySupplierInfoPO> selectByCondition(ActivitySupplierInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int delete(ActivitySupplierInfoPO record);
    /**
     * 描述: 根据条件批量删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    void deleteBatchByActivityId(@Param("ids") List<Long> ids, Long activityId);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActivitySupplierInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActivitySupplierInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int update(ActivitySupplierInfoPO record);

    /**
     * 插入单条数据
     *
     * @param activitySupplierInfoPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivitySupplierInfoPO activitySupplierInfoPo );

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivitySupplierInfoPO set, @Param("where") ActivitySupplierInfoPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activitySupplierInfoPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivitySupplierInfoPO activitySupplierInfoPo );

    /**
     * 根据条件查询单条数据
     *
     * @param activitySupplierInfoPo 参数对象
     * @return ActActivitySupplierInfoPO 结果对象
     */
    ActivitySupplierInfoPO getModelBy(ActivitySupplierInfoPO activitySupplierInfoPo );

    /**
     * 根据条件查询列表数据
     *
     * @param activitySupplierInfoPo 参数对象
     * @return List<ActActivitySupplierInfoPO> 结果对象
     */
    List<ActivitySupplierInfoPO> getList(ActivitySupplierInfoPO activitySupplierInfoPo );

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivitySupplierInfoPO> list);

    List<ActivitySupplierInfoPO> batchQrySupplier(ActivitySupplierInfoPO activitySupplierInfoPo );
	
}
