package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActUserScoresBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityUserInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: ActivityUserInfoMapper
 * @Description: ActivityUserInfoMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityUserInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityUserInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivityUserInfoPO> selectByCondition(ActivityUserInfoPO record);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityUserInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivityUserInfoPO> selectByNotInPoolCondition(ActivityUserInfoPO record);
    List<ActivityUserInfoPO> selectByNotInUserMapCondition(ActivityUserInfoPO record);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityUserInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivityUserInfoPO> selectByConditionGiveScores(ActivityUserInfoPO record);
    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int delete(ActivityUserInfoPO record);

    /**
     * 描述:
     *
     * @param userIdList, activityId, updateUserId, updateUserName, updateStartTime
     * @return int
     */
    int batchRemoveActivityUser(@Param("userIdList") List<Long> userIdList, @Param("activityUserInfoPO") ActivityUserInfoPO activityUserInfoPO);

    int batchUpdateUserGiveScores(@Param("userIdList") List<Long> userIdList, @Param("activityUserInfoPO") ActivityUserInfoPO activityUserInfoPO);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActivityUserInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActivityUserInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int update(ActivityUserInfoPO record);

    BigDecimal selectCountUserScores(ActivityUserInfoPO record);

    int selectCountUser(ActivityUserInfoPO record);

    /**
     * 按用户id查询用户参与的活动
     * @param userId
     * @return
     */
    List<ActivityBaseInfoPO> selectActByUserId(@Param("userId") Long userId);

    /**
     * 用户积分信息查询
     * @param record
     * @return
     */
    List<ActUserScoresBaseInfoPO> queryUserScoresPageList(ActUserScoresBaseInfoPO record);

    /**
     * 插入单条数据
     *
     * @param activityUserInfoPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityUserInfoPO activityUserInfoPo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityUserInfoPO set, @Param("where") ActivityUserInfoPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityUserInfoPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityUserInfoPO activityUserInfoPo);

    /**
     * 根据条件查询单条数据
     *
     * @param activityUserInfoPo 参数对象
     * @return ActActivityUserInfoPO 结果对象
     */
    ActivityUserInfoPO getModelBy(ActivityUserInfoPO activityUserInfoPo);

    /**
     * 根据条件查询列表数据
     *
     * @param activityUserInfoPo 参数对象
     * @return List<ActActivityUserInfoPO> 结果对象
     */
    List<ActivityUserInfoPO> getList(ActivityUserInfoPO activityUserInfoPo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityUserInfoPO> list);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityUserInfoPo 参数对象
     * @return int 总数量
     */
    int getCheckByNewByCheck(ActivityUserInfoPO activityUserInfoPo);

    int selectNotUsedScores(ActivityUserInfoPO record);

    List<ActivityUserInfoPO> selectByScorseLimit(ActivityUserInfoPO record);

    /**
     * 用户积分信息查询
     * @param record
     * @return
     */
    List<ActUserScoresBaseInfoPO> queryUserScoresPageListByApp(ActUserScoresBaseInfoPO record);

    int count(ActivityUserInfoPO activityUserInfoPO);

    BigDecimal sumScores(ActivityUserInfoPO activityUserInfoPO);
}
