package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.act.model.bo.ActActivityChangeUserScoresChangeDO;
import com.tydic.dyc.act.repository.api.ActActivityChangeUserScoresChangeRepository;
import com.tydic.dyc.act.repository.dao.ActActivityChangeUserScoresChangeMapper;
import com.tydic.dyc.act.repository.po.ActActivityChangeUserScoresChangePO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：ActActivityChangeUserScoresChangeRepositoryImpl
 * 说明：活动变更积分记录表
 * 时间：2024/4/16 8:03 下午
 * 作者：汪成松
 */
@Service
public class ActActivityChangeUserScoresChangeRepositoryImpl implements ActActivityChangeUserScoresChangeRepository {

    @Autowired
    private ActActivityChangeUserScoresChangeMapper actActivityChangeUserScoresChangeMapper;

    @Override
    public int insert(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo) {
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo = JSONObject.parseObject(JSONObject.toJSONString(actActivityChangeUserScoresChangeDo), ActActivityChangeUserScoresChangePO.class);
        return actActivityChangeUserScoresChangeMapper.insert(actActivityChangeUserScoresChangePo);
    }

    @Override
    public int deleteBy(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo) {
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo = JSONObject.parseObject(JSONObject.toJSONString(actActivityChangeUserScoresChangeDo), ActActivityChangeUserScoresChangePO.class);
        return actActivityChangeUserScoresChangeMapper.deleteBy(actActivityChangeUserScoresChangePo);
    }

    @Override
    public int updateById(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo) {
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo = JSONObject.parseObject(JSONObject.toJSONString(actActivityChangeUserScoresChangeDo), ActActivityChangeUserScoresChangePO.class);
        return actActivityChangeUserScoresChangeMapper.updateById(actActivityChangeUserScoresChangePo);
    }

    @Override
    public int updateBy(ActActivityChangeUserScoresChangeDO set, ActActivityChangeUserScoresChangeDO where) {
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePoSet = JSONObject.parseObject(JSONObject.toJSONString(set), ActActivityChangeUserScoresChangePO.class);
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePoWhere = JSONObject.parseObject(JSONObject.toJSONString(where), ActActivityChangeUserScoresChangePO.class);
        return actActivityChangeUserScoresChangeMapper.updateBy(actActivityChangeUserScoresChangePoSet,actActivityChangeUserScoresChangePoWhere);
    }

    @Override
    public int getCheckBy(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo) {
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo = JSONObject.parseObject(JSONObject.toJSONString(actActivityChangeUserScoresChangeDo), ActActivityChangeUserScoresChangePO.class);
        return actActivityChangeUserScoresChangeMapper.getCheckBy(actActivityChangeUserScoresChangePo);
    }

    @Override
    public ActActivityChangeUserScoresChangeDO getModelBy(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo) {
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo = JSONObject.parseObject(JSONObject.toJSONString(actActivityChangeUserScoresChangeDo), ActActivityChangeUserScoresChangePO.class);
        ActActivityChangeUserScoresChangePO modelBy = actActivityChangeUserScoresChangeMapper.getModelBy(actActivityChangeUserScoresChangePo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy),ActActivityChangeUserScoresChangeDO.class);
    }

    @Override
    public List<ActActivityChangeUserScoresChangeDO> getList(ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo) {
        ActActivityChangeUserScoresChangePO actActivityChangeUserScoresChangePo = JSONObject.parseObject(JSONObject.toJSONString(actActivityChangeUserScoresChangeDo), ActActivityChangeUserScoresChangePO.class);
        List<ActActivityChangeUserScoresChangePO> list = actActivityChangeUserScoresChangeMapper.getList(actActivityChangeUserScoresChangePo);
        if (CollectionUtils.isNotEmpty(list)){
            return JSONObject.parseArray(JSONObject.toJSONString(list),ActActivityChangeUserScoresChangeDO.class);
        }else {
            return new ArrayList<>();
        }
    }

    @Override
    public void insertBatch(List<ActActivityChangeUserScoresChangeDO> list) {
        List<ActActivityChangeUserScoresChangePO> actActivityChangeUserScoresChangePoList = JSONObject.parseArray(JSONObject.toJSONString(list), ActActivityChangeUserScoresChangePO.class);
        actActivityChangeUserScoresChangeMapper.insertBatch(actActivityChangeUserScoresChangePoList);
    }
}
