package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActActivityCommodityCatalogSumDO;
import com.tydic.dyc.act.model.bo.ActActivityCommodityCatalogSumInfo;
import com.tydic.dyc.act.repository.api.ActActivityCommodityCatalogSumRepository;
import com.tydic.dyc.act.repository.dao.ActActivityCommodityCatalogSumMapper;
import com.tydic.dyc.act.repository.po.ActActivityCommodityCatalogSumPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 标题：ActActivityCommodityCatalogSumRepositoryImpl
 * 说明：
 * 时间： 2024-06-04 15:51
 * 作者 @author LY
 */
@Service
public class ActActivityCommodityCatalogSumRepositoryImpl implements ActActivityCommodityCatalogSumRepository {

    @Autowired
    private ActActivityCommodityCatalogSumMapper actActivityCommodityCatalogSumMapper;


    @Override
    public int addActActivityCommodityCatalogSum(ActActivityCommodityCatalogSumDO reqBO) {
        ActActivityCommodityCatalogSumPO sumPO = JSON.parseObject(JSON.toJSONString(reqBO), ActActivityCommodityCatalogSumPO.class);
        sumPO.setId(Sequence.getInstance().nextId());
        sumPO.setCreateTime(new Date());
        return actActivityCommodityCatalogSumMapper.insert(sumPO);
    }

    @Override
    public List<ActActivityCommodityCatalogSumInfo> queryActActivityCommodityCatalogSumList(ActActivityCommodityCatalogSumDO reqBO) {
        ActActivityCommodityCatalogSumPO sumPO = JSON.parseObject(JSON.toJSONString(reqBO), ActActivityCommodityCatalogSumPO.class);
        List<ActActivityCommodityCatalogSumPO> sumPOS = actActivityCommodityCatalogSumMapper.selectByCondition(sumPO);
        return JSON.parseArray(JSON.toJSONString(sumPOS), ActActivityCommodityCatalogSumInfo.class);
    }
}
