package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActJdUidUserMapDO;
import com.tydic.dyc.act.model.bo.ActJdUidUserMapInfo;
import com.tydic.dyc.act.repository.api.ActJdUidUserMapRepository;
import com.tydic.dyc.act.repository.dao.ActJdUidUserMapMapper;
import com.tydic.dyc.act.repository.po.ActJdUidUserMapPO;
import com.tydic.dyc.act.service.bo.ActJdUidUserMapBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题：ActJdUidUserMapRepositoryImpl
 * 说明：
 * 时间： 2024-07-10 10:35
 * 作者 @author LY
 */
@Service
public class ActJdUidUserMapRepositoryImpl implements ActJdUidUserMapRepository {
    @Autowired
    private ActJdUidUserMapMapper actJdUidUserMapMapper;

    @Override
    public List<ActJdUidUserMapInfo> queryActJdUidUserMapList(ActJdUidUserMapDO reqBO) {
        ActJdUidUserMapPO selectActJdUidUserMapPO = JSON.parseObject(JSON.toJSONString(reqBO), ActJdUidUserMapPO.class);
        List<ActJdUidUserMapPO> actJdUidUserMapPOList = this.actJdUidUserMapMapper.selectByCondition(selectActJdUidUserMapPO);
        return JSON.parseArray(JSON.toJSONString(actJdUidUserMapPOList), ActJdUidUserMapInfo.class);
    }

    @Override
    public BasePageRspBo<ActJdUidUserMapBO> queryActJdUidUserMapListPage(ActJdUidUserMapDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActJdUidUserMapPO selectActJdUidUserMapPO = JSON.parseObject(JSON.toJSONString(reqBO), ActJdUidUserMapPO.class);
        Page<ActJdUidUserMapPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actJdUidUserMapMapper.selectByCondition(selectActJdUidUserMapPO));
        List<ActJdUidUserMapBO> array = JSON.parseArray(JSON.toJSONString(page.getResult()), ActJdUidUserMapBO.class);

        BasePageRspBo<ActJdUidUserMapBO> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(array);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public int addActJdUidUserMap(ActJdUidUserMapDO reqBO) {
        ActJdUidUserMapPO insertActJdUidUserMapPO = JSON.parseObject(JSON.toJSONString(reqBO), ActJdUidUserMapPO.class);
        long id = Sequence.getInstance().nextId();
        insertActJdUidUserMapPO.setUid(id);
        return this.actJdUidUserMapMapper.insert(insertActJdUidUserMapPO);
    }


    @Override
    public int addBatchActJdUidUserMap(List<ActJdUidUserMapDO> reqBO) {
        List<ActJdUidUserMapPO> insertActJdUidUserMapPO = JSON.parseArray(JSON.toJSONString(reqBO), ActJdUidUserMapPO.class);
        return this.actJdUidUserMapMapper.addBatch(insertActJdUidUserMapPO);

    }

    @Override
    public int updateActJdUidUserMap(ActJdUidUserMapDO reqBO) {
        ActJdUidUserMapPO updateActJdUidUserMapPO = JSON.parseObject(JSON.toJSONString(reqBO), ActJdUidUserMapPO.class);
        return this.actJdUidUserMapMapper.update(updateActJdUidUserMapPO);
    }

    @Override
    public int saveActJdUidUserMap(ActJdUidUserMapDO reqBO) {
        if (reqBO.getUid() == null) {
            //新增信息
            return this.addActJdUidUserMap(reqBO);
        } else {
            //修改信息
            return this.updateActJdUidUserMap(reqBO);
        }
    }

    @Override
    public int deleteActJdUidUserMap(ActJdUidUserMapDO reqBO) {
        ActJdUidUserMapPO deleteActJdUidUserMapPO = JSON.parseObject(JSON.toJSONString(reqBO), ActJdUidUserMapPO.class);
        return this.actJdUidUserMapMapper.delete(deleteActJdUidUserMapPO);
    }
}
