package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActNotifyDelayBO;
import com.tydic.dyc.act.model.bo.ActNotifyDelayListRspBO;
import com.tydic.dyc.act.model.bo.ActNotifyDelayReqBO;
import com.tydic.dyc.act.model.bo.ActNotifyDelayRspBO;
import com.tydic.dyc.act.repository.api.ActNotifyDelayRepository;
import com.tydic.dyc.act.repository.dao.ActNotifyDelayMapper;
import com.tydic.dyc.act.repository.po.ActNotifyDelayPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ActNotifyDelayRepositoryImpl implements ActNotifyDelayRepository {

    @Autowired
    private ActNotifyDelayMapper actNotifyDelayMapper;

    @Override
    public ActNotifyDelayRspBO queryActNotifyDelaySingle(ActNotifyDelayReqBO reqBO) {
        ActNotifyDelayRspBO rspBO = new ActNotifyDelayRspBO();
        ActNotifyDelayPO selectActNotifyDelayPO = JSON.parseObject(JSON.toJSONString(reqBO), ActNotifyDelayPO.class);
        List<ActNotifyDelayPO> actNotifyDelayList = this.actNotifyDelayMapper.selectByCondition(selectActNotifyDelayPO);
        if (actNotifyDelayList.size() == 1) {
            rspBO.setData(JSON.parseObject(JSON.toJSONString(actNotifyDelayList.get(0)), ActNotifyDelayBO.class));
        }
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public ActNotifyDelayListRspBO queryActNotifyDelayList(ActNotifyDelayReqBO reqBO) {
        ActNotifyDelayListRspBO rspBO = new ActNotifyDelayListRspBO();
        ActNotifyDelayPO selectActNotifyDelayPO = JSON.parseObject(JSON.toJSONString(reqBO), ActNotifyDelayPO.class);
        List<ActNotifyDelayPO> actNotifyDelayPOList = this.actNotifyDelayMapper.selectByCondition(selectActNotifyDelayPO);

        rspBO.setData(JSON.parseArray(JSON.toJSONString(actNotifyDelayPOList), ActNotifyDelayBO.class));
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public BasePageRspBo<ActNotifyDelayBO> queryActNotifyDelayListPage(ActNotifyDelayReqBO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActNotifyDelayPO selectActNotifyDelayPO = JSON.parseObject(JSON.toJSONString(reqBO), ActNotifyDelayPO.class);
        Page<ActNotifyDelayPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actNotifyDelayMapper.selectByCondition(selectActNotifyDelayPO));
        List<ActNotifyDelayBO> array = JSON.parseArray(JSON.toJSONString(page.getResult()), ActNotifyDelayBO.class);

        BasePageRspBo<ActNotifyDelayBO> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(array);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public int addActNotifyDelay(ActNotifyDelayReqBO reqBO) {
        ActNotifyDelayPO insertActNotifyDelayPO = JSON.parseObject(JSON.toJSONString(reqBO), ActNotifyDelayPO.class);
        long id = Sequence.getInstance().nextId();
        insertActNotifyDelayPO.setId(id);
        return this.actNotifyDelayMapper.insert(insertActNotifyDelayPO);
    }


    @Override
    public int addBatchActNotifyDelay(List<ActNotifyDelayReqBO> reqBO) {
        List<ActNotifyDelayPO> insertActNotifyDelayPO = JSON.parseArray(JSON.toJSONString(reqBO), ActNotifyDelayPO.class);

        insertActNotifyDelayPO.forEach(item -> {
            long id = Sequence.getInstance().nextId();
            item.setId(id);
        });
        return this.actNotifyDelayMapper.addBatch(insertActNotifyDelayPO);

    }

    @Override
    public int updateActNotifyDelay(ActNotifyDelayReqBO reqBO) {
        ActNotifyDelayPO updateActNotifyDelayPO = JSON.parseObject(JSON.toJSONString(reqBO), ActNotifyDelayPO.class);
        return this.actNotifyDelayMapper.update(updateActNotifyDelayPO);
    }

    @Override
    public int saveActNotifyDelay(ActNotifyDelayReqBO reqBO) {
        if (reqBO.getId() == null) {
            //新增信息
            return this.addActNotifyDelay(reqBO);
        } else {
            //修改信息
            return this.updateActNotifyDelay(reqBO);
        }
    }

    @Override
    public int deleteActNotifyDelay(ActNotifyDelayReqBO reqBO) {
        ActNotifyDelayPO deleteActNotifyDelayPO = JSON.parseObject(JSON.toJSONString(reqBO), ActNotifyDelayPO.class);
        return this.actNotifyDelayMapper.delete(deleteActNotifyDelayPO);
    }

}
