package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityCatalogRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityCatalogMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityCatalogPO;
import com.tydic.dyc.act.utils.ActRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题：DycActActivityChangeCommodityCatalogRepositoryImpl
 * 说明：活动商品类目
 * 时间：2024/4/17 7:06 下午
 * 作者：汪成松
 */
@Service
public class DycActActivityChangeCommodityCatalogRepositoryImpl implements DycActActivityChangeCommodityCatalogRepository {

    @Autowired
    private ActivityChangeRelaCommodityCatalogMapper activityChangeRelaCommodityCatalogMapper;

    @Override
    public int insertNew(DycActivityChangeRelaCommodityCatalogInfo reqBo) {
        ActivityChangeRelaCommodityCatalogPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogPO.class);
        return activityChangeRelaCommodityCatalogMapper.insertNew(insert);
    }

    @Override
    public void delete(DycActivityChangeRelaCommodityCatalogInfo record) {
        ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPO = ActRu.js(record,ActivityChangeRelaCommodityCatalogPO.class);
        activityChangeRelaCommodityCatalogMapper.delete(activityChangeRelaCommodityCatalogPO);
    }

    @Override
    public int updateByNew(DycActivityChangeRelaCommodityCatalogInfo set, DycActivityChangeRelaCommodityCatalogInfo where) {
        ActivityChangeRelaCommodityCatalogPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityChangeRelaCommodityCatalogPO.class);
        ActivityChangeRelaCommodityCatalogPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityChangeRelaCommodityCatalogPO.class);
        return activityChangeRelaCommodityCatalogMapper.updateBy(setPo,wherePo);
    }

    @Override
    public int getCheckByNew(DycActivityChangeRelaCommodityCatalogInfo reqBo) {
        ActivityChangeRelaCommodityCatalogPO checkBy = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogPO.class);
        return activityChangeRelaCommodityCatalogMapper.getCheckBy(checkBy);
    }

    @Override
    public DycActivityChangeRelaCommodityCatalogInfo getModelByNew(DycActivityChangeRelaCommodityCatalogInfo reqBo) {
        ActivityChangeRelaCommodityCatalogPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogPO.class);
        ActivityChangeRelaCommodityCatalogPO modelBy = activityChangeRelaCommodityCatalogMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActivityChangeRelaCommodityCatalogInfo.class);
    }

    @Override
    public List<DycActivityChangeRelaCommodityCatalogInfo> getListNew(DycActivityChangeRelaCommodityCatalogInfo reqBo) {
        ActivityChangeRelaCommodityCatalogPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogPO.class);
        List<ActivityChangeRelaCommodityCatalogPO> list = activityChangeRelaCommodityCatalogMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActivityChangeRelaCommodityCatalogInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityChangeRelaCommodityCatalogInfo> list) {
        List<ActivityChangeRelaCommodityCatalogPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityChangeRelaCommodityCatalogPO.class);
        activityChangeRelaCommodityCatalogMapper.insertBatch(listPo);
    }
}
