package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityCatalogInComRepository;
import com.tydic.dyc.act.repository.dao.ActivityRelaCommodityCatalogInComMapper;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityCatalogInComExtPO;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityCatalogInComPO;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityPO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：DycActActivityCommodityRepositoryImpl
 * 说明：活动已选商品池列表分页查询
 * 时间： 2023-12-13 15:43
 * 作者 @author LY
 */
@Service
public class DycActActivityCommodityCatalogInComRepositoryImpl implements DycActActivityCommodityCatalogInComRepository {

    @Autowired
    private ActivityRelaCommodityCatalogInComMapper activityRelaCommodityCatalogInComMapper;

    @Override
    public void delete(DycActivityDO record) {
        ActivityRelaCommodityCatalogInComPO activityRelaCommodityPO = ActRu.js(record, ActivityRelaCommodityCatalogInComPO.class);
        activityRelaCommodityCatalogInComMapper.delete(activityRelaCommodityPO);
    }


    @Override
    public int batchSelectActivityCommodity(DycActivityDO reqBO) {
        List<ActivityRelaCommodityCatalogInComPO> collect = reqBO.getActActivityRelaCommodityBOS().stream().map(item -> {
            ActivityRelaCommodityCatalogInComPO commodityPO = new ActivityRelaCommodityCatalogInComPO();
            BeanUtils.copyProperties(item, commodityPO);
            commodityPO.setActivityId(reqBO.getActivityId());
            commodityPO.setCreateTime(new Date());
            commodityPO.setCreateUserId(reqBO.getCreateUserId());
            commodityPO.setRelaId(Sequence.getInstance().nextId());
            commodityPO.setDelFlag(0);
            commodityPO.setCreateUserName(reqBO.getCreateUserName());
            return commodityPO;
        }).collect(Collectors.toList());
        return activityRelaCommodityCatalogInComMapper.allInsert(collect);
    }

    @Override
    public int batchRemoveActivityCommodity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getSkuIdList().size() < 1) {
            throw new ZTBusinessException("商品id不能为空！");
        }
        ActivityRelaCommodityCatalogInComExtPO commodityExtPO = new ActivityRelaCommodityCatalogInComExtPO();
        commodityExtPO.setActivityId(reqBO.getActivityId());
        commodityExtPO.setUpdateTime(new Date());
        commodityExtPO.setUpdateUserId(reqBO.getUpdateUserId());
        commodityExtPO.setUpdateUserName(reqBO.getUpdateUserName());
        commodityExtPO.setSkuIds(reqBO.getSkuIdList());

        return activityRelaCommodityCatalogInComMapper.batchRemoveActivityCommodity(commodityExtPO);
    }

    @Override
    public int deleteActivityCommodity(DycActivityDO reqBO) {
        ActivityRelaCommodityCatalogInComPO commodityPO = new ActivityRelaCommodityCatalogInComPO();
        commodityPO.setActivityId(reqBO.getActivityId());
        commodityPO.setUpdateTime(new Date());
        commodityPO.setUpdateUserId(reqBO.getUpdateUserId());
        commodityPO.setUpdateUserName(reqBO.getUpdateUserName());
        commodityPO.setDelFlag(1);
        return activityRelaCommodityCatalogInComMapper.update(commodityPO);
    }

    @Override
    public int selectCountCommodity(DycActivityDO reqBO) {
        ActivityRelaCommodityCatalogInComPO activityRelaCommodityPO = new ActivityRelaCommodityCatalogInComPO();
        activityRelaCommodityPO.setActivityId(reqBO.getActivityId());
        return activityRelaCommodityCatalogInComMapper.selectCountCommodity(activityRelaCommodityPO);
    }


    @Override
    public int updateCommodity(DycActActivityRelaCommodityInfo reqBO) {
        ActivityRelaCommodityCatalogInComPO activityRelaCommodityPO = ActRu.js(reqBO, ActivityRelaCommodityCatalogInComPO.class);
        return activityRelaCommodityCatalogInComMapper.update(activityRelaCommodityPO);
    }

    @Override
    public int updateByThreeCatalogIds(DycActActivityRelaCommodityInfo reqBO) {
        ActivityRelaCommodityCatalogInComPO activityRelaCommodityPO = ActRu.js(reqBO, ActivityRelaCommodityCatalogInComPO.class);
        return activityRelaCommodityCatalogInComMapper.updateByThreeCatalogIds(activityRelaCommodityPO);
    }

    /**
     * 批量更新
     *
     * @param list
     */
    @Override
    public void updateBatch(List<DycActActivityRelaCommodityInfo> list) {
        List<ActivityRelaCommodityCatalogInComPO> activityRelaCommodityPOS = ActRu.jsl(list, ActivityRelaCommodityCatalogInComPO.class);
        activityRelaCommodityCatalogInComMapper.updateBatch(activityRelaCommodityPOS);
    }

    @Override
    public int updateCommodityState(DycActivityDO reqBO) {
        ActivityRelaCommodityCatalogInComPO activityRelaCommodityPO = ActRu.js(reqBO, ActivityRelaCommodityCatalogInComPO.class);
        return activityRelaCommodityCatalogInComMapper.updateCommodityState(activityRelaCommodityPO);
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> selectByOnShelf(DycActivityDO reqBO) {
        ActivityRelaCommodityCatalogInComPO setPo = ActRu.js(reqBO, ActivityRelaCommodityCatalogInComPO.class);
        List<ActivityRelaCommodityCatalogInComPO> list = activityRelaCommodityCatalogInComMapper.selectByOnShelf(setPo);
        return ActRu.jsl(list, DycActActivityRelaCommodityInfo.class);
    }

    @Override
    public int count(DycActActivityRelaCommodityInfo record) {
        ActivityRelaCommodityCatalogInComExtPO activityRelaCommodityExtPO = ActRu.js(record, ActivityRelaCommodityCatalogInComExtPO.class);
        return activityRelaCommodityCatalogInComMapper.count(activityRelaCommodityExtPO);
    }

    @Override
    public BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        BasePageRspBo<DycActActivityRelaCommodityInfo> rspBo = new BasePageRspBo<>();
        ActivityRelaCommodityCatalogInComPO activityRelaCommodityPO = new ActivityRelaCommodityCatalogInComPO();
        BeanUtils.copyProperties(reqBO, activityRelaCommodityPO);
        Page<ActivityRelaCommodityCatalogInComPO> page = new Page<>();
        if (!ObjectUtils.isEmpty(reqBO) && null == reqBO.getQuoteActivity()) {
            page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityCatalogInComMapper.selectByCondition(activityRelaCommodityPO));
        } else if (!ObjectUtils.isEmpty(reqBO) && null != reqBO.getQuoteActivity()) {
            page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityCatalogInComMapper.selectByOnAll(activityRelaCommodityPO));
        }
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<DycActActivityRelaCommodityInfo> collect = page.getResult().stream().map(item -> {
            DycActActivityRelaCommodityInfo info = new DycActActivityRelaCommodityInfo();
            BeanUtils.copyProperties(item, info);
            info.setCatalogNameStr(item.getFirstCatalogName() + ">" + item.getSecondCatalogName() + ">" + item.getThreeCatalogName());
            if (info.getFavorableRate() != null) {
                if (info.getFavorableRate() % info.getFavorableRate().intValue() == 0) {
                    info.setFavorableRateStr(item.getFavorableRate().intValue() + "%");
                } else {
                    info.setFavorableRateStr(item.getFavorableRate() + "%");
                }
            } else {
                info.setFavorableRateStr("-");
            }
            info.setSkuStatusStr(DycActivityTransFieldUtil.SkuStatusStr(String.valueOf(info.getSkuStatus())));
            info.setSyncStateStr(DycActivityTransFieldUtil.SyncStateStr(String.valueOf(info.getSyncState())));
            return info;
        }).collect(Collectors.toList());

        rspBo.setRows(collect);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public List<Long> queryActivityCommodityCatalogList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        ActivityRelaCommodityCatalogInComPO activityRelaCommodityPO = new ActivityRelaCommodityCatalogInComPO();
        BeanUtils.copyProperties(reqBO, activityRelaCommodityPO);
        if (!ObjectUtils.isEmpty(reqBO) && null == reqBO.getQuoteActivity()) {
            return this.activityRelaCommodityCatalogInComMapper.selectCatalogByCondition(activityRelaCommodityPO);
        } else if (!ObjectUtils.isEmpty(reqBO) && null != reqBO.getQuoteActivity()) {
            return this.activityRelaCommodityCatalogInComMapper.selectCatalogByOnAll(activityRelaCommodityPO);
        }
        return new ArrayList<>();
    }


    @Override
    public void insertAllCommodity(List<DycActActivityRelaCommodityInfo> dycActActivityRelaCommodityInfoList) {
        List<ActivityRelaCommodityCatalogInComPO> activityRelaCommodityPoList = JSONObject.parseArray(JSONObject.toJSONString(dycActActivityRelaCommodityInfoList), ActivityRelaCommodityCatalogInComPO.class);
        activityRelaCommodityCatalogInComMapper.allInsert(activityRelaCommodityPoList);
    }

    @Override
    public int insertNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityCatalogInComPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogInComPO.class);
        return activityRelaCommodityCatalogInComMapper.insertNew(insert);
    }

    @Override
    public int updateByNew(DycActActivityRelaCommodityInfo set, DycActActivityRelaCommodityInfo where) {
        ActivityRelaCommodityCatalogInComPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityRelaCommodityCatalogInComPO.class);
        ActivityRelaCommodityCatalogInComPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityRelaCommodityCatalogInComPO.class);
        return activityRelaCommodityCatalogInComMapper.updateBy(setPo, wherePo);
    }

    @Override
    public int getCheckByNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityCatalogInComPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogInComPO.class);
        return activityRelaCommodityCatalogInComMapper.getCheckBy(insert);
    }

    @Override
    public DycActActivityRelaCommodityInfo getModelByNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityCatalogInComPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogInComPO.class);
        ActivityRelaCommodityCatalogInComPO modelBy = activityRelaCommodityCatalogInComMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActActivityRelaCommodityInfo.class);
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> getListNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityCatalogInComPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogInComPO.class);
        List<ActivityRelaCommodityCatalogInComPO> list = activityRelaCommodityCatalogInComMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActActivityRelaCommodityInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActActivityRelaCommodityInfo> list) {
        List<ActivityRelaCommodityCatalogInComPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityRelaCommodityCatalogInComPO.class);
        activityRelaCommodityCatalogInComMapper.insertBatch(listPo);
    }

    @Override
    public DycActGuideDO querySelectCatalogTree(ActSelectQueryCatalogTreeReqBO reqBO) {
        DycActGuideDO rspBO = new DycActGuideDO();
        ActivityRelaCommodityCatalogInComPO comPO = new ActivityRelaCommodityCatalogInComPO();
        comPO.setActivityId(reqBO.getObjId());
        List<ActivityRelaCommodityCatalogInComPO> catalog = activityRelaCommodityCatalogInComMapper.getCatalogTree(comPO);
        if(CollectionUtils.isEmpty(catalog)){
            return rspBO;
        }
        Map<String, DycActQueryCatalogTreeBO> nodesById = new HashMap<>();
        List<DycActQueryCatalogTreeBO> rootNodes = new ArrayList<>();
        for (ActivityRelaCommodityCatalogInComPO po : catalog) {
            // 创建一级类目节点
            DycActQueryCatalogTreeBO firstCatalogNode = nodesById.computeIfAbsent(po.getFirstCatalogId(), k -> new DycActQueryCatalogTreeBO());
            firstCatalogNode.setGuideCatalogId(Long.valueOf(po.getFirstCatalogId()));
            firstCatalogNode.setCatalogName(po.getFirstCatalogName());
            firstCatalogNode.setCatalogLevel(1);

            // 创建二级类目节点
            DycActQueryCatalogTreeBO secondCatalogNode = nodesById.computeIfAbsent(po.getSecondCatalogId(), k -> new DycActQueryCatalogTreeBO());
            secondCatalogNode.setGuideCatalogId(Long.valueOf(po.getSecondCatalogId()));
            secondCatalogNode.setCatalogName(po.getSecondCatalogName());
            secondCatalogNode.setCatalogLevel(2);
            firstCatalogNode.getCatalogTreeList().add(secondCatalogNode);

            // 创建三级类目节点
            DycActQueryCatalogTreeBO thirdCatalogNode = nodesById.computeIfAbsent(po.getThreeCatalogId(), k -> new DycActQueryCatalogTreeBO());
            thirdCatalogNode.setGuideCatalogId(Long.valueOf(po.getThreeCatalogId()));
            thirdCatalogNode.setCatalogName(po.getThreeCatalogName());
            thirdCatalogNode.setCatalogLevel(3);
            secondCatalogNode.getCatalogTreeList().add(thirdCatalogNode);

            // 如果是一级类目，添加到根节点列表
            if (!nodesById.containsKey(po.getFirstCatalogId())) {
                rootNodes.add(firstCatalogNode);
            }
        }
        rspBO.setCatalogTreeList(rootNodes);
        return rspBO;
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> getComCount(DycActivityDO reqBO) {
        ActivityRelaCommodityCatalogInComPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityRelaCommodityCatalogInComPO.class);
        List<ActivityRelaCommodityCatalogInComPO> count = activityRelaCommodityCatalogInComMapper.getComCount(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(count), DycActActivityRelaCommodityInfo.class);
    }
}
