package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityCatalogRepository;
import com.tydic.dyc.act.repository.dao.ActivityRelaCommodityCatalogMapper;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityCatalogPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题：DycActActivityCommodityCatalogRepositoryImpl
 * 说明：商品类目实现类
 * 时间：2024/4/17 7:49 下午
 * 作者：汪成松
 */
@Service
public class DycActActivityCommodityCatalogRepositoryImpl implements DycActActivityCommodityCatalogRepository {

    @Autowired
    private ActivityRelaCommodityCatalogMapper activityRelaCommodityCatalogMapper;

    @Override
    public int insertNew(DycActiveCommodityCatalogInfo reqBo) {
        ActivityRelaCommodityCatalogPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogPO.class);
        return activityRelaCommodityCatalogMapper.insertNew(insert);
    }

    @Override
    public int updateByNew(DycActiveCommodityCatalogInfo set, DycActiveCommodityCatalogInfo where) {
        ActivityRelaCommodityCatalogPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityRelaCommodityCatalogPO.class);
        ActivityRelaCommodityCatalogPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityRelaCommodityCatalogPO.class);
        return activityRelaCommodityCatalogMapper.updateBy(setPo,wherePo);
    }

    @Override
    public int getCheckByNew(DycActiveCommodityCatalogInfo reqBo) {
        ActivityRelaCommodityCatalogPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogPO.class);
        return activityRelaCommodityCatalogMapper.getCheckBy(insert);
    }

    @Override
    public DycActiveCommodityCatalogInfo getModelByNew(DycActiveCommodityCatalogInfo reqBo) {
        ActivityRelaCommodityCatalogPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogPO.class);
        ActivityRelaCommodityCatalogPO modelBy = activityRelaCommodityCatalogMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActiveCommodityCatalogInfo.class);
    }

    @Override
    public List<DycActiveCommodityCatalogInfo> getListNew(DycActiveCommodityCatalogInfo reqBo) {
        ActivityRelaCommodityCatalogPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityCatalogPO.class);
        List<ActivityRelaCommodityCatalogPO> list = activityRelaCommodityCatalogMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActiveCommodityCatalogInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActiveCommodityCatalogInfo> list) {
        List<ActivityRelaCommodityCatalogPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityRelaCommodityCatalogPO.class);
        activityRelaCommodityCatalogMapper.insertBatch(listPo);
    }
}
