package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityRepository;
import com.tydic.dyc.act.repository.dao.*;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：DycActActivityCommodityRepositoryImpl
 * 说明：活动已选商品池列表分页查询
 * 时间： 2023-12-13 15:43
 * 作者 @author LY
 */
@Service
public class DycActActivityCommodityRepositoryImpl implements DycActActivityCommodityRepository {

    @Autowired
    private ActivityRelaCommodityPoolMapper activityRelaCommodityPoolMapper;
    @Autowired
    private ActivityRelaCommodityMapper activityRelaCommodityMapper;

    @Autowired
    private ActivityRelaCommodityCatalogMapper activityRelaCommodityCatalogMapper;
    @Autowired
    private ActSkuInfoMapper actSkuInfoMapper;

    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;
    @Autowired
    private ActivityRelaCommodityCatalogInComMapper activityRelaCommodityCatalogInComMapper;

    @Override
    public void delete(DycActivityCommodityPoolInfo record) {
        ActivityRelaCommodityPO activityRelaCommodityPO = ActRu.js(record, ActivityRelaCommodityPO.class);
        activityRelaCommodityMapper.delete(activityRelaCommodityPO);
    }

    @Override
    public BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动已选商品池列表分页查询失败！");
        }
        BasePageRspBo<DycActivityCommodityPoolInfo> rspPage = new BasePageRspBo<>();
        ActivityRelaCommodityPoolPO selectActivityRelaCommodityPoolPO = new ActivityRelaCommodityPoolPO();
        BeanUtils.copyProperties(reqBO, selectActivityRelaCommodityPoolPO);
        Page<ActivityRelaCommodityPoolPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityPoolMapper.selectByCondition(selectActivityRelaCommodityPoolPO));

        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }
        //封装集合
        List<DycActivityCommodityPoolInfo> activityRelaCommodityPoolBOList = new ArrayList<>();
        for (ActivityRelaCommodityPoolPO activityRelaCommodityPoolPO : page.getResult()) {
            DycActivityCommodityPoolInfo activityRelaCommodityPoolBO = new DycActivityCommodityPoolInfo();
            BeanUtils.copyProperties(activityRelaCommodityPoolPO, activityRelaCommodityPoolBO);
            activityRelaCommodityPoolBOList.add(activityRelaCommodityPoolBO);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityRelaCommodityPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public List<DycActivityCommodityPoolInfo> queryActivityCommodityPoolList(DycQueryActivityCommodityPoolPageListReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动已选商品池列表分页查询失败！");
        }
        ActivityRelaCommodityPoolPO relaCommodityPoolPO = new ActivityRelaCommodityPoolPO();
        BeanUtils.copyProperties(reqBO, relaCommodityPoolPO);
        List<ActivityRelaCommodityPoolPO> commodityPoolPOS = activityRelaCommodityPoolMapper.selectByCondition(relaCommodityPoolPO);
        List<DycActivityCommodityPoolInfo> rspBO = JSON.parseArray(JSON.toJSONString(commodityPoolPOS), DycActivityCommodityPoolInfo.class);
        return rspBO;
    }

    @Override
    public BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动已选商品类型列表分页查询失败！");
        }
        BasePageRspBo<DycActiveCommodityCatalogInfo> rspPage = new BasePageRspBo<>();
        ActivityRelaCommodityCatalogPO commodityPoolPO = new ActivityRelaCommodityCatalogPO();
        BeanUtils.copyProperties(reqBO, commodityPoolPO);
        Page<ActivityRelaCommodityCatalogPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityCatalogMapper.selectByConditionExt(commodityPoolPO));
        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }
        List<DycActiveCommodityCatalogInfo> dycActiveCommodityCatalogInfos = new ArrayList<>();
        for (ActivityRelaCommodityCatalogPO relaCommodityPoolPo : page.getResult()) {
            DycActiveCommodityCatalogInfo catalogInfo = new DycActiveCommodityCatalogInfo();
            BeanUtils.copyProperties(relaCommodityPoolPo, catalogInfo);
            catalogInfo.setCatalogStr(catalogInfo.getFirstCatalogName() + ">" + catalogInfo.getSecondCatalogName() + ">" + catalogInfo.getThreeCatalogName());
            catalogInfo.setTotalCommodity(0);
            dycActiveCommodityCatalogInfos.add(catalogInfo);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(dycActiveCommodityCatalogInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public List<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogAllList(DycActiveCommodityCatalogQueryBO reqBO) {
        ActivityRelaCommodityCatalogPO selectActivityRelaCommodityPO = new ActivityRelaCommodityCatalogPO();
        BeanUtils.copyProperties(reqBO, selectActivityRelaCommodityPO);
        List<ActivityRelaCommodityCatalogPO> activityRelaCommodityPOList = this.activityRelaCommodityCatalogMapper.selectByCondition(selectActivityRelaCommodityPO);
        List<DycActiveCommodityCatalogInfo> activityRelaCommodityBOList = JSON.parseArray(JSON.toJSONString(activityRelaCommodityPOList), DycActiveCommodityCatalogInfo.class);
        return activityRelaCommodityBOList;
    }

    @Override

    public DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getActivityCommodityPoolInfos())) {
            throw new ZTBusinessException("活动商品池选择（批量）服务为空！");
        }
        List<ActivityRelaCommodityPoolPO> commodityPoolPOS = JSON.parseArray(JSON.toJSONString(reqBO.getActivityCommodityPoolInfos()), ActivityRelaCommodityPoolPO.class);
        List<ActivityRelaCommodityPoolPO> collect = commodityPoolPOS.stream().map(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
            item.setActivityId(reqBO.getActivityId());
            item.setDelFlag(0);
            return item;
        }).collect(Collectors.toList());
        int i = activityRelaCommodityPoolMapper.allInsert(collect);
        if (i != reqBO.getActivityCommodityPoolInfos().size()) {
            throw new ZTBusinessException("活动商品池选择（批量）服务新增失败！");
        }
        DycActivityCommodityPoolInfo rspBO = new DycActivityCommodityPoolInfo();
        rspBO.setActivityId(reqBO.getActivityId());
        return rspBO;
    }

    @Override
    public int batchRemoveActivityCommodityPool(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getCommodityPoolIdList().size() < 1) {
            throw new ZTBusinessException("商品池id列表不能为空！");
        }
        List<ActivityRelaCommodityPoolPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getCommodityPoolIdList()) {
            ActivityRelaCommodityPoolPO activityRelaCommodityPoolPO = new ActivityRelaCommodityPoolPO();
            activityRelaCommodityPoolPO.setActivityId(reqBO.getActivityId());
            activityRelaCommodityPoolPO.setUpdateTime(new Date());
            activityRelaCommodityPoolPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityRelaCommodityPoolPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityRelaCommodityPoolPO.setCommodityPoolId(aLong);
            list.add(activityRelaCommodityPoolPO);
        }
        return activityRelaCommodityPoolMapper.batchRemoveActivityCommodityPool(list);
    }

    @Override
    public DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("活动商品类型选择（批量）服务为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动商品类型选择（批量）服务活动ID为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityCatalogInfoBOS())) {
            throw new ZTBusinessException("活动商品类型选择（批量）服务类型为空！");
        }
        //查询已经添加的全量商品类型数据，用于过滤掉重复数据
        ActivityRelaCommodityCatalogPO qryActivityRelaCommodityCatalogPo = new ActivityRelaCommodityCatalogPO();
        qryActivityRelaCommodityCatalogPo.setDelFlag(0);
        qryActivityRelaCommodityCatalogPo.setActivityId(reqBO.getActivityId());
        List<String> threeCatalogIds = new ArrayList<>();
        List<ActivityRelaCommodityCatalogPO> commodityCatalogPos = activityRelaCommodityCatalogMapper.getList(qryActivityRelaCommodityCatalogPo);
        if (!CollectionUtils.isEmpty(commodityCatalogPos)) {
            threeCatalogIds = commodityCatalogPos.stream().map(ActivityRelaCommodityCatalogPO::getThreeCatalogId).collect(Collectors.toList());
        }
        List<ActivityRelaCommodityCatalogPO> activityRelaCommodityCatalogPos = new ArrayList<>();
        for (DycActiveCommodityCatalogInfo each : reqBO.getCommodityCatalogInfoBOS()) {
            if (!CollectionUtils.isEmpty(threeCatalogIds) && threeCatalogIds.contains(each.getThreeCatalogId())) {
                continue;
            }
            ActivityRelaCommodityCatalogPO catalogPo = new ActivityRelaCommodityCatalogPO();
            BeanUtils.copyProperties(each, catalogPo);
            catalogPo.setActivityId(reqBO.getActivityId());
            catalogPo.setCreateTime(new Date());
            catalogPo.setDelFlag(0);
            catalogPo.setRelaId(Sequence.getInstance().nextId());
            catalogPo.setCreateUserId(reqBO.getCreateUserId());
            catalogPo.setCreateUserName(reqBO.getCreateUserName());
            activityRelaCommodityCatalogPos.add(catalogPo);
        }
        if (!CollectionUtils.isEmpty(activityRelaCommodityCatalogPos)) {
            int i = activityRelaCommodityCatalogMapper.allInsert(activityRelaCommodityCatalogPos);
            if (i != activityRelaCommodityCatalogPos.size()) {
                throw new ZTBusinessException("活动商品类型选择（批量）服务类型失败！");
            }
        }
        return new DycActiveCommodityCatalogInfo();
    }

    @Override
    public int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO) {
        List<ActivityRelaCommodityCatalogPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getRelaIdList()) {
            ActivityRelaCommodityCatalogPO activityRelaCommodityPoolPO = new ActivityRelaCommodityCatalogPO();
            activityRelaCommodityPoolPO.setActivityId(reqBO.getActivityId());
            activityRelaCommodityPoolPO.setUpdateTime(new Date());
            activityRelaCommodityPoolPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityRelaCommodityPoolPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityRelaCommodityPoolPO.setRelaId(aLong);
            list.add(activityRelaCommodityPoolPO);
        }
        return activityRelaCommodityCatalogMapper.batchRemoveActivityCommodityCatalog(list);
    }

    @Override
    public DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (!CollectionUtils.isEmpty(reqBO.getActActivityRelaCommodityBOS())) {
            List<ActivityRelaCommodityPO> collect = reqBO.getActActivityRelaCommodityBOS().stream().map(item -> {
                ActivityRelaCommodityPO commodityPO = new ActivityRelaCommodityPO();
                BeanUtils.copyProperties(item, commodityPO);
                commodityPO.setActivityId(reqBO.getActivityId());
                commodityPO.setCreateTime(new Date());
                commodityPO.setCreateUserId(reqBO.getCreateUserId());
                commodityPO.setRelaId(Sequence.getInstance().nextId());
                commodityPO.setDelFlag(0);
                commodityPO.setCreateUserName(reqBO.getCreateUserName());
                return commodityPO;
            }).collect(Collectors.toList());
            int i = activityRelaCommodityMapper.allInsert(collect);
            if (i != reqBO.getActActivityRelaCommodityBOS().size()) {
                throw new ZTBusinessException("活动商品选择（批量）服务添加失败！");
            }
        }

        return new DycActActivityRelaCommodityInfo();
    }

    @Override
    public int batchRemoveActivityCommodity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getSkuIdList().size() < 1) {
            throw new ZTBusinessException("商品id不能为空！");
        }
        ActivityRelaCommodityExtPO commodityExtPO = new ActivityRelaCommodityExtPO();
        commodityExtPO.setActivityId(reqBO.getActivityId());
        commodityExtPO.setUpdateTime(new Date());
        commodityExtPO.setUpdateUserId(reqBO.getUpdateUserId());
        commodityExtPO.setUpdateUserName(reqBO.getUpdateUserName());
        commodityExtPO.setSkuIds(reqBO.getSkuIdList());

        int num = activityRelaCommodityMapper.batchRemoveActivityCommodity(commodityExtPO);
        return num;
    }

    @Override
    public int deleteActivityCommodityCatalog(DycActivityDO reqBO) {
        ActivityRelaCommodityCatalogPO catalogPO = new ActivityRelaCommodityCatalogPO();
        catalogPO.setActivityId(reqBO.getActivityId());
        catalogPO.setUpdateTime(new Date());
        catalogPO.setUpdateUserId(reqBO.getUpdateUserId());
        catalogPO.setUpdateUserName(reqBO.getUpdateUserName());
        catalogPO.setDelFlag(1);
        return activityRelaCommodityCatalogMapper.update(catalogPO);
    }

    @Override
    public int deleteActivityCommodity(DycActivityDO reqBO) {
        ActivityRelaCommodityPO commodityPO = new ActivityRelaCommodityPO();
        commodityPO.setActivityId(reqBO.getActivityId());
        commodityPO.setUpdateTime(new Date());
        commodityPO.setUpdateUserId(reqBO.getUpdateUserId());
        commodityPO.setUpdateUserName(reqBO.getUpdateUserName());
        commodityPO.setDelFlag(1);
        return activityRelaCommodityMapper.update(commodityPO);
    }

    @Override
    public int selectCountCommodity(DycActivityDO reqBO) {
        ActivityRelaCommodityPO activityRelaCommodityPO = new ActivityRelaCommodityPO();
        activityRelaCommodityPO.setActivityId(reqBO.getActivityId());
        return activityRelaCommodityMapper.selectCountCommodity(activityRelaCommodityPO);
    }

    @Override
    public int selectCountCommodityCatalog(DycActivityDO reqBO) {
        ActivityRelaCommodityCatalogPO catalogPO = new ActivityRelaCommodityCatalogPO();
        catalogPO.setActivityId(reqBO.getActivityId());
        return activityRelaCommodityCatalogMapper.selectCountCommodityCatalog(catalogPO);
    }

    @Override
    public int updateCommodity(DycActActivityRelaCommodityInfo reqBO) {
        ActivityRelaCommodityPO activityRelaCommodityPO = ActRu.js(reqBO, ActivityRelaCommodityPO.class);
        return activityRelaCommodityMapper.update(activityRelaCommodityPO);
    }

    /**
     * 批量更新
     *
     * @param list
     */
    @Override
    public void updateBatch(List<DycActActivityRelaCommodityInfo> list) {
        List<ActivityRelaCommodityPO> activityRelaCommodityPOS = ActRu.jsl(list, ActivityRelaCommodityPO.class);
        activityRelaCommodityMapper.updateBatch(activityRelaCommodityPOS);
    }

    @Override
    public int updateCommodityState(DycActivityDO reqBO) {
        ActivityRelaCommodityPO activityRelaCommodityPO = ActRu.js(reqBO, ActivityRelaCommodityPO.class);
        return activityRelaCommodityMapper.updateCommodityState(activityRelaCommodityPO);
    }

    @Override
    public int updateActiveCommodityCatalogInfoBy(DycActiveCommodityCatalogInfo reqBo) {
        ActivityRelaCommodityCatalogPO setPo = ActRu.js(reqBo, ActivityRelaCommodityCatalogPO.class);
        ActivityRelaCommodityCatalogPO wherePo = new ActivityRelaCommodityCatalogPO();
        wherePo.setActivityId(reqBo.getActivityId());
        return activityRelaCommodityCatalogMapper.updateBy(setPo, wherePo);
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> selectByOnShelf(DycActivityDO reqBO) {
        ActivityRelaCommodityPO setPo = ActRu.js(reqBO, ActivityRelaCommodityPO.class);
        List<ActivityRelaCommodityPO> list = activityRelaCommodityMapper.selectByOnShelf(setPo);
        return ActRu.jsl(list, DycActActivityRelaCommodityInfo.class);
    }

    @Override
    public int count(DycActActivityRelaCommodityInfo record) {
        ActivityRelaCommodityExtPO activityRelaCommodityExtPO = ActRu.js(record, ActivityRelaCommodityExtPO.class);
        return activityRelaCommodityMapper.count(activityRelaCommodityExtPO);
    }

    @Override
    public BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        BasePageRspBo<DycActActivityRelaCommodityInfo> rspBo = new BasePageRspBo<>();
        ActivityRelaCommodityPO activityRelaCommodityPO = new ActivityRelaCommodityPO();
        BeanUtils.copyProperties(reqBO, activityRelaCommodityPO);
        Page<ActivityRelaCommodityPO> page = new Page<>();
        if (!ObjectUtils.isEmpty(reqBO) && null == reqBO.getQuoteActivity()) {
            page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityMapper.selectByCondition(activityRelaCommodityPO));
        } else if (!ObjectUtils.isEmpty(reqBO) && null != reqBO.getQuoteActivity()) {
            page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityMapper.selectByOnAll(activityRelaCommodityPO));
        }
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<DycActActivityRelaCommodityInfo> collect = page.getResult().stream().map(item -> {
            DycActActivityRelaCommodityInfo info = new DycActActivityRelaCommodityInfo();
            BeanUtils.copyProperties(item, info);
            info.setCatalogNameStr(item.getFirstCatalogName() + ">" + item.getSecondCatalogName() + ">" + item.getThreeCatalogName());
            if (info.getFavorableRate() != null) {
                if (info.getFavorableRate() % info.getFavorableRate().intValue() == 0) {
                    info.setFavorableRateStr(item.getFavorableRate().intValue() + "%");
                } else {
                    info.setFavorableRateStr(item.getFavorableRate() + "%");
                }
            } else {
                info.setFavorableRateStr("-");
            }
            info.setSkuStatusStr(DycActivityTransFieldUtil.SkuStatusStr(String.valueOf(info.getSkuStatus())));
            info.setSyncStateStr(DycActivityTransFieldUtil.SyncStateStr(String.valueOf(info.getSyncState())));
            return info;
        }).collect(Collectors.toList());

        rspBo.setRows(collect);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> queryActivityCommodityList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (null == reqBO.getCommodityRelaMethod()) {
            throw new ZTBusinessException("活动商品关联方式不能为空！");
        }
        if (Integer.parseInt(DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_TWO) == reqBO.getCommodityRelaMethod()) {
            List<DycActActivityRelaCommodityInfo> list = new ArrayList<>();
            //查询活动配置的所有三级类目id
            ActivityRelaCommodityCatalogPO commodityCatalogPO = new ActivityRelaCommodityCatalogPO();
            commodityCatalogPO.setActivityId(reqBO.getActivityId());
            commodityCatalogPO.setDelFlag(0);
            List<ActivityRelaCommodityCatalogPO> activityRelaCommodityCatalogPOS = activityRelaCommodityCatalogMapper.selectByCondition(commodityCatalogPO);
            ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
            infoPO.setActivityId(reqBO.getActivityId());
            List<ActivityBaseInfoPO> activityBaseInfoPOS = activityBaseInfoMapper.selectByCondition(infoPO);
            if (!CollectionUtils.isEmpty(activityRelaCommodityCatalogPOS)) {
                List<String> guideIds = activityRelaCommodityCatalogPOS.stream().map(a -> a.getThreeCatalogId()).collect(Collectors.toList());
                List<Long> guideLongIds = guideIds.stream()
                        .map(Long::valueOf)
                        .collect(Collectors.toList());
                ActSkuInfoExtPO po = new ActSkuInfoExtPO();
                po.setAgreementPriceMin(activityBaseInfoPOS.get(0).getMinPrice());
                po.setAgreementPriceMax(activityBaseInfoPOS.get(0).getMaxPrice());
                po.setGuideIdList(guideLongIds);
                po.setSkuStatus(DycActivityConstants.SkuStatue.ON_SALE);
                po.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
                List<ActSkuInfoExtPO> actSkuInfoExtPOS = actSkuInfoMapper.selectByConditionExt(po);
                if (!CollectionUtils.isEmpty(actSkuInfoExtPOS)) {
                    List<String> skuIds = actSkuInfoExtPOS.stream().map(a -> a.getSkuCode()).collect(Collectors.toList());
                    for (String skuCode : skuIds) {
                        DycActActivityRelaCommodityInfo info = new DycActActivityRelaCommodityInfo();
                        info.setSkuCode(skuCode);
                        list.add(info);
                    }
                }
            }
            return list;
        } else {
            ActivityRelaCommodityPO selectActivityRelaCommodityPO = new ActivityRelaCommodityPO();
            BeanUtils.copyProperties(reqBO, selectActivityRelaCommodityPO);
            List<ActivityRelaCommodityPO> activityRelaCommodityPOList = this.activityRelaCommodityMapper.selectByCondition(selectActivityRelaCommodityPO);
            List<DycActActivityRelaCommodityInfo> activityRelaCommodityBOList = JSON.parseArray(JSON.toJSONString(activityRelaCommodityPOList), DycActActivityRelaCommodityInfo.class);
            return activityRelaCommodityBOList;
        }
    }


    @Override
    public void insertAllCommodity(List<DycActActivityRelaCommodityInfo> dycActActivityRelaCommodityInfoList) {
        List<ActivityRelaCommodityPO> activityRelaCommodityPoList = JSONObject.parseArray(JSONObject.toJSONString(dycActActivityRelaCommodityInfoList), ActivityRelaCommodityPO.class);
        activityRelaCommodityMapper.allInsert(activityRelaCommodityPoList);
    }

    @Override
    public void insertAllCatalog(List<DycActiveCommodityCatalogInfo> dycActiveCommodityCatalogInfoList) {
        List<ActivityRelaCommodityCatalogPO> activityRelaCommodityPoList = JSONObject.parseArray(JSONObject.toJSONString(dycActiveCommodityCatalogInfoList), ActivityRelaCommodityCatalogPO.class);
        activityRelaCommodityCatalogMapper.allInsert(activityRelaCommodityPoList);
    }

    @Override
    public int insertNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityPO.class);
        return activityRelaCommodityMapper.insertNew(insert);
    }

    @Override
    public int updateByNew(DycActActivityRelaCommodityInfo set, DycActActivityRelaCommodityInfo where) {
        ActivityRelaCommodityPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityRelaCommodityPO.class);
        ActivityRelaCommodityPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityRelaCommodityPO.class);
        return activityRelaCommodityMapper.updateBy(setPo, wherePo);
    }

    @Override
    public int getCheckByNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityPO.class);
        return activityRelaCommodityMapper.getCheckBy(insert);
    }

    @Override
    public DycActActivityRelaCommodityInfo getModelByNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityPO.class);
        ActivityRelaCommodityPO modelBy = activityRelaCommodityMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActActivityRelaCommodityInfo.class);
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> getListNew(DycActActivityRelaCommodityInfo reqBo) {
        ActivityRelaCommodityPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityRelaCommodityPO.class);
        List<ActivityRelaCommodityPO> list = activityRelaCommodityMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActActivityRelaCommodityInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActActivityRelaCommodityInfo> list) {
        List<ActivityRelaCommodityPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityRelaCommodityPO.class);
        activityRelaCommodityMapper.insertBatch(listPo);
    }
}
