package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordDO;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordInfo;
import com.tydic.dyc.act.repository.api.DycActActivitySyncExternalRecordRepository;
import com.tydic.dyc.act.repository.dao.ActActivitySyncExternalRecordMapper;
import com.tydic.dyc.act.repository.po.ActActivitySyncExternalRecordPO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：ActActivitySyncExternalRecordRepositoryImpl
 * 说明：
 * 时间： 2024-04-09 20:11
 * 作者 @author LY
 */
@Service
public class DycActActivitySyncExternalRecordRepositoryImpl implements DycActActivitySyncExternalRecordRepository {

    @Autowired
    private ActActivitySyncExternalRecordMapper actActivitySyncExternalRecordMapper;

    @Override
    public ActActivitySyncExternalRecordInfo queryActivitySyncExternalRecordSingle(ActActivitySyncExternalRecordDO actActivitySyncExternalRecordReqBO) {
        ActActivitySyncExternalRecordInfo rspBO = new ActActivitySyncExternalRecordInfo();
        ActActivitySyncExternalRecordPO selectActActivitySyncExternalRecordPO = new ActActivitySyncExternalRecordPO();
        BeanUtils.copyProperties(actActivitySyncExternalRecordReqBO, selectActActivitySyncExternalRecordPO);
        List<ActActivitySyncExternalRecordPO> actActivitySyncExternalRecordList = this.actActivitySyncExternalRecordMapper.selectByCondition(selectActActivitySyncExternalRecordPO);
        BeanUtils.copyProperties(actActivitySyncExternalRecordList.get(0), rspBO);
        return rspBO;
    }

    @Override
    public List<ActActivitySyncExternalRecordInfo> queryActivitySyncExternalRecordList(ActActivitySyncExternalRecordDO reqBO) {
        ActActivitySyncExternalRecordPO selectActActivitySyncExternalRecordPO = new ActActivitySyncExternalRecordPO();
        BeanUtils.copyProperties(reqBO, selectActActivitySyncExternalRecordPO);
        List<ActActivitySyncExternalRecordPO> recordPOS = actActivitySyncExternalRecordMapper.selectByCondition(selectActActivitySyncExternalRecordPO);
        List<ActActivitySyncExternalRecordInfo> rspBO = recordPOS.stream().map(item -> {
            ActActivitySyncExternalRecordInfo info = new ActActivitySyncExternalRecordInfo();
            BeanUtils.copyProperties(item, info);
            info.setSyncStepStr(DycActivityTransFieldUtil.SyncStepStr(item.getSyncStep()));
            info.setSyncResultStr(DycActivityTransFieldUtil.SyncResultStr(item.getSyncResult()));
            return info;
        }).collect(Collectors.toList());
        return rspBO;
    }

    @Override
    public ActActivitySyncExternalRecordInfo addActivitySyncExternalRecord(ActActivitySyncExternalRecordDO actActivitySyncExternalRecordReqBO) {
        ActActivitySyncExternalRecordInfo rspBO = new ActActivitySyncExternalRecordInfo();

        ActActivitySyncExternalRecordPO insertActActivitySyncExternalRecordPO = new ActActivitySyncExternalRecordPO();
        BeanUtils.copyProperties(actActivitySyncExternalRecordReqBO, insertActActivitySyncExternalRecordPO);
        long id = Sequence.getInstance().nextId();
        insertActActivitySyncExternalRecordPO.setId(id);

        actActivitySyncExternalRecordMapper.insert(insertActActivitySyncExternalRecordPO);

        return rspBO;
    }

    @Override
    public int addBatchActivitySyncExternalRecord(List<ActActivitySyncExternalRecordDO> reqBO) {
        List<ActActivitySyncExternalRecordPO> collect = reqBO.stream().map(item -> {
            ActActivitySyncExternalRecordPO recordPO = new ActActivitySyncExternalRecordPO();
            BeanUtils.copyProperties(item, recordPO);
            recordPO.setId(Sequence.getInstance().nextId());
            return recordPO;
        }).collect(Collectors.toList());
        return actActivitySyncExternalRecordMapper.allInsert(collect);
    }

    @Override
    public ActActivitySyncExternalRecordInfo updateActivitySyncExternalRecord(ActActivitySyncExternalRecordDO actActivitySyncExternalRecordReqBO) {
        ActActivitySyncExternalRecordInfo rspBO = new ActActivitySyncExternalRecordInfo();
        ActActivitySyncExternalRecordPO updateActActivitySyncExternalRecordPO = new ActActivitySyncExternalRecordPO();
        BeanUtils.copyProperties(actActivitySyncExternalRecordReqBO, updateActActivitySyncExternalRecordPO);

        actActivitySyncExternalRecordMapper.update(updateActActivitySyncExternalRecordPO);

        return rspBO;
    }

}
