package com.tydic.dyc.act.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActAlertInfoRepository;
import com.tydic.dyc.act.repository.dao.*;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.base.utils.JUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @ClassName DycActAlertInfoRepositoryImpl
 * @Author 14051
 * @Date 2024/4/16 17:40
 * @Version 1.0
 **/
@Service
public class DycActAlertInfoRepositoryImpl implements DycActAlertInfoRepository {

    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;
    @Autowired
    private ActOrderInfoMapper actOrderInfoMapper;
    @Autowired
    private ActFscOrderMapper actFscOrderMapper;
    @Autowired
    private ActOrderInfoMapperUni actOrderInfoMapperUni;
    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;

    @Override
    public void saveAlertInfo(DycActDealOrderAlertDO reqBO) {
        //判断是否已存在
        ActAlertInfoPO qryAlertPO = new ActAlertInfoPO();
        qryAlertPO.setAlertState(DycActivityConstants.AlertState.DEALING);
        qryAlertPO.setObjId(reqBO.getOrderId());
        qryAlertPO.setAlertType(reqBO.getAlertType());
        qryAlertPO.setObjType(reqBO.getObjType());
        List<ActAlertInfoPO> qryResults = actAlertInfoMapper.selectByCondition(qryAlertPO);
        if (!CollectionUtils.isEmpty(qryResults)){
            ActAlertInfoPO updatePO = new ActAlertInfoPO();
            updatePO.setId(qryResults.get(0).getId());
            updatePO.setAlertState(DycActivityConstants.AlertState.UN_DEAL);
            updatePO.setUpdateTime(new Date());
            actAlertInfoMapper.update(updatePO);
        } else {
            List<ActAlertInfoPO> actAlertInfoPOS = new ArrayList<>();
            if (StringUtils.isNotBlank(reqBO.getOrderId())) {
                ActAlertInfoPO po = new ActAlertInfoPO();
                //获取单据本身的组织机构信息等
                setObjOrgInfo(reqBO.getOrderId(), reqBO.getObjType(), po);
                po.setId(Sequence.getInstance().nextId());
                po.setObjId(reqBO.getOrderId());
                po.setObjType(reqBO.getObjType());
                po.setAlertState(reqBO.getAlertState());
                po.setCreateTime(new Date());
                po.setAlertType(reqBO.getAlertType());
                actAlertInfoPOS.add(po);
                actAlertInfoMapper.allInsert(actAlertInfoPOS);
            }
        }
        /*if (!CollectionUtils.isEmpty(reqBO.getOrderIds())) {
            actAlertInfoPOS = reqBO.getOrderIds().stream().map(orderId -> {
                ActAlertInfoPO po = new ActAlertInfoPO();
                po.setId(Sequence.getInstance().nextId());
                po.setObjId(orderId);
                po.setObjType(reqBO.getObjType());
                po.setAlertType(reqBO.getAlertType());
                po.setAlertState(reqBO.getAlertState());
                po.setCreateTime(new Date());
                return po;
            }).collect(Collectors.toList());
        }*/
    }

    @Override
    public int updateAlertInfo(DycActDealOrderAlertDO reqBO) {
        ActAlertInfoPO record = new ActAlertInfoPO();
        record.setAlertState(reqBO.getAlertState());
        record.setIds(reqBO.getUpdAlertInfoList().stream().map(ActUpdateAlertInfo::getId).collect(Collectors.toList()));
        return actAlertInfoMapper.batchUpdate(record);
    }

    @Override
    public ActAlertOrderInfo getAlertInfo(DycActFscOrderDO reqBO) {
        ActAlertInfoPO record = new ActAlertInfoPO();
        record.setObjId(reqBO.getFscOrderId().toString());
        record.setAlertType(reqBO.getOldAlertType());
        record.setAlertState(DycActivityConstants.AlertState.UN_DEAL);
        List<ActAlertInfoPO> actAlertInfoPOS = actAlertInfoMapper.selectByCondition(record);
        if (!CollectionUtils.isEmpty(actAlertInfoPOS)){
            ActAlertOrderInfo actAlertOrderInfo = new ActAlertOrderInfo();
            actAlertOrderInfo.setId(actAlertInfoPOS.get(0).getId());
            actAlertOrderInfo.setOrderId(actAlertInfoPOS.get(0).getObjId());
            return actAlertOrderInfo;
        } else {
            return null;
        }
    }

    @Override
    public int updateExpAlertInfo(DycActDealOrderAlertDO reqBO) {
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setOldAlertState(reqBO.getAlertState());
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.DEALED);
        actAlertInfoPO.setAlertType(reqBO.getAlertType());
        return actAlertInfoMapper.updateAlertState(actAlertInfoPO);
    }

    @Override
    public int updateAlert(DycActDealOrderAlertDO set, DycActDealOrderAlertDO where) {
        ActAlertInfoPO setPo = JUtil.js(set, ActAlertInfoPO.class);
        ActAlertInfoPO wherePo = JUtil.js(where, ActAlertInfoPO.class);
        return actAlertInfoMapper.updateBy(setPo, wherePo);
    }

    private void setObjOrgInfo(String objId, Integer objType, ActAlertInfoPO po){
        if (objType == 1){
            ActOrderInfoPO actOrderInfoPO = new ActOrderInfoPO();
            actOrderInfoPO.setOrderId(objId);
            actOrderInfoPO = actOrderInfoMapper.getCreateInfo(actOrderInfoPO);
            if (!Objects.isNull(actOrderInfoPO)){
                BeanUtils.copyProperties(actOrderInfoPO, po);
            }
        } else if (objType == 2){
            DycActOrderQryDO dycActOrderQryDO = new DycActOrderQryDO();
            dycActOrderQryDO.setAfsServiceId(objId);
            ActAfsOrdInfoUni actAfsOrdInfoUni = actOrderInfoMapperUni.selectAfsOrdCreateInfo(dycActOrderQryDO);
            if (!Objects.isNull(actAfsOrdInfoUni)){
                BeanUtils.copyProperties(actAfsOrdInfoUni, po);
            }
        } else if (objType == 3){
            ActFscOrderPO actFscOrderPO = new ActFscOrderPO();
            actFscOrderPO.setFscOrderId(Long.parseLong(objId));
            actFscOrderPO = actFscOrderMapper.getActivityCreateInfo(actFscOrderPO);
            if (!Objects.isNull(actFscOrderPO)){
                BeanUtils.copyProperties(actFscOrderPO, po);
            }
        } else if (objType == 4){
            ActivityBaseInfoPO record = new ActivityBaseInfoPO();
            record.setActivityId(Long.parseLong(objId));
            record = activityBaseInfoMapper.getActivityBaseInfoDetail(record);
            if (!Objects.isNull(record)){
                BeanUtils.copyProperties(record, po);
                po.setCreateOrgPath(record.getCreateOrgTreePath());
            }
        }
    }
}
