package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActFscInvoiceRepository;
import com.tydic.dyc.act.repository.dao.*;
import com.tydic.dyc.act.repository.po.ActFscInvoiceItemPO;
import com.tydic.dyc.act.repository.po.ActFscInvoicePO;
import com.tydic.dyc.act.repository.po.ActFscOrderInvoicePO;
import com.tydic.dyc.act.repository.po.ActivityFileInfoPO;
import com.tydic.dyc.act.service.bo.DycActOfflineInvoiceBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActFscInvoiceRepositoryImpl
 * @Author 14051
 * @Date 2024/4/3 11:29
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscInvoiceRepositoryImpl implements DycActFscInvoiceRepository {

    @Autowired
    private ActFscInvoiceItemMapper actFscInvoiceItemMapper;
    @Autowired
    private ActFscInvoiceMapper actFscInvoiceMapper;
    @Autowired
    private ActivityFileInfoMapper activityFileInfoMapper;
    @Autowired
    private ActFscOrderInvoiceMapper actFscOrderInvoiceMapper;

    @Override
    public BasePageRspBo<DycActFscInvoiceItemInfo> qryInvoiceItemList(DycActFscInvoiceDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscInvoiceItemPO record = new ActFscInvoiceItemPO();
        BeanUtils.copyProperties(reqBO, record);
        Page<ActFscInvoiceItemPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actFscInvoiceItemMapper.selectByCondition(record));
        //封装集合
        List<DycActFscInvoiceItemInfo> fscInvoiceItemInfos = new ArrayList<>();
        for (ActFscInvoiceItemPO invoiceItemPO : page.getResult()) {
            DycActFscInvoiceItemInfo dycActFscInvoiceItemInfo = new DycActFscInvoiceItemInfo();
            BeanUtils.copyProperties(invoiceItemPO, dycActFscInvoiceItemInfo);
            dycActFscInvoiceItemInfo.setOrderId(invoiceItemPO.getOrderId().toString());
            dycActFscInvoiceItemInfo.setUnitName(invoiceItemPO.getUnit());
            fscInvoiceItemInfos.add(dycActFscInvoiceItemInfo);
        }
        BasePageRspBo<DycActFscInvoiceItemInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscInvoiceItemInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public DycActFscInvoiceInfo getInvoiceInfoByInvoiceNo(DycActFscInvoiceDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        BeanUtils.copyProperties(reqBO, record);
        ActFscInvoicePO result = actFscInvoiceMapper.selectOneByCondition(record);
        return JSON.parseObject(JSON.toJSONString(result), DycActFscInvoiceInfo.class);
    }

    @Override
    public BasePageRspBo<DycActFscInvoiceInfo> qryInvoiceList(DycActFscInvoiceDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        Page<ActFscInvoicePO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actFscInvoiceMapper.selectByCondition(record));
        //封装集合
        List<DycActFscInvoiceInfo> fscInvoiceInfos = new ArrayList<>();
        for (ActFscInvoicePO invoicePO : page.getResult()) {
            DycActFscInvoiceInfo dycActFscInvoiceItemInfo = new DycActFscInvoiceInfo();
            BeanUtils.copyProperties(invoicePO, dycActFscInvoiceItemInfo);
            fscInvoiceInfos.add(dycActFscInvoiceItemInfo);
        }
        BasePageRspBo<DycActFscInvoiceInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscInvoiceInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public List<DycActFscInvoiceAmt> getInvoiceAmtByFscOrderIds(DycActFscInvoiceAmtDO reqBO) {
        return actFscInvoiceMapper.getInvoiceAmtByFscOrderIds(reqBO);
    }

    @Override
    public DycActFscInvoiceInfo getSumAmtByFscOrderId(DycActFscInvoiceDO reqBO) {
        ActFscInvoicePO actFscInvoicePO = new ActFscInvoicePO();
        actFscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        ActFscInvoicePO actFscInvoiceResult = actFscInvoiceMapper.getSumAmtByFscOrderId(actFscInvoicePO);
        return JUtil.js(actFscInvoiceResult, DycActFscInvoiceInfo.class);
    }

    @Override
    public void deleteFscInvoice(DycActFscInvoiceDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscInvoicePO> actFscInvoicePOS = actFscInvoiceMapper.selectByCondition(record);
        if (!CollectionUtils.isEmpty(actFscInvoicePOS)){
            List<Long> invoiceIds = actFscInvoicePOS.stream().map(ActFscInvoicePO::getInvoiceId).collect(Collectors.toList());
            //删除附件
            ActivityFileInfoPO activityFileInfoPO = new ActivityFileInfoPO();
            activityFileInfoPO.setObjIds(invoiceIds);
            activityFileInfoMapper.delete(activityFileInfoPO);
            //删除发票
            actFscInvoiceMapper.delete(record);
        }
        //删除发票明细
        ActFscInvoiceItemPO itemRecord = new ActFscInvoiceItemPO();
        itemRecord.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscInvoiceItemPO> actFscInvoiceItemPOS = actFscInvoiceItemMapper.selectByCondition(itemRecord);
        if (!CollectionUtils.isEmpty(actFscInvoiceItemPOS)){
            actFscInvoiceItemMapper.delete(itemRecord);
        }
    }

    @Override
    public void saveFscInvoices(DycActFscInvoiceDO reqBO) {
        //查询结算单待开票发票
        ActFscOrderInvoicePO record = new ActFscOrderInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscOrderInvoicePO> actFscOrderInvoicePOS = actFscOrderInvoiceMapper.selectByCondition(record);
        DycActFscOrderInvoiceInfo orderInvoiceInfo = JUtil.js(actFscOrderInvoicePOS.get(0), DycActFscOrderInvoiceInfo.class);

        List<ActivityFileInfoPO> activityFileInfoPOS = new ArrayList<>();
        List<ActFscInvoicePO> collect = reqBO.getDycActFscInvoiceListInfos().stream().map(item -> {
            ActFscInvoicePO actFscInvoicePO = new ActFscInvoicePO();
            BeanUtils.copyProperties(item, actFscInvoicePO);
            actFscInvoicePO.setInvoiceId(Sequence.getInstance().nextId());
            actFscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
            actFscInvoicePO.setDelFlag(0);
            actFscInvoicePO.setBuyName(orderInvoiceInfo.getBuyName());
            actFscInvoicePO.setTaxNo(orderInvoiceInfo.getTaxNo());
            actFscInvoicePO.setAddress(orderInvoiceInfo.getAddress());
            actFscInvoicePO.setPhone(orderInvoiceInfo.getPhone());
            actFscInvoicePO.setBank(orderInvoiceInfo.getBank());
            actFscInvoicePO.setAccount(orderInvoiceInfo.getAccount());
            actFscInvoicePO.setInvoiceType(orderInvoiceInfo.getInvoiceType());
            actFscInvoicePO.setInvoiceCategory(orderInvoiceInfo.getInvoiceCategory());
            actFscInvoicePO.setInvoiceItemFlag(DycActivityConstants.FscInvoiceItemFlag.NO);
            actFscInvoicePO.setCreateTime(new Date());

            //组织发票附件
            if (!CollectionUtils.isEmpty(item.getFileInfoList())){
                for (DycActivityFileInfo fileInfo : item.getFileInfoList()) {
                    ActivityFileInfoPO fileInfoPO = new ActivityFileInfoPO();
                    fileInfoPO.setObjId(actFscInvoicePO.getInvoiceId());
                    fileInfoPO.setFileId(Sequence.getInstance().nextId());
                    fileInfoPO.setFileName(fileInfo.getFileName());
                    fileInfoPO.setFileUrl(fileInfo.getFileUrl());
                    fileInfoPO.setFileType(DycActivityConstants.FILE_TYPE.FILE_TYPE_INVOICE);
                    fileInfoPO.setXmlFileUrl(fileInfo.getXmlFileUrl());
                    fileInfoPO.setObjType(5);
                    fileInfoPO.setDelFlag(0);
                    fileInfoPO.setOrderId(reqBO.getFscOrderId());
                    activityFileInfoPOS.add(fileInfoPO);
                }
            }
            return actFscInvoicePO;
        }).collect(Collectors.toList());
        //保存发票
        if (!CollectionUtils.isEmpty(collect)) {
            actFscInvoiceMapper.allInsert(collect);
        }
        //保存发票附件
        if (!CollectionUtils.isEmpty(activityFileInfoPOS)) {
            activityFileInfoMapper.allInsert(activityFileInfoPOS);
        }
    }

    @Override
    public void deleteFscInvoiceItem(DycActFscInvoiceItemDO reqBO) {
        //删除发票明细
        ActFscInvoiceItemPO itemRecord = new ActFscInvoiceItemPO();
        itemRecord.setFscOrderId(reqBO.getFscOrderId());
        itemRecord.setInvoiceId(reqBO.getInvoiceId());
        List<ActFscInvoiceItemPO> actFscInvoiceItemPOS = actFscInvoiceItemMapper.selectByCondition(itemRecord);
        if (!CollectionUtils.isEmpty(actFscInvoiceItemPOS)){
            actFscInvoiceItemMapper.delete(itemRecord);
        }
    }

    @Override
    public void saveFscInvoicesItem(DycActFscInvoiceItemDO reqBO) {
        List<ActFscInvoiceItemPO> collect = reqBO.getInvoiceItemList().stream().map(item -> {
            ActFscInvoiceItemPO actFscInvoiceItemPO = new ActFscInvoiceItemPO();
            BeanUtils.copyProperties(item, actFscInvoiceItemPO);
            actFscInvoiceItemPO.setId(Sequence.getInstance().nextId());
            actFscInvoiceItemPO.setFscOrderId(reqBO.getFscOrderId());
            actFscInvoiceItemPO.setOrderId(item.getOrderId() + "");
            return actFscInvoiceItemPO;
        }).collect(Collectors.toList());
        //保存发票明细
        actFscInvoiceItemMapper.allInsert(collect);
    }

    @Override
    public int updateFscInvoiceFlag(DycActFscInvoiceItemDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setInvoiceItemFlag(DycActivityConstants.FscInvoiceItemFlag.YES);
        record.setInvoiceId(reqBO.getInvoiceId());
        record.setFscOrderId(reqBO.getFscOrderId());
        return actFscInvoiceMapper.update(record);
    }

    @Override
    public int getCountUnGetItem(DycActFscInvoiceItemDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setInvoiceItemFlag(reqBO.getInvoiceItemFlag());
        return actFscInvoiceMapper.getCountUnGetItem(record);
    }

    @Override
    public void deleteInvoiceByNo(DycActDeleteInvoiceBO dycActDeleteInvoiceBO) {
        //查询发票id
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setTaskId(dycActDeleteInvoiceBO.getTaskId());
        record.setFscOrderId(dycActDeleteInvoiceBO.getFscOrderId());
        List<ActFscInvoicePO> invoiceIds = actFscInvoiceMapper.getInvoiceIdByTaskId(record);
        if (!CollectionUtils.isEmpty(invoiceIds)){
            List<Long> invoiceIdList = invoiceIds.stream().map(ActFscInvoicePO::getInvoiceId).collect(Collectors.toList());
            //删除发票
            ActFscInvoicePO delRecord = new ActFscInvoicePO();
            delRecord.setInvoiceIds(invoiceIdList);
            delRecord.setFscOrderId(dycActDeleteInvoiceBO.getFscOrderId());
            actFscInvoiceMapper.delete(delRecord);
            //删除发票明细
            ActFscInvoiceItemPO delItemPO = new ActFscInvoiceItemPO();
            delItemPO.setInvoiceIds(invoiceIdList);
            delItemPO.setFscOrderId(dycActDeleteInvoiceBO.getFscOrderId());
            actFscInvoiceItemMapper.delete(delItemPO);
        }
    }

    @Override
    public List<DycActOfflineInvoiceBO> saveFscOfflineInvoices(DycActFscInvoiceDO reqBO) {
        List<DycActOfflineInvoiceBO> invoiceBOList = new ArrayList<>();
        //查询结算单待开票发票
        ActFscOrderInvoicePO record = new ActFscOrderInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscOrderInvoicePO> actFscOrderInvoicePOS = actFscOrderInvoiceMapper.selectByCondition(record);
        DycActFscOrderInvoiceInfo orderInvoiceInfo = JUtil.js(actFscOrderInvoicePOS.get(0), DycActFscOrderInvoiceInfo.class);
        List<ActivityFileInfoPO> activityFileInfoPOS = new ArrayList<>();
        List<ActFscInvoicePO> collect = reqBO.getDycActFscInvoiceListInfos().stream().map(item -> {
            ActFscInvoicePO actFscInvoicePO = new ActFscInvoicePO();
            BeanUtils.copyProperties(item, actFscInvoicePO);
            actFscInvoicePO.setInvoiceId(Sequence.getInstance().nextId());
            actFscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
            actFscInvoicePO.setDelFlag(0);
            actFscInvoicePO.setBuyName(orderInvoiceInfo.getBuyName());
            actFscInvoicePO.setTaxNo(orderInvoiceInfo.getTaxNo());
            actFscInvoicePO.setAddress(orderInvoiceInfo.getAddress());
            actFscInvoicePO.setPhone(orderInvoiceInfo.getPhone());
            actFscInvoicePO.setBank(orderInvoiceInfo.getBank());
            actFscInvoicePO.setAccount(orderInvoiceInfo.getAccount());
            actFscInvoicePO.setInvoiceType(orderInvoiceInfo.getInvoiceType());
            actFscInvoicePO.setInvoiceCategory(orderInvoiceInfo.getInvoiceCategory());
            actFscInvoicePO.setInvoiceItemFlag(DycActivityConstants.FscInvoiceItemFlag.NO);
            actFscInvoicePO.setCreateTime(new Date());

            //组织发票附件
            if (!CollectionUtils.isEmpty(item.getFileInfoList())){
                for (DycActivityFileInfo fileInfo : item.getFileInfoList()) {
                    ActivityFileInfoPO fileInfoPO = new ActivityFileInfoPO();
                    fileInfoPO.setObjId(actFscInvoicePO.getInvoiceId());
                    fileInfoPO.setFileId(Sequence.getInstance().nextId());
                    fileInfoPO.setFileName(fileInfo.getFileName());
                    fileInfoPO.setFileUrl(fileInfo.getFileUrl());
                    fileInfoPO.setFileType(DycActivityConstants.FILE_TYPE.FILE_TYPE_INVOICE);
                    fileInfoPO.setXmlFileUrl(fileInfo.getXmlFileUrl());
                    fileInfoPO.setObjType(5);
                    fileInfoPO.setDelFlag(0);
                    fileInfoPO.setOrderId(reqBO.getFscOrderId());
                    activityFileInfoPOS.add(fileInfoPO);
                }
            }
            //返回发票id的集合
            DycActOfflineInvoiceBO invoiceBO = new DycActOfflineInvoiceBO();
            invoiceBO.setInvoiceNo(item.getInvoiceNo());
            invoiceBO.setInvoiceId(actFscInvoicePO.getInvoiceId());
            invoiceBOList.add(invoiceBO);

            return actFscInvoicePO;
        }).collect(Collectors.toList());
        //保存发票
        if (!CollectionUtils.isEmpty(collect)) {
            actFscInvoiceMapper.allInsert(collect);
        }
        //保存发票附件
        if (!CollectionUtils.isEmpty(activityFileInfoPOS)) {
            activityFileInfoMapper.allInsert(activityFileInfoPOS);
        }
        return invoiceBOList;
    }
}
