package com.tydic.dyc.act.repository.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActFscOrderRelationRepository;
import com.tydic.dyc.act.repository.dao.ActFscOrderBatchInfoMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderRelationHisMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderRelationMapper;
import com.tydic.dyc.act.repository.po.ActFscOrderBatchInfoPO;
import com.tydic.dyc.act.repository.po.ActFscOrderRelationHisPO;
import com.tydic.dyc.act.repository.po.ActFscOrderRelationPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActFscOrderRelationRepositoryImpl
 * @Author 14051
 * @Date 2024/4/4 11:56
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscOrderRelationRepositoryImpl implements DycActFscOrderRelationRepository {

    @Autowired
    private ActFscOrderRelationMapper actFscOrderRelationMapper;
    @Autowired
    private ActFscOrderRelationHisMapper actFscOrderRelationHisMapper;
    @Autowired
    private ActFscOrderBatchInfoMapper actFscOrderBatchInfoMapper;

    @Override
    public int getFscOrderNum(DycActFscOrderDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return actFscOrderRelationMapper.getFscOrderNum(record);
    }

    @Override
    public int deleteFscOrdRelation(DycActFscOrderDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return actFscOrderRelationMapper.delete(record);
    }

    @Override
    public int saveFscOrdRelationHis(DycActFscOrderDO reqBO) {
        ActFscOrderRelationHisPO record = new ActFscOrderRelationHisPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return actFscOrderRelationHisMapper.insertHisData(record);
    }

    @Override
    public int saveFscOrdRelation(DycActFscOrderSaveDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setExtActivityId(reqBO.getExtActivityId());
        return actFscOrderRelationMapper.insertSelectData(record);
    }

    @Override
    public BasePageRspBo<DycActFscOrderRelationInfo> getFscOrderRelationList(DycActFscOrderQryDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        BeanUtils.copyProperties(reqBO, record);
        Page<ActFscOrderRelationPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actFscOrderRelationMapper.selectByCondition(record));
        //封装集合
        List<DycActFscOrderRelationInfo> fscOrderInfos = page.getResult().stream().map(po->{
            DycActFscOrderRelationInfo dycActFscOrderInfo = new DycActFscOrderRelationInfo();
            BeanUtils.copyProperties(po, dycActFscOrderInfo);
            return dycActFscOrderInfo;
        }).collect(Collectors.toList());

        BasePageRspBo<DycActFscOrderRelationInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscOrderInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public int updateRelationBatch(DycActFscOrderRelationDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setOrderIds(reqBO.getOrderIds());
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setBatchId(reqBO.getBatchId());
        return actFscOrderRelationMapper.updateBatchId(record);
    }

    @Override
    public int saveBatchInfo(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        BeanUtils.copyProperties(reqBO, record);
        return actFscOrderBatchInfoMapper.insert(record);
    }

    @Override
    public int updateBatchInfo(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        BeanUtils.copyProperties(reqBO, record);
        record.setPushInfo(reqBO.getFailInfo());
        return actFscOrderBatchInfoMapper.update(record);
    }

    @Override
    public List<DycActFscOrderRelationInfo> getFscOrdRelationList(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        BeanUtils.copyProperties(reqBO, record);
        List<ActFscOrderRelationPO> orderRelationPOS = this.actFscOrderRelationMapper.selectByCondition(record);
        //封装集合
        List<DycActFscOrderRelationInfo> fscOrderInfos = orderRelationPOS.stream().map(po->{
            DycActFscOrderRelationInfo dycActFscOrderInfo = new DycActFscOrderRelationInfo();
            BeanUtils.copyProperties(po, dycActFscOrderInfo);
            return dycActFscOrderInfo;
        }).collect(Collectors.toList());
        return fscOrderInfos;
    }

    @Override
    public BigDecimal getCurrentAmt(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        BeanUtils.copyProperties(reqBO, record);
        return actFscOrderRelationMapper.getCurrentAmt(record);
    }

    @Override
    public int deleteFscOrderBatchInfo(DycActFscOrderDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return actFscOrderBatchInfoMapper.delete(record);
    }
}
