package com.tydic.dyc.act.repository.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActOfflineInvoiceRepository;
import com.tydic.dyc.act.repository.dao.ActOfflineInvoiceItemMapper;
import com.tydic.dyc.act.repository.dao.ActOfflineInvoiceResultMapper;
import com.tydic.dyc.act.repository.dao.ActOfflineInvoiceTaskMapper;
import com.tydic.dyc.act.repository.po.ActOfflineInvoiceItemPO;
import com.tydic.dyc.act.repository.po.ActOfflineInvoiceResultPO;
import com.tydic.dyc.act.repository.po.ActOfflineInvoiceTaskPO;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActOfflineInvoiceRepositoryImpl
 * @Author 14051
 * @Date 2024/8/12 16:05
 * @Version 1.0
 **/
@Service
public class DycActOfflineInvoiceRepositoryImpl implements DycActOfflineInvoiceRepository {

    @Autowired
    private ActOfflineInvoiceTaskMapper actOfflineInvoiceTaskMapper;
    @Autowired
    private ActOfflineInvoiceItemMapper actOfflineInvoiceItemMapper;
    @Autowired
    private ActOfflineInvoiceResultMapper actOfflineInvoiceResultMapper;

    @Override
    public ActFscOfflineInvoiceRspBO saveOfflineInvoiceTask(ActFscOfflineInvoiceDO actFscOfflineInvoiceDO) {
        //保存任务表
        ActOfflineInvoiceTaskPO actOfflineInvoiceTaskPO = JUtil.js(actFscOfflineInvoiceDO, ActOfflineInvoiceTaskPO.class);
        actOfflineInvoiceTaskPO.setTaskId(Sequence.getInstance().nextId());
        actOfflineInvoiceTaskPO.setStatus(DycActivityConstants.OFFLINE_TASK_STATUS.UNDEAL);
        actOfflineInvoiceTaskPO.setCreateTime(new Date());
        actOfflineInvoiceTaskPO.setOperId(actFscOfflineInvoiceDO.getUserId());
        actOfflineInvoiceTaskPO.setOperName(actFscOfflineInvoiceDO.getName());
        actOfflineInvoiceTaskPO.setOperOrgId(actFscOfflineInvoiceDO.getOrgId());
        actOfflineInvoiceTaskPO.setOperOrgName(actFscOfflineInvoiceDO.getOrgName());
        actOfflineInvoiceTaskPO.setOperCompanyId(actFscOfflineInvoiceDO.getCompanyId());
        actOfflineInvoiceTaskPO.setOperCompanyName(actFscOfflineInvoiceDO.getCompanyName());
        actOfflineInvoiceTaskPO.setOperOrgPath(actFscOfflineInvoiceDO.getOrgPath());
        actOfflineInvoiceTaskMapper.insert(actOfflineInvoiceTaskPO);

        //保存任务明细表
        List<ActOfflineInvoiceItemPO> actOfflineInvoiceItemPOS = actFscOfflineInvoiceDO.getInvoiceBOS().stream().map(invoiceBO -> {
            int i = 1;
            ActOfflineInvoiceItemPO actOfflineInvoiceItemPO = JUtil.js(invoiceBO, ActOfflineInvoiceItemPO.class);
            actOfflineInvoiceItemPO.setTaskItemId(Sequence.getInstance().nextId());
            actOfflineInvoiceItemPO.setTaskId(actOfflineInvoiceTaskPO.getTaskId());
            actOfflineInvoiceItemPO.setCreateTime(new Date());
            actOfflineInvoiceItemPO.setFscOrderId(actFscOfflineInvoiceDO.getFscOrderId());
            actOfflineInvoiceItemPO.setOrderNo(i++);
            return actOfflineInvoiceItemPO;
        }).collect(Collectors.toList());
        actOfflineInvoiceItemMapper.allInsert(actOfflineInvoiceItemPOS);

        ActFscOfflineInvoiceRspBO rspBO = new ActFscOfflineInvoiceRspBO();
        rspBO.setTaskId(actOfflineInvoiceTaskPO.getTaskId());
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public Integer qryTaskCount(ActOfflineInvoiceQryBO actOfflineInvoiceQryBO) {
        ActOfflineInvoiceTaskPO actOfflineInvoiceTaskPO = JUtil.js(actOfflineInvoiceQryBO, ActOfflineInvoiceTaskPO.class);
        Integer count = actOfflineInvoiceTaskMapper.getTaskCount(actOfflineInvoiceTaskPO);
        return count;
    }

    @Override
    public List<String> qryExtOrderIdByCondition(ActOfflineInvoiceQryExtNoQryBO qryExtNoQryBO) {
        ActOfflineInvoiceItemPO record = new ActOfflineInvoiceItemPO();
        record.setFscOrderId(qryExtNoQryBO.getFscOrderId());
        record.setTaskId(qryExtNoQryBO.getTaskId());
        record.setOrderNo(qryExtNoQryBO.getOrderNo());
        List<ActOfflineInvoiceItemPO> actOfflineInvoiceItemPOS = actOfflineInvoiceItemMapper.qryExtOrderByCondition(record);
        if (actOfflineInvoiceItemPOS != null){
            if (!CollectionUtils.isEmpty(actOfflineInvoiceItemPOS)) {
                return actOfflineInvoiceItemPOS.stream().map(ActOfflineInvoiceItemPO::getOrderId).collect(Collectors.toList());
            }
        }
        return null;
    }

    @Override
    public void updateTaskItemResult(ActOfflineTaskUpdDO actOfflineTaskUpdDO) {
        if (actOfflineTaskUpdDO.getOrderNo() == null){
            ActOfflineInvoiceTaskPO taskPO = new ActOfflineInvoiceTaskPO();
            taskPO.setStatus(actOfflineTaskUpdDO.getStatus());
            taskPO.setUpdateTime(new Date());
            taskPO.setTaskId(actOfflineTaskUpdDO.getTaskId());
            taskPO.setDealResult(actOfflineTaskUpdDO.getDealResult());
            actOfflineInvoiceTaskMapper.updateByCondition(taskPO);
        } else {
            //更新任务明细表
            ActOfflineInvoiceItemPO record = new ActOfflineInvoiceItemPO();
            record.setDealResult(actOfflineTaskUpdDO.getDealResult());
            record.setResultInfo(actOfflineTaskUpdDO.getResultInfo());
            record.setUpdateTime(new Date());
            record.setTaskId(actOfflineTaskUpdDO.getTaskId());
            record.setOrderNo(actOfflineTaskUpdDO.getOrderNo());
            int count = actOfflineInvoiceItemMapper.updateByCondition(record);
            //更新任务主表
            if (DycActivityConstants.OFFLINE_DEAL_RESULT.FALL.equals(actOfflineTaskUpdDO.getDealResult())) {
                ActOfflineInvoiceTaskPO taskPO = new ActOfflineInvoiceTaskPO();
                taskPO.setStatus(DycActivityConstants.OFFLINE_TASK_STATUS.SUCCESS);
                taskPO.setDealResult(actOfflineTaskUpdDO.getDealResult());
                taskPO.setUpdateTime(new Date());
                taskPO.setTaskId(actOfflineTaskUpdDO.getTaskId());
                actOfflineInvoiceTaskMapper.updateByCondition(taskPO);
            }
        }
    }

    @Override
    public void saveOfflineInvoiceResult(ActOfflineTaskResultSaveDO actOfflineTaskResultSaveDO) {
        //查询明细ID
        ActOfflineInvoiceItemPO record = new ActOfflineInvoiceItemPO();
        record.setTaskId(actOfflineTaskResultSaveDO.getTaskId());
        record.setOrderNo(actOfflineTaskResultSaveDO.getOrderNo());
        record = actOfflineInvoiceItemMapper.getModelBy(record);
        if (record == null){
            throw new ZTBusinessException("未查询到任务明细记录");
        }
        ActOfflineInvoiceItemPO finalRecord = record;
        List<ActOfflineInvoiceResultPO> actOfflineInvoiceResultPOS = actOfflineTaskResultSaveDO.getInvoiceList().stream().map(invoiceBO -> {
            ActOfflineInvoiceResultPO po = JUtil.js(invoiceBO, ActOfflineInvoiceResultPO.class);
            po.setResultId(Sequence.getInstance().nextId());
            po.setTaskId(actOfflineTaskResultSaveDO.getTaskId());
            po.setTaskItemId(finalRecord.getTaskItemId());
            po.setFscOrderId(actOfflineTaskResultSaveDO.getFscOrderId());
            po.setCreateTime(new Date());
            return po;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(actOfflineInvoiceResultPOS)){
            actOfflineInvoiceResultMapper.allInsert(actOfflineInvoiceResultPOS);
        }
    }

    @Override
    public List<ActOfflineInvoiceResultBO> qryOfflineResult(ActOfflineInvoiceQryExtNoQryBO actOfflineInvoiceQryBO) {
        ActOfflineInvoiceResultPO record = new ActOfflineInvoiceResultPO();
        record.setTaskId(actOfflineInvoiceQryBO.getTaskId());
        List<ActOfflineInvoiceResultPO> actOfflineInvoiceResultPOS = actOfflineInvoiceResultMapper.getList(record);
        if (actOfflineInvoiceResultPOS != null){
            if (!CollectionUtils.isEmpty(actOfflineInvoiceResultPOS)){
                return actOfflineInvoiceResultPOS.stream().map(po -> {
                    ActOfflineInvoiceResultBO bo = new ActOfflineInvoiceResultBO();
                    BeanUtils.copyProperties(po, bo);
                    return bo;
                }).collect(Collectors.toList());
            }
        }
        return null;
    }

    @Override
    public List<String> qryTaskItemByTaskId(Long taskId) {
        ActOfflineInvoiceItemPO record = new ActOfflineInvoiceItemPO();
        record.setTaskId(taskId);
        List<ActOfflineInvoiceItemPO> invoiceItemPOS = actOfflineInvoiceItemMapper.getList(record);
        if (invoiceItemPOS != null){
            if (!CollectionUtils.isEmpty(invoiceItemPOS)){
                return invoiceItemPOS.stream().map(ActOfflineInvoiceItemPO::getInvoiceNo).collect(Collectors.toList());
            }
        }
        return null;
    }
}
