package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoBO;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoListRspBO;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoReqBO;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoRspBO;
import com.tydic.dyc.act.repository.api.DycActOrderConsigneeInfoRepository;
import com.tydic.dyc.act.repository.dao.ActOrderConsigneeInfoMapper;
import com.tydic.dyc.act.repository.po.ActOrderConsigneeInfoPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("actOrderConsigneeInfoService")
public class DycActOrderConsigneeInfoRepositoryImpl implements DycActOrderConsigneeInfoRepository {

    @Autowired
    private ActOrderConsigneeInfoMapper actOrderConsigneeInfoMapper;

    @Override
    public ActOrderConsigneeInfoRspBO queryActOrderConsigneeInfoSingle(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO){
        ActOrderConsigneeInfoRspBO rspBO = new ActOrderConsigneeInfoRspBO();
        ActOrderConsigneeInfoPO selectActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
        BeanUtils.copyProperties(actOrderConsigneeInfoReqBO, selectActOrderConsigneeInfoPO);
        List<ActOrderConsigneeInfoPO> actOrderConsigneeInfoList = this.actOrderConsigneeInfoMapper.selectByCondition(selectActOrderConsigneeInfoPO);
        if (actOrderConsigneeInfoList.size() == 1) {
            ActOrderConsigneeInfoBO actOrderConsigneeInfoBO = new ActOrderConsigneeInfoBO();
            BeanUtils.copyProperties(actOrderConsigneeInfoList.get(0), actOrderConsigneeInfoBO);
            rspBO.setData(actOrderConsigneeInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actOrderConsigneeInfoList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActOrderConsigneeInfoListRspBO queryActOrderConsigneeInfoList(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO) {
        ActOrderConsigneeInfoListRspBO rspBO = new ActOrderConsigneeInfoListRspBO();
        ActOrderConsigneeInfoPO selectActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
        BeanUtils.copyProperties(actOrderConsigneeInfoReqBO, selectActOrderConsigneeInfoPO);
        List<ActOrderConsigneeInfoPO> actOrderConsigneeInfoPOList = this.actOrderConsigneeInfoMapper.selectByCondition(selectActOrderConsigneeInfoPO);

        List<ActOrderConsigneeInfoBO> actOrderConsigneeInfoBOList = new ArrayList<>();
        for (ActOrderConsigneeInfoPO actOrderConsigneeInfoPO : actOrderConsigneeInfoPOList) {
            ActOrderConsigneeInfoBO actOrderConsigneeInfoBO = new ActOrderConsigneeInfoBO();
            BeanUtils.copyProperties(actOrderConsigneeInfoPO, actOrderConsigneeInfoBO);
            actOrderConsigneeInfoBOList.add(actOrderConsigneeInfoBO);
        }

        rspBO.setData(actOrderConsigneeInfoBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActOrderConsigneeInfoBO> queryActOrderConsigneeInfoListPage(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO) {
        if (actOrderConsigneeInfoReqBO.getPageNo() < 1) {
            actOrderConsigneeInfoReqBO.setPageNo(1);
        }
        if (actOrderConsigneeInfoReqBO.getPageSize() < 1) {
            actOrderConsigneeInfoReqBO.setPageSize(10);
        }

        ActOrderConsigneeInfoPO selectActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
        BeanUtils.copyProperties(actOrderConsigneeInfoReqBO, selectActOrderConsigneeInfoPO);
        Page<ActOrderConsigneeInfoPO> page = PageHelper.startPage(actOrderConsigneeInfoReqBO.getPageNo(), actOrderConsigneeInfoReqBO.getPageSize()).doSelectPage(() -> this.actOrderConsigneeInfoMapper.selectByCondition(selectActOrderConsigneeInfoPO));

        //封装集合
        List<ActOrderConsigneeInfoBO> actOrderConsigneeInfoBOList = new ArrayList<>();
        for (ActOrderConsigneeInfoPO actOrderConsigneeInfoPO : page.getResult()) {
            ActOrderConsigneeInfoBO actOrderConsigneeInfoBO = new ActOrderConsigneeInfoBO();
            BeanUtils.copyProperties(actOrderConsigneeInfoPO, actOrderConsigneeInfoBO);
            actOrderConsigneeInfoBOList.add(actOrderConsigneeInfoBO);
        }

        RspPage<ActOrderConsigneeInfoBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderConsigneeInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActOrderConsigneeInfoRspBO addActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO) {
        ActOrderConsigneeInfoRspBO rspBO = new ActOrderConsigneeInfoRspBO();

        ActOrderConsigneeInfoPO insertActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
        BeanUtils.copyProperties(actOrderConsigneeInfoReqBO, insertActOrderConsigneeInfoPO);
        long id = Sequence.getInstance().nextId();
        insertActOrderConsigneeInfoPO.setId(id);
        //TODO 封装其它信息

        int num = this.actOrderConsigneeInfoMapper.insert(insertActOrderConsigneeInfoPO);
        if (num == 1) {
            ActOrderConsigneeInfoBO ActOrderConsigneeInfoBO = new ActOrderConsigneeInfoBO();
            BeanUtils.copyProperties(insertActOrderConsigneeInfoPO, ActOrderConsigneeInfoBO);
            rspBO.setData(ActOrderConsigneeInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActOrderConsigneeInfoListRspBO addListActOrderConsigneeInfo(List<ActOrderConsigneeInfoReqBO> actOrderConsigneeInfoReqBO) {
        ActOrderConsigneeInfoListRspBO rspBO = new ActOrderConsigneeInfoListRspBO();
        for(int i = 0;i < actOrderConsigneeInfoReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actOrderConsigneeInfoReqBO.get(i).setId(id);
                }

        List<ActOrderConsigneeInfoPO> insertActOrderConsigneeInfoPO = JSONObject.parseArray(JSONObject.toJSONString(actOrderConsigneeInfoReqBO),ActOrderConsigneeInfoPO.class);


        int num = this.actOrderConsigneeInfoMapper.allInsert(insertActOrderConsigneeInfoPO);
        if (num == actOrderConsigneeInfoReqBO.size()) {
            List<ActOrderConsigneeInfoBO> lActOrderConsigneeInfoBO = JSONObject.parseArray(JSONObject.toJSONString(insertActOrderConsigneeInfoPO),ActOrderConsigneeInfoBO.class);
            rspBO.setData(lActOrderConsigneeInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActOrderConsigneeInfoRspBO updateActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO) {
        ActOrderConsigneeInfoRspBO rspBO = new ActOrderConsigneeInfoRspBO();
        ActOrderConsigneeInfoPO selectActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
        selectActOrderConsigneeInfoPO.setId(actOrderConsigneeInfoReqBO.getId());
        List<ActOrderConsigneeInfoPO> actOrderConsigneeInfoList = this.actOrderConsigneeInfoMapper.selectByCondition(selectActOrderConsigneeInfoPO);
        if (actOrderConsigneeInfoList.size() == 1) {
            ActOrderConsigneeInfoPO updateActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
            BeanUtils.copyProperties(actOrderConsigneeInfoReqBO, updateActOrderConsigneeInfoPO);

            int num = this.actOrderConsigneeInfoMapper.update(updateActOrderConsigneeInfoPO);
            if (num == 1) {
                ActOrderConsigneeInfoBO actOrderConsigneeInfoBO = new ActOrderConsigneeInfoBO();
                BeanUtils.copyProperties(updateActOrderConsigneeInfoPO, actOrderConsigneeInfoBO);
                rspBO.setData(actOrderConsigneeInfoBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actOrderConsigneeInfoList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActOrderConsigneeInfoRspBO saveActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO) {
        //新增信息
        if (actOrderConsigneeInfoReqBO.getId() == null) {
            return this.addActOrderConsigneeInfo(actOrderConsigneeInfoReqBO);
        }
        //修改信息
        else {
            return this.updateActOrderConsigneeInfo(actOrderConsigneeInfoReqBO);
        }
    }

    @Override
    public ActOrderConsigneeInfoRspBO deleteActOrderConsigneeInfo(ActOrderConsigneeInfoReqBO actOrderConsigneeInfoReqBO) {
        ActOrderConsigneeInfoRspBO rspBO = new ActOrderConsigneeInfoRspBO();
        ActOrderConsigneeInfoPO selectActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
        selectActOrderConsigneeInfoPO.setId(actOrderConsigneeInfoReqBO.getId());
        List<ActOrderConsigneeInfoPO> actOrderConsigneeInfoList = this.actOrderConsigneeInfoMapper.selectByCondition(selectActOrderConsigneeInfoPO);
        if (actOrderConsigneeInfoList.size() == 1) {
            ActOrderConsigneeInfoPO deleteActOrderConsigneeInfoPO = new ActOrderConsigneeInfoPO();
            BeanUtils.copyProperties(actOrderConsigneeInfoReqBO, deleteActOrderConsigneeInfoPO);

            int num = this.actOrderConsigneeInfoMapper.delete(deleteActOrderConsigneeInfoPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actOrderConsigneeInfoList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

}
