package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActOrderInfoRepository;
import com.tydic.dyc.act.repository.dao.*;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName DycActOrderInfoRepositoryImpl
 * @Author 14051
 * @Date 2024/4/2 10:50
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActOrderInfoRepositoryImpl implements DycActOrderInfoRepository {

    @Autowired
    private ActOrderInfoMapperUni actOrderInfoMapperUni;
    @Autowired
    private ActOrderInfoMapper actOrderInfoMapper;
    @Autowired
    private ActOrderAfterInfoMapper actOrderAfterInfoMapper;

    @Autowired
    private ActOrderAfterItemMapper actOrderAfterItemMapper;

    @Autowired
    private ActOrderItemInfoMapper actOrderItemInfoMapper;
    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;
    @Autowired
    private ActFscCheckResultMapper actFscCheckResultMapper;

    @Override
    public BasePageRspBo<DycActOrderInfo> qryOrdInfoPageList(DycActOrderQryDO dycActOrderQryDO) {
        if (dycActOrderQryDO.getPageNo() < 1) {
            dycActOrderQryDO.setPageNo(1);
        }
        if (dycActOrderQryDO.getPageSize() < 1) {
            dycActOrderQryDO.setPageSize(10);
        }
        Page<ActOrderUniInfo> page;
        if ("1".equals(dycActOrderQryDO.getQryCheckFlag())){
            page = PageHelper.startPage(dycActOrderQryDO.getPageNo(), dycActOrderQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdCheckInfoPageByCond(dycActOrderQryDO));
        } else {
            page = PageHelper.startPage(dycActOrderQryDO.getPageNo(), dycActOrderQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdInfoPageByCond(dycActOrderQryDO));
        }
        //封装集合
        List<DycActOrderInfo> actOrderInfoBOList = new ArrayList<>();
        for (ActOrderUniInfo actOrderInfoPO : page.getResult()) {
            DycActOrderInfo actOrderInfoBO = new DycActOrderInfo();
            BeanUtils.copyProperties(actOrderInfoPO, actOrderInfoBO);
            actOrderInfoBO.setCheckState(actOrderInfoPO.getStatus());
            actOrderInfoBOList.add(actOrderInfoBO);
        }
        BasePageRspBo<DycActOrderInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public BasePageRspBo<DycActOrderAfsInfo> qryOrdAfsInfoPageList(DycActOrderAfsQryDO dycActOrderAfsQryDO) {
        if (dycActOrderAfsQryDO.getPageNo() < 1) {
            dycActOrderAfsQryDO.setPageNo(1);
        }
        if (dycActOrderAfsQryDO.getPageSize() < 1) {
            dycActOrderAfsQryDO.setPageSize(10);
        }
        Page<ActOrderAfsUniInfo> page = PageHelper.startPage(dycActOrderAfsQryDO.getPageNo(), dycActOrderAfsQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdAfsInfoPageByCond(dycActOrderAfsQryDO));
        //封装集合
        List<DycActOrderAfsInfo> actOrderAfsInfoBOList = new ArrayList<>();
        for (ActOrderAfsUniInfo actOrderAfsInfoPO : page.getResult()) {
            DycActOrderAfsInfo actOrderAfsInfoBO = new DycActOrderAfsInfo();
            BeanUtils.copyProperties(actOrderAfsInfoPO, actOrderAfsInfoBO);
            actOrderAfsInfoBO.setAfsOrderId(actOrderAfsInfoPO.getAfsServiceId());
            actOrderAfsInfoBO.setAfsDetailUrl(actOrderAfsInfoPO.getAfDetailUrl());
            actOrderAfsInfoBO.setCreateTime(actOrderAfsInfoPO.getAfsApplyTime());
            actOrderAfsInfoBO.setServState(actOrderAfsInfoPO.getAfsStep().toString());
            actOrderAfsInfoBO.setServStateStr(actOrderAfsInfoPO.getAfsStepName());
            actOrderAfsInfoBO.setServType(actOrderAfsInfoPO.getServType().toString());
            actOrderAfsInfoBO.setServTypeStr(actOrderAfsInfoPO.getServTypeName());
            actOrderAfsInfoBO.setReceiveTime(actOrderAfsInfoBO.getReceiveTime());
            actOrderAfsInfoBOList.add(actOrderAfsInfoBO);
        }
        BasePageRspBo<DycActOrderAfsInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderAfsInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public BigDecimal getTotalScoreByActivityId(DycActOrderQryDO dycActOrderQryDO) {
        return actOrderInfoMapper.getTotalScoreByActivityId(dycActOrderQryDO);
    }

    @Override
    public List<String> qryAlertOrderList(DycActDealAlertQryOrderDO reqBO) {
        //查询待预警数据之前先把有预警标识的数据清空
        ActOrderInfoPO updatePo = new ActOrderInfoPO();
        updatePo.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        actOrderInfoMapper.clearAlertType(updatePo);

        //将已存在的预警历史记录表的数据改为待处理（中间状态）
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.DEALING);
        actAlertInfoPO.setOldAlertState(DycActivityConstants.AlertState.UN_DEAL);
        actAlertInfoMapper.updateAlertState(actAlertInfoPO);

        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderState(reqBO.getOrderState());
        record.setDayNum(reqBO.getDayNum());
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            record.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())){
            record.setOrderIds(reqBO.getOrderIds());
        }
        if ("1".equals(reqBO.getAlertFlag())){
            return actOrderInfoMapper.qryUnSendOrderList(record);
        } else if ("2".equals(reqBO.getAlertFlag())) {
            return actOrderInfoMapper.qryUnReceiveOrderList(record);
        }
        return null;
    }

    @Override
    public void updateOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderId(dycActDealOrderAlertDO.getOrderId());
        record.setOrderIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        actOrderInfoMapper.updateAlertType(record);
    }

    @Override
    public List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return actOrderInfoMapperUni.qryExistAlertOrderList(dycActDealAlertQryOrderDO);
    }

    @Override
    public List<String> qryAlertAfsOrderList(DycActDealAlertQryOrderDO reqBO) {
        //查询待预警数据之前先把有预警标识的数据清空
        ActOrderAfterInfoPO updatePo = new ActOrderAfterInfoPO();
        updatePo.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        actOrderAfterInfoMapper.clearAlertType(updatePo);

        //将已存在的预警历史记录表的数据改为待处理（中间状态）
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.DEALING);
        actAlertInfoPO.setOldAlertState(DycActivityConstants.AlertState.UN_DEAL);
        actAlertInfoMapper.updateAlertState(actAlertInfoPO);

        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        if (StringUtils.isNotBlank(reqBO.getAfsServiceId())){
            record.setAfsServiceId(reqBO.getAfsServiceId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getAfsServiceIds())){
            record.setAfsServiceIds(reqBO.getAfsServiceIds());
        }
        record.setDayNum(reqBO.getDayNum());
        return actOrderAfterInfoMapper.qryUnRespOrderList(record);
    }

    @Override
    public void updateAfsOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        record.setAfsServiceId(dycActDealOrderAlertDO.getOrderId());
        record.setAfsServiceIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        actOrderAfterInfoMapper.updateAlertType(record);
    }

    @Override
    public List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return actOrderInfoMapperUni.qryExistAlertAfsOrderList(dycActDealAlertQryOrderDO);
    }

    @Override
    public List<DycActOrderInfo> qryActSum(List<String> reqBO) {
        if(CollectionUtils.isEmpty(reqBO)){
            return new ArrayList<>();
        }
        List<ActOrderInfoPO> infoPOS = actOrderInfoMapper.qryActSum(reqBO);
        return JSON.parseArray(JSON.toJSONString(infoPOS),DycActOrderInfo.class);
    }

    /**
     * 预警订单获取
     * @param dycActDealAlertQryOrderDO
     * @return
     */
    @Override
    public List<DycActOrderInfo> getWarnIngOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        ActOrderInfoQryPO actOrderInfoQryPO = ActRu.js(dycActDealAlertQryOrderDO,ActOrderInfoQryPO.class);
        List<ActOrderInfoPO> warnIngOrderList = actOrderInfoMapper.getWarnIngOrderList(actOrderInfoQryPO);
        return ActRu.jsl(warnIngOrderList, DycActOrderInfo.class);
    }

    /**
     * 预警售后单获取
     * @param qryDO
     * @return
     */
    @Override
    public List<ActOrderAfterInfo> getOrderAfterWaring(DycActOrderAfsQryDO qryDO) {
        ActOrderAfterInfoQryPO qryPO = ActRu.js(qryDO,ActOrderAfterInfoQryPO.class);
        List<ActOrderAfterInfoPO> orderAfterWaring = actOrderAfterInfoMapper.getOrderAfterWaring(qryPO);

        return ActRu.jsl(orderAfterWaring, ActOrderAfterInfo.class);
    }

    @Override
    public String getUnFinishOrderId(DycActOrderQryDO reqBO) {
        ActOrderInfoPO record= new ActOrderInfoPO();
        record.setExtActivityId(reqBO.getExtActivityId());
        return actOrderInfoMapper.getUnFinishOrderId(record);
    }

    @Override
    public DycActOrderInfo queryOrderDetail(DycActOrderQryDO qryDO) {
        ActOrderUniInfo actOrderUniInfo = actOrderInfoMapperUni.selectOrdInfoByCond(qryDO);
        return ActRu.js(actOrderUniInfo,DycActOrderInfo.class);
    }

    @Override
    public List<ActOrderItemInfoDO> qryOrderItemInfoList(DycActOrderQryDO qryDO) {
        ActOrderItemInfoPO qryPO = new ActOrderItemInfoPO();
        qryPO.setOrderId(Long.valueOf(qryDO.getOrderId()));
        List<ActOrderItemInfoPO> orderItemInfoPOS = actOrderItemInfoMapper.selectByCondition(qryPO);
        return ActRu.jsl(orderItemInfoPOS,ActOrderItemInfoDO.class);
    }

    @Override
    public DycActOrderAfsInfo queryAfsOrderDetail(DycActOrderAfsQryDO qryDO) {
        ActOrderAfterInfoPO qryPO = new ActOrderAfterInfoPO();
        qryPO.setAfsServiceId(qryDO.getAfsServiceId());
        List<ActOrderAfterInfoPO> actOrderAfterInfoList = actOrderAfterInfoMapper.selectByCondition(qryPO);
        if (actOrderAfterInfoList.size() == 1) {
            return ActRu.js(actOrderAfterInfoList.get(0),DycActOrderAfsInfo.class);
        } else if (actOrderAfterInfoList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
    }

    @Override
    public List<ActOrderAfterItemDO> qryAfsOrderItemInfoList(DycActOrderAfsQryDO qryDO) {
        ActOrderAfterItemPO qryPO = new ActOrderAfterItemPO();
        qryPO.setAfsServiceId(qryDO.getAfsServiceId());
        List<ActOrderAfterItemPO> orderAfterItemPOS = actOrderAfterItemMapper.selectByCondition(qryPO);
        return ActRu.jsl(orderAfterItemPOS,ActOrderAfterItemDO.class);
    }

    @Override
    public int updateOrderState(ActOrderStateUpdDO reqBO) {
        //如果对账表有该订单则删除
        ActFscCheckResultPO actFscCheckResultPO = new ActFscCheckResultPO();
        actFscCheckResultPO.setOrderId(reqBO.getOrderId());
        List<ActFscCheckResultPO> actFscCheckResultPOS = actFscCheckResultMapper.selectByCondition(actFscCheckResultPO);
        if (!CollectionUtils.isEmpty(actFscCheckResultPOS)){
            actFscCheckResultMapper.delete(actFscCheckResultPO);
        }
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderId(reqBO.getOrderId());
        record.setOrderState(reqBO.getOrderState());
        record.setOtherOrderState(reqBO.getOtherOrderState());
        record.setUpdateTime(reqBO.getUpdateTime());
        return actOrderInfoMapper.update(record);
    }

    @Override
    public String getUnFinishAfsOrderId(DycActOrderQryDO reqBO) {
        ActOrderAfterInfoPO record= new ActOrderAfterInfoPO();
        record.setExtActivityId(reqBO.getExtActivityId());
        return actOrderAfterInfoMapper.getUnFinishAfsOrderId(record);
    }
}
