package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActRelSourcePoolRepository;
import com.tydic.dyc.act.repository.dao.ActRelSourcePoolMapper;
import com.tydic.dyc.act.repository.po.ActRelSourcePoolExtPO;
import com.tydic.dyc.act.repository.po.ActRelSourcePoolPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("actRelSourcePoolService")
public class DycActRelSourcePoolRepositoryImpl implements DycActRelSourcePoolRepository {

    @Autowired
    ActRelSourcePoolMapper actRelSourcePoolMapper;

    @Override
    public ActRelSourcePoolRspBO queryActRelSourcePoolSingle(ActRelSourcePoolReqBO actRelSourcePoolReqBO){
        ActRelSourcePoolRspBO rspBO = new ActRelSourcePoolRspBO();
        ActRelSourcePoolExtPO selectActRelSourcePoolPO = new ActRelSourcePoolExtPO();
        BeanUtils.copyProperties(actRelSourcePoolReqBO, selectActRelSourcePoolPO);
        List<ActRelSourcePoolPO> actRelSourcePoolList = this.actRelSourcePoolMapper.selectByCondition(selectActRelSourcePoolPO);
        if (actRelSourcePoolList.size() == 1) {
            ActRelSourcePoolBO actRelSourcePoolBO = new ActRelSourcePoolBO();
            BeanUtils.copyProperties(actRelSourcePoolList.get(0), actRelSourcePoolBO);
            rspBO.setData(actRelSourcePoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actRelSourcePoolList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActRelSourcePoolListRspBO queryActRelSourcePoolList(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        ActRelSourcePoolListRspBO rspBO = new ActRelSourcePoolListRspBO();
        ActRelSourcePoolExtPO selectActRelSourcePoolPO = new ActRelSourcePoolExtPO();
        BeanUtils.copyProperties(actRelSourcePoolReqBO, selectActRelSourcePoolPO);
        List<ActRelSourcePoolPO> actRelSourcePoolPOList = this.actRelSourcePoolMapper.selectByCondition(selectActRelSourcePoolPO);

        List<ActRelSourcePoolBO> actRelSourcePoolBOList = new ArrayList<>();
        for (ActRelSourcePoolPO actRelSourcePoolPO : actRelSourcePoolPOList) {
            ActRelSourcePoolBO actRelSourcePoolBO = new ActRelSourcePoolBO();
            BeanUtils.copyProperties(actRelSourcePoolPO, actRelSourcePoolBO);
            actRelSourcePoolBOList.add(actRelSourcePoolBO);
        }

        rspBO.setData(actRelSourcePoolBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActRelSourcePoolBO> queryActRelSourcePoolListPage(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        if (actRelSourcePoolReqBO.getPageNo() < 1) {
            actRelSourcePoolReqBO.setPageNo(1);
        }
        if (actRelSourcePoolReqBO.getPageSize() < 1) {
            actRelSourcePoolReqBO.setPageSize(10);
        }

        ActRelSourcePoolExtPO selectActRelSourcePoolPO = new ActRelSourcePoolExtPO();
        BeanUtils.copyProperties(actRelSourcePoolReqBO, selectActRelSourcePoolPO);
        Page<ActRelSourcePoolPO> page = PageHelper.startPage(actRelSourcePoolReqBO.getPageNo(), actRelSourcePoolReqBO.getPageSize()).doSelectPage(() -> this.actRelSourcePoolMapper.selectByCondition(selectActRelSourcePoolPO));

        //封装集合
        List<ActRelSourcePoolBO> actRelSourcePoolBOList = new ArrayList<>();
        for (ActRelSourcePoolPO actRelSourcePoolPO : page.getResult()) {
            ActRelSourcePoolBO actRelSourcePoolBO = new ActRelSourcePoolBO();
            BeanUtils.copyProperties(actRelSourcePoolPO, actRelSourcePoolBO);
            actRelSourcePoolBOList.add(actRelSourcePoolBO);
        }

        RspPage<ActRelSourcePoolBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actRelSourcePoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActRelSourcePoolRspBO addActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        ActRelSourcePoolRspBO rspBO = new ActRelSourcePoolRspBO();

        ActRelSourcePoolPO insertActRelSourcePoolPO = new ActRelSourcePoolPO();
        BeanUtils.copyProperties(actRelSourcePoolReqBO, insertActRelSourcePoolPO);
        long id = Sequence.getInstance().nextId();
        insertActRelSourcePoolPO.setRelId(id);

        int num = this.actRelSourcePoolMapper.insert(insertActRelSourcePoolPO);
        if (num == 1) {
            ActRelSourcePoolBO ActRelSourcePoolBO = new ActRelSourcePoolBO();
            BeanUtils.copyProperties(insertActRelSourcePoolPO, ActRelSourcePoolBO);
            rspBO.setData(ActRelSourcePoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActRelSourcePoolListRspBO addListActRelSourcePool(List<ActRelSourcePoolReqBO> actRelSourcePoolReqBO) {
        ActRelSourcePoolListRspBO rspBO = new ActRelSourcePoolListRspBO();
        for(int i = 0;i < actRelSourcePoolReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actRelSourcePoolReqBO.get(i).setRelId(id);
                }

        List<ActRelSourcePoolPO> insertActRelSourcePoolPO = JSONObject.parseArray(JSONObject.toJSONString(actRelSourcePoolReqBO),ActRelSourcePoolPO.class);


        int num = this.actRelSourcePoolMapper.allInsert(insertActRelSourcePoolPO);
        if (num == actRelSourcePoolReqBO.size()) {
            List<ActRelSourcePoolBO> lActRelSourcePoolBO = JSONObject.parseArray(JSONObject.toJSONString(insertActRelSourcePoolPO),ActRelSourcePoolBO.class);
            rspBO.setData(lActRelSourcePoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActRelSourcePoolRspBO updateActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        ActRelSourcePoolRspBO rspBO = new ActRelSourcePoolRspBO();
        ActRelSourcePoolExtPO selectActRelSourcePoolPO = new ActRelSourcePoolExtPO();
        selectActRelSourcePoolPO.setRelId(actRelSourcePoolReqBO.getRelId());
        List<ActRelSourcePoolPO> actRelSourcePoolList = this.actRelSourcePoolMapper.selectByCondition(selectActRelSourcePoolPO);
        if (actRelSourcePoolList.size() == 1) {
            ActRelSourcePoolPO updateActRelSourcePoolPO = new ActRelSourcePoolPO();
            BeanUtils.copyProperties(actRelSourcePoolReqBO, updateActRelSourcePoolPO);

            int num = this.actRelSourcePoolMapper.update(updateActRelSourcePoolPO);
            if (num == 1) {
                ActRelSourcePoolBO actRelSourcePoolBO = new ActRelSourcePoolBO();
                BeanUtils.copyProperties(updateActRelSourcePoolPO, actRelSourcePoolBO);
                rspBO.setData(actRelSourcePoolBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actRelSourcePoolList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActRelSourcePoolRspBO saveActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        //新增信息
        if (actRelSourcePoolReqBO.getRelId() == null) {
            return this.addActRelSourcePool(actRelSourcePoolReqBO);
        }
        //修改信息
        else {
            return this.updateActRelSourcePool(actRelSourcePoolReqBO);
        }
    }

    @Override
    public ActRelSourcePoolRspBO deleteActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        ActRelSourcePoolRspBO rspBO = new ActRelSourcePoolRspBO();
        ActRelSourcePoolExtPO selectActRelSourcePoolPO = new ActRelSourcePoolExtPO();
        selectActRelSourcePoolPO.setRelId(actRelSourcePoolReqBO.getRelId());
        List<ActRelSourcePoolPO> actRelSourcePoolList = this.actRelSourcePoolMapper.selectByCondition(selectActRelSourcePoolPO);
        if (actRelSourcePoolList.size() == 1) {
            ActRelSourcePoolPO deleteActRelSourcePoolPO = new ActRelSourcePoolPO();
            BeanUtils.copyProperties(actRelSourcePoolReqBO, deleteActRelSourcePoolPO);

            int num = this.actRelSourcePoolMapper.delete(deleteActRelSourcePoolPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actRelSourcePoolList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActRelSourcePoolRspBO deleteListActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        ActRelSourcePoolRspBO rspBO = new ActRelSourcePoolRspBO();
        ActRelSourcePoolExtPO deleteActRelSourcePoolPO = new ActRelSourcePoolExtPO();
        deleteActRelSourcePoolPO.setSourceIdList(actRelSourcePoolReqBO.getSourceIdList());
        deleteActRelSourcePoolPO.setPoolId(actRelSourcePoolReqBO.getPoolId());
        this.actRelSourcePoolMapper.allDelete(deleteActRelSourcePoolPO);
        return rspBO;
    }

    @Override
    public Map<Long, Integer> getSkuNumBySource(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        ActRelSourcePoolExtPO sourcePoolExtPO = new ActRelSourcePoolExtPO();
        sourcePoolExtPO.setPoolId(actRelSourcePoolReqBO.getPoolId());
        sourcePoolExtPO.setPoolType(actRelSourcePoolReqBO.getPoolType());
        sourcePoolExtPO.setSourceIdList(actRelSourcePoolReqBO.getSourceIdList());
        List<ActRelSourcePoolExtPO> sourcePoolExtPOList = this.actRelSourcePoolMapper.getSkuNumBySource(sourcePoolExtPO);
        if (!CollectionUtils.isEmpty(sourcePoolExtPOList)) {
            return sourcePoolExtPOList.stream().collect(Collectors.toMap(ActRelSourcePoolExtPO::getSourceId,ActRelSourcePoolExtPO::getSkuNum));
        }
        return null;
    }

}
