package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActSkuInfoRepository;
import com.tydic.dyc.act.repository.dao.*;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service("actSkuInfoService")
@Slf4j
public class DycActSkuInfoRepositoryImpl implements DycActSkuInfoRepository {

    @Autowired
    ActSkuInfoMapper actSkuInfoMapper;
    @Autowired
    private ActSkuPoolMapper actSkuPoolMapper;

    @Autowired
    private ActSkuDetailMapper actSkuDetailMapper;

    @Autowired
    private ActSkuPicMapper actSkuPicMapper;

    @Autowired
    private ActSkuVendorMapper actSkuVendorMapper;

    @Override
    public ActSkuInfoRspBO queryActSkuInfoSingle(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        BeanUtils.copyProperties(actSkuInfoReqBO, selectActSkuInfoPO);
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByConditionAll(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(actSkuInfoList.get(0), actSkuInfoBO);
            rspBO.setData(actSkuInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuInfoList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuInfoListRspBO queryActSkuInfoList(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoListRspBO rspBO = new ActSkuInfoListRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        BeanUtils.copyProperties(actSkuInfoReqBO, selectActSkuInfoPO);
        List<ActSkuInfoPO> actSkuInfoPOList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);

        List<ActSkuInfoBO> actSkuInfoBOList = new ArrayList<>();
        for (ActSkuInfoPO actSkuInfoPO : actSkuInfoPOList) {
            ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(actSkuInfoPO, actSkuInfoBO);
            actSkuInfoBOList.add(actSkuInfoBO);
        }

        rspBO.setData(actSkuInfoBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public ActSkuInfoRspBO addActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();

        ActSkuInfoPO insertActSkuInfoPO = new ActSkuInfoPO();
        BeanUtils.copyProperties(actSkuInfoReqBO, insertActSkuInfoPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuInfoPO.setSkuId(id);
        //TODO 封装其它信息

        int num = this.actSkuInfoMapper.insert(insertActSkuInfoPO);
        if (num == 1) {
            ActSkuInfoBO ActSkuInfoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(insertActSkuInfoPO, ActSkuInfoBO);
            rspBO.setData(ActSkuInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuInfoListRspBO addListActSkuInfo(List<ActSkuInfoReqBO> actSkuInfoReqBO) {
        ActSkuInfoListRspBO rspBO = new ActSkuInfoListRspBO();
        for (int i = 0; i < actSkuInfoReqBO.size(); i++) {
            long id = Sequence.getInstance().nextId();
            actSkuInfoReqBO.get(i).setSkuId(id);
        }

        List<ActSkuInfoPO> insertActSkuInfoPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuInfoReqBO), ActSkuInfoPO.class);


        int num = this.actSkuInfoMapper.allInsert(insertActSkuInfoPO);
        if (num == actSkuInfoReqBO.size()) {
            List<ActSkuInfoBO> lActSkuInfoBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuInfoPO), ActSkuInfoBO.class);
            rspBO.setData(lActSkuInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuInfoRspBO updateActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        selectActSkuInfoPO.setSkuId(actSkuInfoReqBO.getSkuId());
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            ActSkuInfoPO updateActSkuInfoPO = new ActSkuInfoPO();
            BeanUtils.copyProperties(actSkuInfoReqBO, updateActSkuInfoPO);

            int num = this.actSkuInfoMapper.update(updateActSkuInfoPO);
            if (num == 1) {
                ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
                BeanUtils.copyProperties(updateActSkuInfoPO, actSkuInfoBO);
                rspBO.setData(actSkuInfoBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuInfoList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuInfoRspBO saveActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        //新增信息
        if (actSkuInfoReqBO.getSkuId() == null) {
            return this.addActSkuInfo(actSkuInfoReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuInfo(actSkuInfoReqBO);
        }
    }

    @Override
    public ActSkuInfoRspBO deleteActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        selectActSkuInfoPO.setSkuId(actSkuInfoReqBO.getSkuId());
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            ActSkuInfoPO deleteActSkuInfoPO = new ActSkuInfoPO();
            BeanUtils.copyProperties(actSkuInfoReqBO, deleteActSkuInfoPO);

            int num = this.actSkuInfoMapper.delete(deleteActSkuInfoPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuInfoList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public Map<Long, ActSkuInfoBO> queryActSkuInfoByIdList(List<Long> skuIds) {
        List<ActSkuInfoExtPO> rspBO = actSkuInfoMapper.selectBySkuIdsCondition(skuIds);
        //查询单品所属商品池名称
        List<ActSkuPoolExtPO> actSkuPoolExtPOS = actSkuPoolMapper.selectBySkuIdsCondition(skuIds);
        Map<Long, List<ActSkuPoolExtPO>> poolMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(actSkuPoolExtPOS)) {
            poolMap = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
        }
        Map<Long, ActSkuInfoBO> map = new HashMap<>();
        for (ActSkuInfoExtPO item : rspBO) {
            ActSkuInfoBO infoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(item, infoBO);
            if (!poolMap.isEmpty()) {
                //组装商品池名称
                if (poolMap.containsKey(item.getSkuId())) {
                    List<ActSkuPoolExtPO> poolList = poolMap.get(item.getSkuId());
                    List<String> poolNameList = poolList.stream().map(ActSkuPoolExtPO::getPoolName).distinct().collect(Collectors.toList());
                    String poolNames = String.join(",", poolNameList);
                    infoBO.setPoolNames(poolNames);
                }
            }
            map.put(item.getSkuId(), infoBO);
        }
        return map;
    }

    @Override
    public ActSkuInfoQryRspBO querySkuPageList(ActSkuInfoQryBO qryBO) {
        ActSkuInfoExtPO qryPO = ActRu.js(qryBO, ActSkuInfoExtPO.class);
        Page<ActSkuInfoExtPO> page = PageHelper.startPage(qryBO.getPageNo(), qryBO.getPageSize()).doSelectPage(() -> this.actSkuInfoMapper.getListPage(qryPO));
        if (qryBO.getQryExtMain()) {
            setOtherExtInfo(page);
        }
        ActSkuInfoQryRspBO rspBo = new ActSkuInfoQryRspBO();
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRows(!CollectionUtils.isEmpty(page.getResult()) ? ActRu.jsl(page.getResult(), ActSkuInfoDO.class) : new ArrayList<>(0));
        return rspBo;
    }

    @Override
    public ActSkuInfoQryRspBO querySkuPageListByLowestPrice(ActSkuInfoQryBO qryBO) {
        ActSkuInfoExtPO qryPO = ActRu.js(qryBO, ActSkuInfoExtPO.class);
        Page<ActSkuInfoExtPO> page = PageHelper.startPage(qryBO.getPageNo(), qryBO.getPageSize()).doSelectPage(() -> this.actSkuInfoMapper.getListPageByLowestPrice(qryPO));
        if (qryBO.getQryExtMain()) {
            setOtherExtInfo(page);
        }
        ActSkuInfoQryRspBO rspBo = new ActSkuInfoQryRspBO();
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRows(!CollectionUtils.isEmpty(page.getResult()) ? ActRu.jsl(page.getResult(), ActSkuInfoDO.class) : new ArrayList<>(0));
        return rspBo;
    }


    private void setOtherExtInfo(Page<ActSkuInfoExtPO> page) {
        if (!CollectionUtils.isEmpty(page.getResult())) {
            List<Long> supplierIds = page.getResult().stream().map(ActSkuInfoExtPO::getSupplierId).collect(Collectors.toList());
            List<Long> skuIds = page.getResult().stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList());
            // 查询供应商编码
            ActSkuVendorExtPO vendorExtPO = new ActSkuVendorExtPO();
            vendorExtPO.setVendorIdList(supplierIds);
            List<ActSkuVendorPO> actSkuVendorPOS = actSkuVendorMapper.selectByCondition(vendorExtPO);
            Map<Long, String> supIdToCode = new HashMap<>();
            if (!CollectionUtils.isEmpty(actSkuVendorPOS)) {
                supIdToCode = actSkuVendorPOS.stream().collect(Collectors.toMap(ActSkuVendorPO::getVendorId, ActSkuVendorPO::getVendorCode));
            }

            // 查询商品详情
            ActSkuDetailPO detailPO = new ActSkuDetailPO();
            detailPO.setSkuIds(skuIds);
            List<ActSkuDetailPO> actSkuDetailPOS = actSkuDetailMapper.selectByCondition(detailPO);
            Map<Long, String> detailIdToUrl = new HashMap<>();
            if (!CollectionUtils.isEmpty(actSkuDetailPOS)) {
                detailIdToUrl = actSkuDetailPOS.stream().collect(Collectors.toMap(ActSkuDetailPO::getSkuId, ActSkuDetailPO::getSkuPcDetailUrl));
            }

            // 查询商品主图
            ActSkuPicPO skuPicPO = new ActSkuPicPO();
            skuPicPO.setSkuIds(skuIds);
            skuPicPO.setPicType(1);
            List<ActSkuPicPO> actSkuPicPOS = actSkuPicMapper.selectByCondition(skuPicPO);
            Map<Long, String> picIdToPicUrl = new HashMap<>();
            if (!CollectionUtils.isEmpty(actSkuPicPOS)) {
                picIdToPicUrl = actSkuPicPOS.stream().collect(Collectors.toMap(ActSkuPicPO::getSkuId, ActSkuPicPO::getSkuPicUrl));
            }

            // 通过商品ID查商品池名称
            //查询单品所属商品池名称
            List<ActSkuPoolExtPO> actSkuPoolExtPOS = new ArrayList<>();
            ActSkuPoolExtPO actSkuPoolExtPO = new ActSkuPoolExtPO();
            actSkuPoolExtPO.setSkuIdList(skuIds);
            List<ActSkuPoolExtPO> skuPoolRelSkuList = actSkuPoolMapper.getListSkuPoolRelSku(actSkuPoolExtPO);
            if (!CollectionUtils.isEmpty(skuPoolRelSkuList)) {
                actSkuPoolExtPOS.addAll(skuPoolRelSkuList);
            }
            List<ActSkuPoolExtPO> skuPoolRelSourceList = actSkuPoolMapper.getListSkuPoolRelSource(actSkuPoolExtPO);
            if (!CollectionUtils.isEmpty(skuPoolRelSourceList)) {
                actSkuPoolExtPOS.addAll(skuPoolRelSourceList);
            }
            log.info("商品池名称集合：{}",JSON.toJSONString(actSkuPoolExtPOS));
            Map<Long, List<ActSkuPoolExtPO>> skuIdToPoolName = new HashMap<>();
            if (!CollectionUtils.isEmpty(actSkuPoolExtPOS)) {
                skuIdToPoolName = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
            }
            for (ActSkuInfoExtPO actSkuInfoExtPO : page.getResult()) {

                if (supIdToCode.containsKey(actSkuInfoExtPO.getSupplierId())) {
                    actSkuInfoExtPO.setSupplierCode(supIdToCode.get(actSkuInfoExtPO.getSupplierId()));
                }

                if (detailIdToUrl.containsKey(actSkuInfoExtPO.getSkuId())) {
                    actSkuInfoExtPO.setSkuPcDetailUrl(detailIdToUrl.get(actSkuInfoExtPO.getSkuId()));
                }

                if (picIdToPicUrl.containsKey(actSkuInfoExtPO.getSkuId())) {
                    actSkuInfoExtPO.setPicUrl(picIdToPicUrl.get(actSkuInfoExtPO.getSkuId()));
                }

                if (skuIdToPoolName.containsKey(actSkuInfoExtPO.getSkuId())) {
                    List<ActSkuPoolExtPO> poolList = skuIdToPoolName.get(actSkuInfoExtPO.getSkuId());
                    List<String> poolNameList = poolList.stream().map(ActSkuPoolExtPO::getPoolName).distinct().collect(Collectors.toList());
                    String poolNames = String.join(",", poolNameList);
                    actSkuInfoExtPO.setSkuPools(poolNames);
                }
            }
        }
    }

    /**
     * 根据外部商品id查询商品信息
     *
     * @param extSkuIds
     * @return
     */
    @Override
    public Map<String, ActSkuInfoBO> queryActSkuInfoByCodeList(List<String> extSkuIds) {
        List<ActSkuInfoExtPO> rspBO = actSkuInfoMapper.selectBySkuCodesCondition(extSkuIds);

        if (CollectionUtils.isEmpty(rspBO)) {
            return new HashMap<>();
        }
        List<Long> skuIds = rspBO.stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList());
        //查询单品所属商品池名称
        Long start = System.currentTimeMillis();
        List<ActSkuPoolExtPO> actSkuPoolExtPOS = new ArrayList<>();
        ActSkuPoolExtPO actSkuPoolExtPO = new ActSkuPoolExtPO();
        actSkuPoolExtPO.setSkuIdList(skuIds);
        List<ActSkuPoolExtPO> skuPoolRelSkuList = actSkuPoolMapper.getListSkuPoolRelSku(actSkuPoolExtPO);
        if (!CollectionUtils.isEmpty(skuPoolRelSkuList)) {
            actSkuPoolExtPOS.addAll(skuPoolRelSkuList);
        }
        List<ActSkuPoolExtPO> skuPoolRelSourceList = actSkuPoolMapper.getListSkuPoolRelSource(actSkuPoolExtPO);
        if (!CollectionUtils.isEmpty(skuPoolRelSourceList)) {
            actSkuPoolExtPOS.addAll(skuPoolRelSourceList);
        }
        log.info("查询商品池所花时间{}", System.currentTimeMillis() - start);
        log.info("查询商品池出参{}", JSONObject.toJSONString(actSkuPoolExtPOS));
        //查询出所有商品详情
        ActSkuDetailPO actSkuDetailPO = new ActSkuDetailPO();
        actSkuDetailPO.setSkuIds(skuIds);
        List<ActSkuDetailPO> actSkuDetailPOS = actSkuDetailMapper.selectByCondition(actSkuDetailPO);
        Map<Long, List<ActSkuDetailPO>> detailMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(actSkuDetailPOS)) {
            detailMap = actSkuDetailPOS.stream().collect(Collectors.groupingBy(ActSkuDetailPO::getSkuId));
        }

        //查询所有商品图片
        ActSkuPicPO actSkuPicPO = new ActSkuPicPO();
        actSkuPicPO.setSkuIds(skuIds);
        actSkuPicPO.setPicType(DycActivityConstants.PicType.CZG);
        List<ActSkuPicPO> actSkuPicPOS = actSkuPicMapper.selectByCondition(actSkuPicPO);
        Map<Long, List<ActSkuPicPO>> picMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(actSkuPicPOS)) {
            picMap = actSkuPicPOS.stream().collect(Collectors.groupingBy(ActSkuPicPO::getSkuId));
        }

        Map<Long, List<ActSkuPoolExtPO>> poolMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(actSkuPoolExtPOS)) {
            poolMap = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
        }
        Map<String, ActSkuInfoBO> map = new HashMap<>();
        for (ActSkuInfoExtPO item : rspBO) {
            ActSkuInfoBO infoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(item, infoBO);
            //组装商品池名称
            if (poolMap.containsKey(item.getSkuId())) {
                List<ActSkuPoolExtPO> poolList = poolMap.get(item.getSkuId());
                List<String> poolNameList = poolList.stream().map(ActSkuPoolExtPO::getPoolName).distinct().collect(Collectors.toList());
                String poolNames = String.join(",", poolNameList);
                infoBO.setPoolNames(poolNames);
            }
            //组装商品图片
            if (picMap.containsKey(item.getSkuId())) {
                List<ActSkuPicPO> picList = picMap.get(item.getSkuId());
                infoBO.setSkuUrl(picList.get(0).getSkuPicUrl());
            }
            //组装商品详情
            if (detailMap.containsKey(item.getSkuId())) {
                List<ActSkuDetailPO> detailList = detailMap.get(item.getSkuId());
                infoBO.setSkuPcDetailUrl(detailList.get(0).getSkuPcDetailUrl());
            }
            map.put(item.getExtSkuId(), infoBO);
        }
        return map;
    }

    @Override
    public ActSkuInfoQryRspBO qrySkuPushInfo(List<Long> skuIds) {
        List<ActSkuInfoExtPO> actSkuInfoExtPOS = actSkuInfoMapper.selectSkuInfoByIds(skuIds);
        List<ActSkuInfoDO> rows = JUtil.jsl(actSkuInfoExtPOS, ActSkuInfoDO.class);
        ActSkuInfoQryRspBO rspBO = new ActSkuInfoQryRspBO();
        rspBO.setRows(rows);
        return rspBO;
    }

    @Override
    public ActSkuCheckInfoRspBO qryCheckSkuInfo(List<Long> skuIds) {
        List<ActSkuInfoExtPO> actSkuInfoExtPOS = actSkuInfoMapper.qrySkuCheckInfoByIds(skuIds);
        List<ActSkuCheckInfoBO> rows = JUtil.jsl(actSkuInfoExtPOS, ActSkuCheckInfoBO.class);
        for (ActSkuCheckInfoBO row : rows) {
            // 翻译
            if (DycActivityConstants.SkuStatue.ON_SALE.equals(row.getSkuStatus())) {
                row.setSkuState(DycActivityConstants.SkuStatue.ON_SALE_STR);
            } else if (DycActivityConstants.SkuStatue.WITHDRAWN.equals(row.getSkuStatus())) {
                row.setSkuState(DycActivityConstants.SkuStatue.WITHDRAWN_STR);
            } else if (DycActivityConstants.SkuStatue.DELETE.equals(row.getSkuStatus())) {
                row.setSkuState(DycActivityConstants.SkuStatue.DELETE_STR);
            }
        }
        ActSkuCheckInfoRspBO rspBO = new ActSkuCheckInfoRspBO();
        rspBO.setRows(rows);
        return rspBO;
    }

    @Override
    public ActSkuInfoRspBO modifySkuCheckInfo(ActSkuInfoReqBO reqBO) {
        ActSkuInfoExtPO extPO = new ActSkuInfoExtPO();
        extPO.setSkuIds(reqBO.getSkuIds());
        extPO.setIsAnomalousPic(reqBO.getIsAnomalousPic());
        extPO.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
        actSkuInfoMapper.updateSkuInfo(extPO);
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        return rspBO;
    }

    @Override
    public ActJudgeGuideLowestPriceRspBO judgeGuideLowestPrice(ActJudgeGuideLowestPriceReqBO reqBO) {
        Long start = System.currentTimeMillis();
        if (ObjectUtil.isEmpty(reqBO.getGuideIds())) {
            throw new ZTBusinessException("类目ID不能为空");
        }
        List<ActJudgeGuideLowestPriceBO> result = new ArrayList<>();
        ActJudgeGuideLowestPriceRspBO rspBO = new ActJudgeGuideLowestPriceRspBO();
        ActSkuInfoExtPO skuInfoExtPO = new ActSkuInfoExtPO();
        skuInfoExtPO.setGuideIdList(reqBO.getGuideIds());
        skuInfoExtPO.setIsAnomalousPrice(DycActivityConstants.IsAnomalousPrice.NORMAL);
        skuInfoExtPO.setAgreementPriceMin(reqBO.getAgreementPriceMin());
        skuInfoExtPO.setAgreementPriceMax(reqBO.getAgreementPriceMax());
        skuInfoExtPO.setQryDisableCatalog(Boolean.TRUE);
        skuInfoExtPO.setSkuStatusList(Collections.singletonList(1));
        List<ActSkuInfoExtPO> actSkuInfoExtPOS = actSkuInfoMapper.selectByConditionExt(skuInfoExtPO);
        if (CollectionUtils.isEmpty(actSkuInfoExtPOS)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }
        Map<Long, List<ActSkuInfoExtPO>> guideMap = actSkuInfoExtPOS.stream().collect(Collectors.groupingBy(ActSkuInfoExtPO::getGuideId));
        // 根据单个类目匹配最低价
        for (Long guiId : reqBO.getGuideIds()) {
            ActJudgeGuideLowestPriceBO actJudgeGuideLowestPriceBO = new ActJudgeGuideLowestPriceBO();
            actJudgeGuideLowestPriceBO.setGuideId(guiId);
            if (guideMap.containsKey(guiId)) {
                List<ActSkuInfoExtPO> actSkuInfoExtPOList = guideMap.get(guiId);
                List<String> upcList = actSkuInfoExtPOList.stream().map(ActSkuInfoExtPO::getUpc).collect(Collectors.toList());
                List<String> checkAfter = this.checkUpcList(upcList);
                // 判断69码全部符合规则且要过滤最低价
                if (!checkAfter.isEmpty() && ActConstants.LowPrice.YES.equals(reqBO.getLowPrice())) {
                    List<Long> skuIds = new ArrayList<>();
                    ActSkuInfoExtPO guideQryBO = new ActSkuInfoExtPO();
                    guideQryBO.setGuideId(guiId);
                    guideQryBO.setUpcList(checkAfter);
                    guideQryBO.setAgreementPriceMin(reqBO.getAgreementPriceMin());
                    guideQryBO.setAgreementPriceMax(reqBO.getAgreementPriceMax());
                    guideQryBO.setIsAnomalousPrice(DycActivityConstants.IsAnomalousPrice.NORMAL);
                    guideQryBO.setQryDisableCatalog(Boolean.TRUE);
                    guideQryBO.setSkuStatusList(Collections.singletonList(1));
                    List<ActSkuInfoPO> guideQryRspPOList = actSkuInfoMapper.selectByCondition(guideQryBO);
                    // 如果类目下查出来符合条件的商品，跳过
                    if (CollectionUtils.isEmpty(guideQryRspPOList)) {
                        actJudgeGuideLowestPriceBO.setSkuCount(actSkuInfoExtPOList.size());
                        actJudgeGuideLowestPriceBO.setSkuIds(actSkuInfoExtPOList.stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList()));
                        continue;
                    }

                    // 同款商品最低价返回
                    Map<String, ActSkuInfoPO> upcToLowestPriceMap = guideQryRspPOList.stream()
                            .collect(Collectors.groupingBy(
                                    ActSkuInfoPO::getUpc,
                                    Collectors.collectingAndThen(
                                            Collectors.toList(),
                                            // 在每组中排序，并取最小的agreementPrice对应的对象
                                            l -> l.stream()
                                                    .min(Comparator.comparing(ActSkuInfoPO::getAgreementPrice))
                                                    .orElse(null)
                                    )
                            ));
                    // 同69码下最低价商品
                    log.info("同69码下最低价商品:{}", JSON.toJSONString(upcToLowestPriceMap));
                    // 遍历查看商品集合下最低价商品
                    for (ActSkuInfoExtPO skuInfo : actSkuInfoExtPOList) {
                        if (upcToLowestPriceMap.containsKey(skuInfo.getUpc())) {
                            // 如果存在返回同类目同款商品下最低价商品
                            skuIds.add(upcToLowestPriceMap.get(skuInfo.getUpc()).getSkuId());
                        } else {
                            // 如果不存在则表示没有69码，自己就是最低价商品
                            skuIds.add(skuInfo.getSkuId());
                        }
                    }
                    List<Long> disSkuIds = skuIds.stream().distinct().collect(Collectors.toList());
                    // 返回过滤结果
                    actJudgeGuideLowestPriceBO.setSkuCount(disSkuIds.size());
                    actJudgeGuideLowestPriceBO.setSkuIds(disSkuIds);
                } else { // 不过滤最低价
                    actJudgeGuideLowestPriceBO.setSkuCount(actSkuInfoExtPOList.size());
                    actJudgeGuideLowestPriceBO.setSkuIds(actSkuInfoExtPOList.stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList()));
                }
            } else { // 该类目下没商品
                actJudgeGuideLowestPriceBO.setSkuCount(0);
            }
            result.add(actJudgeGuideLowestPriceBO);
        }
        log.info("查询同款最低价所花时间{}", System.currentTimeMillis() - start);
        log.info("查询结果出参：{}",result);
        rspBO.setResult(result);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc("查询成功");
        return rspBO;
    }

    @Override
    public ActJudgeGuideLowestPriceRspBO queryGuideToNumMap(ActJudgeGuideLowestPriceReqBO reqBO) {
        ActJudgeGuideLowestPriceRspBO rspBO = new ActJudgeGuideLowestPriceRspBO();
        ActSkuInfoExtPO infoExtPO = new ActSkuInfoExtPO();
        infoExtPO.setGuideIdList(reqBO.getGuideIds());
        infoExtPO.setAgreementPriceMax(reqBO.getAgreementPriceMax());
        infoExtPO.setAgreementPriceMin(reqBO.getAgreementPriceMin());
        infoExtPO.setIsAnomalousPrice(1);
        infoExtPO.setIsAnomalousPic(1);
        infoExtPO.setSkuStatusList(Collections.singletonList(1));
        infoExtPO.setQryNotDelFlag(Boolean.TRUE);
        Map<Long, List<ActSkuInfoExtPO>> guiIdGroup = new HashMap<>();
        if (ActConstants.LowPrice.YES.equals(reqBO.getLowPrice())) {
            List<ActSkuInfoExtPO> lowestPrice = actSkuInfoMapper.getListPageByLowestPrice(infoExtPO);
            guiIdGroup = lowestPrice.stream().collect(Collectors.groupingBy(ActSkuInfoExtPO::getGuideId));
        } else {
            List<ActSkuInfoExtPO> lowestPrice = actSkuInfoMapper.getListPage(infoExtPO);
            guiIdGroup = lowestPrice.stream().collect(Collectors.groupingBy(ActSkuInfoExtPO::getGuideId));
        }
        if (guiIdGroup.isEmpty()) {
            return rspBO;
        }
        List<ActJudgeGuideLowestPriceBO> result = new ArrayList<>();
        for (Long guideId : reqBO.getGuideIds()) {
            ActJudgeGuideLowestPriceBO lowestPriceBO = new ActJudgeGuideLowestPriceBO();
            lowestPriceBO.setGuideId(guideId);
            if (guiIdGroup.containsKey(guideId)) {
                List<ActSkuInfoExtPO> extPOList = guiIdGroup.get(guideId);
                if (CollUtil.isEmpty(extPOList)) {
                    lowestPriceBO.setSkuCount(0);
                } else {
                    lowestPriceBO.setSkuCount(extPOList.size());
                    lowestPriceBO.setSkuIds(extPOList.stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList()));
                }
                result.add(lowestPriceBO);
                continue;
            }
            lowestPriceBO.setSkuCount(0);
            result.add(lowestPriceBO);
        }
        rspBO.setResult(result);
        return rspBO;
    }

    @Override
    public List<Long> queryCatalogListByLowestPrice(ActSkuInfoQryBO qryBO) {
        ActSkuInfoExtPO qryPO = ActRu.js(qryBO, ActSkuInfoExtPO.class);
        return this.actSkuInfoMapper.queryCatalogListByLowestPrice(qryPO);
    }

    @Override
    public List<Long> queryCatalogList(ActSkuInfoQryBO qryBO) {
        ActSkuInfoExtPO qryPO = ActRu.js(qryBO, ActSkuInfoExtPO.class);
        return this.actSkuInfoMapper.queryCatalogList(qryPO);
    }

    public List<String> checkUpcList(List<String> upcList) {
        List<String> checkAfter = new ArrayList<>();
        for (String upc : upcList) {
            if (upc.contains(";") || allZeros(upc) || upc.isEmpty() || checkAfter.contains(upc)) {
                continue;
            }
            checkAfter.add(upc);
        }
        return checkAfter;
    }



    // 判断字符串是否全为'0'
    public static boolean allZeros(String str) {
        for (int i = 0; i < str.length(); i++) {
            if (str.charAt(i) != '0') {
                return false;
            }
        }
        return true;
    }

}
