package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActSkuPicBO;
import com.tydic.dyc.act.model.bo.ActSkuPicListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPicReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPicRspBO;
import com.tydic.dyc.act.repository.api.DycActSkuPicRepository;
import com.tydic.dyc.act.repository.dao.ActSkuPicMapper;
import com.tydic.dyc.act.repository.po.ActSkuPicPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("actSkuPicService")
public class DycActSkuPicRepositoryImpl implements DycActSkuPicRepository {

    @Autowired
    ActSkuPicMapper actSkuPicMapper;

    @Override
    public ActSkuPicRspBO queryActSkuPicSingle(ActSkuPicReqBO actSkuPicReqBO){
        ActSkuPicRspBO rspBO = new ActSkuPicRspBO();
        ActSkuPicPO selectActSkuPicPO = new ActSkuPicPO();
        BeanUtils.copyProperties(actSkuPicReqBO, selectActSkuPicPO);
        List<ActSkuPicPO> actSkuPicList = this.actSkuPicMapper.selectByCondition(selectActSkuPicPO);
        if (actSkuPicList.size() == 1) {
            ActSkuPicBO actSkuPicBO = new ActSkuPicBO();
            BeanUtils.copyProperties(actSkuPicList.get(0), actSkuPicBO);
            rspBO.setData(actSkuPicBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuPicList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuPicListRspBO queryActSkuPicList(ActSkuPicReqBO actSkuPicReqBO) {
        ActSkuPicListRspBO rspBO = new ActSkuPicListRspBO();
        ActSkuPicPO selectActSkuPicPO = new ActSkuPicPO();
        BeanUtils.copyProperties(actSkuPicReqBO, selectActSkuPicPO);
        List<ActSkuPicPO> actSkuPicPOList = this.actSkuPicMapper.selectByCondition(selectActSkuPicPO);

        List<ActSkuPicBO> actSkuPicBOList = new ArrayList<>();
        for (ActSkuPicPO actSkuPicPO : actSkuPicPOList) {
            ActSkuPicBO actSkuPicBO = new ActSkuPicBO();
            BeanUtils.copyProperties(actSkuPicPO, actSkuPicBO);
            actSkuPicBOList.add(actSkuPicBO);
        }

        rspBO.setData(actSkuPicBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActSkuPicBO> queryActSkuPicListPage(ActSkuPicReqBO actSkuPicReqBO) {
        if (actSkuPicReqBO.getPageNo() < 1) {
            actSkuPicReqBO.setPageNo(1);
        }
        if (actSkuPicReqBO.getPageSize() < 1) {
            actSkuPicReqBO.setPageSize(10);
        }

        ActSkuPicPO selectActSkuPicPO = new ActSkuPicPO();
        BeanUtils.copyProperties(actSkuPicReqBO, selectActSkuPicPO);
        Page<ActSkuPicPO> page = PageHelper.startPage(actSkuPicReqBO.getPageNo(), actSkuPicReqBO.getPageSize()).doSelectPage(() -> this.actSkuPicMapper.selectByCondition(selectActSkuPicPO));

        //封装集合
        List<ActSkuPicBO> actSkuPicBOList = new ArrayList<>();
        for (ActSkuPicPO actSkuPicPO : page.getResult()) {
            ActSkuPicBO actSkuPicBO = new ActSkuPicBO();
            BeanUtils.copyProperties(actSkuPicPO, actSkuPicBO);
            actSkuPicBOList.add(actSkuPicBO);
        }

        RspPage<ActSkuPicBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuPicBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActSkuPicRspBO addActSkuPic(ActSkuPicReqBO actSkuPicReqBO) {
        ActSkuPicRspBO rspBO = new ActSkuPicRspBO();

        ActSkuPicPO insertActSkuPicPO = new ActSkuPicPO();
        BeanUtils.copyProperties(actSkuPicReqBO, insertActSkuPicPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuPicPO.setPicId(id);
        //TODO 封装其它信息

        int num = this.actSkuPicMapper.insert(insertActSkuPicPO);
        if (num == 1) {
            ActSkuPicBO ActSkuPicBO = new ActSkuPicBO();
            BeanUtils.copyProperties(insertActSkuPicPO, ActSkuPicBO);
            rspBO.setData(ActSkuPicBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuPicListRspBO addListActSkuPic(List<ActSkuPicReqBO> actSkuPicReqBO) {
        ActSkuPicListRspBO rspBO = new ActSkuPicListRspBO();
        for(int i = 0;i < actSkuPicReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuPicReqBO.get(i).setPicId(id);
                }

        List<ActSkuPicPO> insertActSkuPicPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuPicReqBO),ActSkuPicPO.class);


        int num = this.actSkuPicMapper.allInsert(insertActSkuPicPO);
        if (num == actSkuPicReqBO.size()) {
            List<ActSkuPicBO> lActSkuPicBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuPicPO),ActSkuPicBO.class);
            rspBO.setData(lActSkuPicBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuPicRspBO updateActSkuPic(ActSkuPicReqBO actSkuPicReqBO) {
        ActSkuPicRspBO rspBO = new ActSkuPicRspBO();
        ActSkuPicPO selectActSkuPicPO = new ActSkuPicPO();
        selectActSkuPicPO.setPicId(actSkuPicReqBO.getPicId());
        List<ActSkuPicPO> actSkuPicList = this.actSkuPicMapper.selectByCondition(selectActSkuPicPO);
        if (actSkuPicList.size() == 1) {
            ActSkuPicPO updateActSkuPicPO = new ActSkuPicPO();
            BeanUtils.copyProperties(actSkuPicReqBO, updateActSkuPicPO);

            int num = this.actSkuPicMapper.update(updateActSkuPicPO);
            if (num == 1) {
                ActSkuPicBO actSkuPicBO = new ActSkuPicBO();
                BeanUtils.copyProperties(updateActSkuPicPO, actSkuPicBO);
                rspBO.setData(actSkuPicBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuPicList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuPicRspBO saveActSkuPic(ActSkuPicReqBO actSkuPicReqBO) {
        //新增信息
        if (actSkuPicReqBO.getPicId() == null) {
            return this.addActSkuPic(actSkuPicReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuPic(actSkuPicReqBO);
        }
    }

    @Override
    public ActSkuPicRspBO deleteActSkuPic(ActSkuPicReqBO actSkuPicReqBO) {
        ActSkuPicRspBO rspBO = new ActSkuPicRspBO();
        ActSkuPicPO selectActSkuPicPO = new ActSkuPicPO();
        selectActSkuPicPO.setPicId(actSkuPicReqBO.getPicId());
        List<ActSkuPicPO> actSkuPicList = this.actSkuPicMapper.selectByCondition(selectActSkuPicPO);
        if (actSkuPicList.size() == 1) {
            ActSkuPicPO deleteActSkuPicPO = new ActSkuPicPO();
            BeanUtils.copyProperties(actSkuPicReqBO, deleteActSkuPicPO);

            int num = this.actSkuPicMapper.delete(deleteActSkuPicPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuPicList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

}
