package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActFscOrderPO
 * @Description: ActFscOrderPO
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActFscOrderPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 结算单ID
	 */
    private Long fscOrderId;
	/**
	 * 结算单来源
	 */
    private Integer orderSource;
	/**
	 * 开票方类型：1、电商
	 */
    private Integer makeType;
	/**
	 * 收票方类型：1、采购商 2、运营方
	 */
    private Integer receiveType;
	/**
	 * 结算单编号
	 */
    private String orderNo;
	/**
	 * 总金额
	 */
    private BigDecimal totalCharge;
	/**
	 * 结算单状态
	 */
    private Integer orderState;
	/**
	 * 供应商ID
	 */
    private Long supplierId;
	/**
	 * 供应商名称
	 */
    private String supplierName;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人用户ID
	 */
    private Long createUserId;
	/**
	 * 创建人用户名称
	 */
    private String createOperName;
	/**
	 * 创建人机构ID
	 */
    private Long createOrgId;
	/**
	 * 创建人机构名称
	 */
    private String createOrgName;
	/**
	 * 创建人公司ID
	 */
    private Long createCompanyId;
	/**
	 * 创建人公司名称
	 */
    private String createCompanyName;
	/**
	 * 创建人机构树路径
	 */
    private String createOrgPath;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 更新工号
	 */
    private Long updateUserId;
	/**
	 * 更新工号名称
	 */
    private String updateUserName;
	/**
	 * 取消时间
	 */
    private Date cancelTime;
	/**
	 * 取消用户ID
	 */
    private Long cancelUserId;
	/**
	 * 取消用户名称
	 */
    private String cancelUserName;
	/**
	 * 取消原因
	 */
    private String cancelReason;
	/**
	 * 结算单说明，如有驳回原因记录
	 */
    private String orderDesc;
	/**
	 * 付款方ID
	 */
    private Long payerId;
	/**
	 * 付款方名称
	 */
    private String payerName;
	/**
	 * 付款时间
	 */
    private Date payTime;
	/**
	 * 付款人ID
	 */
	private Long payUserId;
	/**
	 * 付款人名称
	 */
	private String payUserName;
	/**
	 * 收款方ID
	 */
    private Long payeeId;
	/**
	 * 收款方名称
	 */
    private String payeeName;
	/**
	 * 生成方式 0手动 1自动
	 */
    private Integer buildAction;
	/**
	 * 最后付款日期
	 */
    private Date lastPayTime;
	/**
	 * 最后付款日期(运营)
	 */
    private Date yyLastPayTime;
	/**
	 * 活动ID
	 */
    private Long activityId;
	/**
	 * 外部活动ID
	 */
	private String extActivityId;
	/**
	 * 活动编号
	 */
    private String activityCode;
	/**
	 * 活动名称
	 */
    private String activityName;
	/**
	 * 签收时间
	 */
    private Date signTime;
	/**
	 * 签收人
	 */
    private Long signOperId;
	/**
	 * 签收人名称
	 */
    private String signOperName;
	/**
	 * 开票时间
	 */
    private Date billTime;
	/**
	 * 快递公司
	 */
    private String logisticsCompany;
	/**
	 * 快递单号
	 */
    private String logisticsOrder;
	/**
	 * 扩展字段1
	 */
    private String extField1;
	/**
	 * 扩展字段2
	 */
    private String extField2;
	/**
	 * 扩展字段3
	 */
    private String extField3;
	/**
	 * 创建开始时间
	 */
	private Date createTimeStartTime;
	/**
	 * 创建结束时间
	 */
	private Date createTimeEndTime;
	/**
	 * 开票开始时间
	 */
	private Date billStartTime;
	/**
	 * 开票结束时间
	 */
	private Date billEndTime;
	/**
	 * 签收开始时间
	 */
	private Date signStartTime;
	/**
	 * 签收结束时间
	 */
	private Date signEndTime;
	/**
	 * 最后付款时间开始时间
	 */
	private Date lastPayStartTime;
	/**
	 * 最后付款时间结束时间
	 */
	private Date lastPayEndTime;
	/**
	 * 运营最后付款时间 开始时间
	 */
	private Date yyLastPayStartTime;
	/**
	 * 运营最后付款时间 结束时间
	 */
	private Date yyLastPayEndTime;
	/**
	 * 预警类型
	 */
	private Integer alertType;
	/**
	 * 运营方机构ID
	 */
	private Long proId;
	/**
	 * 运营方机构名称
	 */
	private String proName;
	/**
	 * 活动组织范围名称
	 */
	private String activityScopeOrgName;
	/**
	 * 结算单ID
	 */
	private List<Long> fscOrderIds;
	/**
	 * 天数
	 */
	private Integer dayNum;
	/**
	 * 最后付款时间（跟当前时间做比较）
	 */
	private Date lastPayTimeEqu;
	/**
	 * 是否清空异常描述：1 清空
	 */
	private String ifClearDesc;
	/**
	 * 确认付款时间 开始时间
	 */
	private Date payTimeStartTime;
	/**
	 * 确认付款时间 结束时间
	 */
	private Date payTimeEndTime;
}