package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName ActOfflineInvoiceTaskPO
 * @Author 14051
 * @Date 2024/8/10 14:35
 * @Version 1.0
 **/
@Data
public class ActOfflineInvoiceTaskPO implements Serializable {
    private static final long serialVersionUID = -2097487586136644332L;
    /**
     * 任务ID
     */
    private Long taskId;
    /**
     * 结算单ID
     */
    private Long fscOrderId;
    /**
     * 供应商ID
     */
    private Long supplierId;
    /**
     * 状态：0未处理，1处理中，2已处理
     */
    private Integer status;
    /**
     * 处理结果：0成功，1失败，已处理状态时更新
     */
    private Integer dealResult;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 操作人
     */
    private Long operId;
    /**
     * 操作人名称
     */
    private String operName;
    /**
     * 操作人机构ID
     */
    private Long operOrgId;
    /**
     * 操作人机构名称
     */
    private String operOrgName;
    /**
     * 操作人公司ID
     */
    private Long operCompanyId;
    /**
     * 操作人公司名称
     */
    private String operCompanyName;
    /**
     * 操作人机构路径
     */
    private String operOrgPath;
    /**
     * 发票类型
     */
    private String invoiceType;
    /**
     * 发票号码集合
     */
    private List<String> invoiceNoList;
    /**
     * 发票状态集合
     */
    private List<Integer> statusList;
}
