package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActOrderInfoPO
 * @Description: ActOrderInfoPO
 * @author: liaoyang
 * @date: 2024年04月02日10:25:15
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActOrderInfoPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
    private Long id;
	/**
	 * 订单ID
	 */
    private String orderId;
	/**
	 * 父订单ID
	 */
    private String parentId;
	/**
	 * 订单类型：1电商，2协议
	 */
    private Integer orderType;
	/**
	 * 支付方式 (1 仅积分支付，2混合支付)
	 */
    private Integer payType;
	/**
	 * 订单来源：1京东，2苏宁
	 */
    private Integer orderSource;
	/**
	 * 订单状态
	 */
    private Integer orderState;
	/**
	 * 订单金额
	 */
    private BigDecimal orderMoney;
	/**
	 * 运费
	 */
    private BigDecimal freightMoney;
	/**
	 * 订单积分支付金额
	 */
    private BigDecimal orderScore;
	/**
	 * 个人支付金额
	 */
    private BigDecimal personMoney;
	/**
	 * 订单创建时间
	 */
    private Date createTime;
	/**
	 * 订单发货时间
	 */
    private Date sendTime;
	/**
	 * 订单到货时间
	 */
    private Date arriveTime;
	/**
	 * 订单完成时间
	 */
    private Date finishTime;
	/**
	 * 下单人ID
	 */
    private Long createUserId;
	/**
	 * 下单人名称
	 */
    private String createUserName;
	/**
	 * 下单人机构ID
	 */
    private Long createOrgId;
	/**
	 * 下单人机构名称
	 */
    private String createOrgName;
	/**
	 * 下单人公司ID
	 */
    private Long createCompanyId;
	/**
	 * 下单人公司名称
	 */
    private String createCompanyName;
	/**
	 * 接收订单时间
	 */
    private Date receiveTime;
	/**
	 * 1父订单，2 子订单（含无拆单）
	 */
    private Integer parentFlag;
	/**
	 * 订单备注
	 */
    private String remark;
	/**
	 * 结算状态：0未提交，1已提交，2开票中，3已开票，4已签收，5已付款
	 */
    private Integer settleState;
	/**
	 * 活动ID
	 */
    private Long activityId;
	/**
	 * 下单人账号
	 */
    private String createUserAccount;
	/**
	 * 下单人机构树路径
	 */
    private String createOrgPath;
	/**
	 * 订单取消时间
	 */
    private Date cancelTime;
	/**
	 * 订单编号
	 */
    private String orderNo;
	/**
	 * 详情跳转链接
	 */
    private String detailUrl;
	/**
	 * 扩展字段1
	 */
    private String extField1;
	/**
	 * 扩展字段2
	 */
    private String extField2;
	/**
	 * 扩展字段3
	 */
    private String extField3;
	/**
	 * 扩展字段4
	 */
    private String extField4;
	/**
	 * 扩展字段5
	 */
    private String extField5;
	/**
	 * 预警天数
	 */
	private Integer dayNum;
	/**
	 * 订单ID集合
	 */
	private List<String> orderIds;

	private Integer alertType;

	private Integer total;

	/**
	 * 活动名称
	 */
	private String activityName;
	/**
	 * 外部活动ID
	 */
	private String extActivityId;
	/**
	 * 外部状态
	 */
	private Integer otherOrderState;
	/**
	 * 更新时间
	 */
	private Date updateTime;
}