package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName: ActOrderItemInfoPO
 * @Description: ActOrderItemInfoPO
 * @author: liaoyang
 * @date: 2024年04月02日10:25:15
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActOrderItemInfoPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 订单明细ID
	 */
    private Long ordItemId;
	/**
	 * 订单ID
	 */
    private Long orderId;
	/**
	 * 商品ID
	 */
    private String skuId;
	/**
	 * 商品编码
	 */
    private String skuCode;
	/**
	 * 商品名称
	 */
    private String skuName;
	/**
	 * 商品图片
	 */
    private String skuPicUrl;
	/**
	 * 商品类别
	 */
    private Integer skuType;
	/**
	 * 数量
	 */
    private BigDecimal num;
	/**
	 * 单价
	 */
    private BigDecimal price;
	/**
	 * 商品行总价
	 */
    private BigDecimal totalAmt;
	/**
	 * 积分支付金额
	 */
    private BigDecimal skuScore;
	/**
	 * 个人支付金额
	 */
    private BigDecimal personMoney;
	/**
	 * 规格
	 */
    private String spec;
	/**
	 * 型号
	 */
    private String model;
	/**
	 * 税率
	 */
    private BigDecimal taxRate;
	/**
	 * 税收分类编码
	 */
    private String taxCode;
	/**
	 * 扩展字段1
	 */
    private String extField1;
	/**
	 * 扩展字段2
	 */
    private String extField2;
	/**
	 * 扩展字段5
	 */
    private String extField5;
	/**
	 * 扩展字段4
	 */
    private String extField4;
	/**
	 * 扩展字段3
	 */
    private String extField3;

}