package com.tydic.dyc.act.repository.po;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 标题：ActPerformanceRiskControlPo
 * 说明：履约风控 po
 * 时间：2024/5/7
 *
 * @author zhoujie
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ActPerformanceRiskControlPo extends BaseReqBo {
    private static final long serialVersionUID = -3298932742837108070L;
    /**
     * 单位id（取查询人所在的companyId）
     */
    private Long companyIdWeb;
    /**
     * 指定日期开始
     */
    private Date qryDateStart;
    /**
     * 指定日期结束
     */
    private Date qryDateEnd;


    /**
     * 预警类型：1超期未发货、2超期未收货、3超期未响应、4超期未签收、5超期未付款、6付款预警(活动)
     */
    private Integer alertType;

    /**
     * 预警条数
     */
    private Integer alertCount;

    /**
     * 活动同步状态:
     * 1:待同步
     * 2：同步中
     * 3：同步成功
     * 4：同步失败
     */
    private Integer activitySyncState;
}
