package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActSkuInfoPO
 * @Description: ActSkuInfoPO
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActSkuInfoExtPO extends ActSkuInfoPO {

	private static final long serialVersionUID = 1L;

	/**
	 * 单品id
	 */
    private Long skuId;
	/**
	 * 单品名称
	 */
    private String skuName;
	/**
	 * 外部单品id
	 */
    private String extSkuId;

	private List<String> extSkuIdList;
	/**
	 * 单品编号
	 */
    private String skuCode;
	/**
	 * 京东C端链接
	 */
    private String jdSkuUrl;
	/**
	 * 单品状态：1：已上架 2：已下架 0 ：已删除
	 */
    private Integer skuStatus;
	/**
	 * 三级类目id
	 */
    private Long guideId;
	/**
	 * 商品池
	 */
	private String skuPools;
	/**
	 * 品牌名称
	 */
    private String brandName;
	/**
	 * 来源电商id
	 */
    private Long supplierId;
	/**
	 * 来源电商id集合
	 */
	private List<Long> supplierIdList;
	/**
	 * 来源电商名称
	 */
    private String supplierName;
	/**
	 * 来源电商编码
	 */
	private String supplierCode;
	/**
	 * 市场价
	 */
    private BigDecimal marketPrice;
	/**
	 * 协议价
	 */
    private BigDecimal agreementPrice;
	/**
	 * 折扣率
	 */
    private BigDecimal discount;
	/**
	 * 最小起订量
	 */
    private Integer moq;
	/**
	 * 销售单位
	 */
    private String measureName;
	/**
	 * 好评率
	 */
    private BigDecimal goodRate;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人ID
	 */
    private Long createUserId;
	/**
	 * 创建人名称
	 */
    private String createUserName;
	/**
	 * 更新人ID
	 */
    private Long updateUserId;
	/**
	 * 更新人名称
	 */
    private String updateUserName;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 单品状态：1：已上架 2：已下架 0 ：已删除
	 */
	private List<Integer> skuStatusList;
	/**
	 * 协议价最小值
	 */
	private BigDecimal agreementPriceMin;
	/**
	 * 协议价最大值
	 */
	private BigDecimal agreementPriceMax;
	/**
	 * 市场价最小值
	 */
	private BigDecimal marketPriceMin;
	/**
	 * 市场价最大值
	 */
	private BigDecimal marketPriceMax;
	/**
	 * 折扣率最小值
	 */
	private BigDecimal discountMin;
	/**
	 * 折扣率最大值
	 */
	private BigDecimal discountMax;
	/**
	 * 商品池ID
	 */
	private Long poolId;
	/**
	 * 排除商品池ID
	 */
	private Long exitsPoolId;
	/**
	 * 单品ID集合
	 */
	private List<Long> skuIds;
	/**
	 * 类目ID集合
	 */
	private List<Long> guideIdList;
	/**
	 * 三级类目名称
	 */
	private String catalogName3;
	/**
	 * 二级类目名称
	 */
	private String catalogName2;
	/**
	 * 一级类目名称
	 */
	private String catalogName1;

	/**
	 * 二级类目id
	 */
	private Long catalogId2;
	/**
	 * 三级类目id
	 */
	private Long catalogId3;

	/**
	 * 一级类目id
	 */
	private Long catalogId1;

	/**
	 * 一级类目状态
	 */
	private Integer catalogId1Status;

	/**
	 * 二级类目状态
	 */
	private Integer catalogId2Status;

	/**
	 * 三级类目状态
	 */
	private Integer catalogId3Status;
	/**
	 * 图片URL
	 */
	private String picUrl;
	/**
	 * 商品详情
	 */
	private String skuPcDetailUrl;
	/**
	 * 排除单品ID集合
	 */
	private List<Long> exitsSkuIds;
	/**
	 * 活动类目集合
	 */
	private List<Long> activityGuideIdList;
	/**
	 * 排除商品类目集合
	 */
	private List<Long> exitsGuideIdList;
	/**
	 * 排除供应商集合
	 */
	private List<Long> exitsSupplierIdList;
	/**
	 * 商品类目集合
	 */
	private List<Long> poolGuideIdList;
	/**
	 * 排除商品类目集合
	 */
	private List<Long> exitsPoolGuideIdList;
	/**
	 * 供应商集合
	 */
	private List<Long> poolSupplierIdList;
	/**
	 * 排除供应商集合
	 */
	private List<Long> exitsPoolSupplierIdList;
	/**
	 * 是否查询停用类目商品
	 */
	private Boolean qryDisableCatalog;
	/**
	 * 是否查询已删除商品
	 */
	private Boolean qryNotDelFlag;

	/**
	 * 所属机构/供应商Id
	 */
	private Long belongOrgId;
	/**
	 * 所属机构/供应商名称
	 */
	private String belongOrgName;

	/**
	 * 一级类目id（商品审核必传）
	 */
	private String firstCatalogId;
	/**
	 * 一级类目名称（商品审核必传）
	 */
	private String firstCatalogName;
	/**
	 * 二级类目id（商品审核必传）
	 */
	private String secondCatalogId;
	/**
	 * 二级类目名称（商品审核必传）
	 */
	private String secondCatalogName;
	/**
	 * 三级类目id（商品审核必传）
	 */
	private String threeCatalogId;
	/**
	 * 三级类目名称（商品审核必传）
	 */
	private String threeCatalogName;
	/**
	 * 图文是否异常：0异常1正常
	 */
	private Integer  isAnomalousPic;
	/**
	 * 价格是否异常：0异常1正常
	 */
	private Integer  isAnomalousPrice;
	/**
	 * 外部商品编码
	 */
	private String extSkuCode;
	/**
	 * 商品69码
	 */
	private List<String> upcList;
	private String sortName;
	private String sortOrder;
}