package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：AgrItemPriceExecutionBo
 * 说明：协议明细价格执行列表
 * 时间：2024/7/11 15:33
 *
 * @author 周钰焱
 */
@Data
public class AgrItemPriceExecutionBo implements Serializable {
    private static final long serialVersionUID = -3450616811081659097L;

    /**
     * 价格执行记录表
     */
    private Long id;
    /**
     * 协议明细ID
     */
    private Long agrItemId;
    /**
     * 执行开始时间
     */
    private Date executionEffDate;
    private Date executionEffDateStart;
    private Date executionEffDateEnd;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 净单价
     */
    private BigDecimal netUnitPrice;
    /**
     * 含税单价
     */
    private BigDecimal taxPrice;
    /**
     * 审核状态
     */
    private Integer auditStatus;
    /**
     * 排序
     */
    private String orderBy;
}
