package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题：AgrAlertListReqBo
 * 说明：
 * 时间： 2024-08-12 16:45
 * 作者 @author LY
 */
@Data
public class AgrAlertListReqBo implements Serializable {
    private static final long serialVersionUID = 4798202196149082242L;
    /**
     * 主键ID
     */
    private Long id;
    /**
     * 单据ID
     */
    private String objId;
    /**
     * 类型：1订单、2服务单、3结算单、4活动
     */
    private Integer objType;
    /**
     * 预警类型：1超期未发货、2超期未收货、3超期未响应、4超期未签收、5超期未付款、6付款预警(活动)
     */
    private Integer alertType;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 预警状态：0未处理，1已处理，2待处理(中间状态)
     */
    private Integer alertState;
    /**
     * 更新时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 单据创建人
     */
    private Long createUserId;
    /**
     * 单据创建人名称
     */
    private String createUserName;
    /**
     * 单据创建人机构ID
     */
    private Long createOrgId;
    /**
     * 单据创建人机构名称
     */
    private String createOrgName;
    /**
     * 单据创建人公司ID
     */
    private Long createCompanyId;
    /**
     * 单据创建人公司名称
     */
    private String createCompanyName;
    /**
     * 单据创建人机构树
     */
    private String createOrgPath;
    /**
     * 是否发送：0 否 1是
     */
    private Integer isSend;
    /**
     * 排序
     */
    private String orderBy;
}
