/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.model.sysDicDictionary.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.AgrDictionaryRspBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.SysDicDictionaryRspBo;
import com.tydic.dyc.agr.repository.AgrDictionaryRepository;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IAgrDictionaryModelImpl
implements IAgrDictionaryModel {
    @Autowired
    private AgrDictionaryRepository agrDictionaryRepository;

    @Override
    public List<DicDictionaryBo> selectByPCodeList(List<String> pCodeList) {
        return this.agrDictionaryRepository.selectByPCodeList(pCodeList);
    }

    @Override
    public Map<String, Map<String, DicDictionaryBo>> selectByPCodeListToMap(List<String> pCodeList) {
        List<DicDictionaryBo> dicDictionaryBoList = this.selectByPCodeList(pCodeList);
        if (CollectionUtil.isEmpty(dicDictionaryBoList)) {
            return new HashMap<String, Map<String, DicDictionaryBo>>(16);
        }
        return dicDictionaryBoList.stream().collect(Collectors.groupingBy(DicDictionaryBo::getPCode, Collectors.toMap(DicDictionaryBo::getCode, Function.identity(), (a, b) -> a)));
    }

    @Override
    public SysDicDictionaryDo getDictionaryByDo(SysDicDictionaryDo dicDictionaryDo) {
        return this.agrDictionaryRepository.getDictionaryByDo(dicDictionaryDo);
    }

    @Override
    public void addDicDictionary(SysDicDictionaryDo sysDicDictionaryDo) {
        this.agrDictionaryRepository.addDicDictionary(sysDicDictionaryDo);
    }

    @Override
    public void deleteDicDictionary(SysDicDictionaryDo dicDictionaryBO) {
        this.agrDictionaryRepository.deleteDicDictionary(dicDictionaryBO);
    }

    @Override
    public AgrDictionaryRspBo queryBypCodeBackMap(SysDicDictionaryDo sysDicDictionaryDo) {
        return this.agrDictionaryRepository.queryBypCodeBackMap(sysDicDictionaryDo);
    }

    @Override
    public SysDicDictionaryRspBo queryBypCodeBackPo(SysDicDictionaryDo dicDictionaryDo) {
        if (StringUtils.isEmpty((Object)dicDictionaryDo.getPCode())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2Pcode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.agrDictionaryRepository.queryBypCodeBackPo(dicDictionaryDo);
    }

    @Override
    public void updateDicDictionary(SysDicDictionaryDo dicDictionaryBO) {
        this.agrDictionaryRepository.updateDicDictionary(dicDictionaryBO);
    }
}

