/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.AgrCheckAgrAppScopeService;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckScopeBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrCheckAgrAppScopeService"})
public class AgrCheckAgrAppScopeServiceImpl
implements AgrCheckAgrAppScopeService {
    private static final Logger log = LoggerFactory.getLogger(AgrCheckAgrAppScopeServiceImpl.class);
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"checkAgrAppScope"})
    public AgrCheckAgrAppScopeRspBO checkAgrAppScope(@RequestBody AgrCheckAgrAppScopeReqBO reqBO) {
        this.validParam(reqBO);
        ArrayList<Object> agrCheckScopeBOS = new ArrayList<AgrCheckScopeBO>();
        ArrayList<String> scopeCodes = new ArrayList();
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrgTreePathIn())) {
            scopeCodes = Arrays.asList(reqBO.getOrgTreePathIn().split("-"));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrIds())) {
            this.checkAgrScope(reqBO, agrCheckScopeBOS, scopeCodes);
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrItemIds())) {
            agrCheckScopeBOS = new ArrayList();
            this.checkAgrItemScope(reqBO, agrCheckScopeBOS, scopeCodes);
        }
        AgrCheckAgrAppScopeRspBO rspBO = new AgrCheckAgrAppScopeRspBO();
        rspBO.setRows(agrCheckScopeBOS);
        return rspBO;
    }

    private void checkAgrScope(AgrCheckAgrAppScopeReqBO reqBO, List<AgrCheckScopeBO> agrCheckScopeBOS, List<String> scopeCodes) {
        Map<Object, Object> agrMap = new HashMap();
        AgrAgrQryBo qryAgrMainList = new AgrAgrQryBo();
        qryAgrMainList.setAgrIds(reqBO.getAgrIds());
        qryAgrMainList.setPageNo(-1);
        qryAgrMainList.setPageSize(-1);
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = this.iAgrAgrModel.getAgrMainList(qryAgrMainList);
        if (!CollectionUtils.isEmpty(agrGetAgrMainListRspQryBo.getRows())) {
            agrMap = agrGetAgrMainListRspQryBo.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, AgrAgrDo::getAgrName));
        }
        List<Object> otherAgrIds = new ArrayList();
        List<Object> lastAgrIds = new ArrayList();
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrIds(reqBO.getAgrIds());
        agrAgrQryBo.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            agrAppScopes.forEach(bo -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(bo.getAgrId());
                agrCheckScopeBO.setCheckFlag(Boolean.valueOf(true));
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });
            otherAgrIds = reqBO.getAgrIds().stream().filter(agrId -> agrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId))).collect(Collectors.toList());
        } else {
            otherAgrIds = reqBO.getAgrIds();
        }
        if (!CollectionUtils.isEmpty(otherAgrIds)) {
            agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(otherAgrIds);
            agrAgrQryBo.setScopeCodes(scopeCodes);
            agrAgrQryBo.setAgrType(AgrCommConstant.AgrType.SELF_AGR);
            List<AgrAppScope> otherAgrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
            if (!CollectionUtils.isEmpty(otherAgrAppScopes)) {
                otherAgrAppScopes.forEach(bo -> {
                    AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                    agrCheckScopeBO.setAgrId(bo.getAgrId());
                    agrCheckScopeBO.setCheckFlag(Boolean.valueOf(true));
                    agrCheckScopeBOS.add(agrCheckScopeBO);
                });
                lastAgrIds = otherAgrIds.stream().filter(agrId -> otherAgrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId))).collect(Collectors.toList());
            } else {
                lastAgrIds = otherAgrIds;
            }
        }
        if (!CollectionUtils.isEmpty(lastAgrIds)) {
            lastAgrIds.forEach(agrId -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(agrId);
                agrCheckScopeBO.setCheckFlag(Boolean.valueOf(false));
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });
        }
        for (AgrCheckScopeBO bo2 : agrCheckScopeBOS) {
            if (agrMap == null || !agrMap.containsKey(bo2.getAgrId())) continue;
            bo2.setAgrName((String)agrMap.get(bo2.getAgrId()));
        }
    }

    private void checkAgrItemScope(AgrCheckAgrAppScopeReqBO reqBO, List<AgrCheckScopeBO> agrCheckScopeBOS, List<String> scopeCodes) {
        ArrayList tempAgrCheckScopeBOS = new ArrayList();
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrItemIds(reqBO.getAgrItemIds());
        agrItemListQryReqPageBo.setPageNo(-1);
        agrItemListQryReqPageBo.setPageSize(-1);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);
        Map<Object, Object> agrMap = new HashMap();
        if (!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())) {
            List<Long> agrIds = agrItemListQryRspPageBo.getRows().stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
            AgrAgrQryBo qryAgrMainList = new AgrAgrQryBo();
            qryAgrMainList.setAgrIds(agrIds);
            qryAgrMainList.setPageNo(-1);
            qryAgrMainList.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = this.iAgrAgrModel.getAgrMainList(qryAgrMainList);
            if (!CollectionUtils.isEmpty(agrGetAgrMainListRspQryBo.getRows())) {
                agrMap = agrGetAgrMainListRspQryBo.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, AgrAgrDo::getAgrName));
            }
        }
        List<Object> otherAgrItemIds = new ArrayList();
        List<Object> lastAgrItemIds = new ArrayList();
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrItemIds(reqBO.getAgrItemIds());
        agrAgrQryBo.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            agrAppScopes.forEach(bo -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(bo.getAgrId());
                agrCheckScopeBO.setAgrItemId(bo.getAgrItemId());
                agrCheckScopeBO.setCheckFlag(Boolean.valueOf(true));
                tempAgrCheckScopeBOS.add(agrCheckScopeBO);
            });
            otherAgrItemIds = reqBO.getAgrItemIds().stream().filter(agrItemId -> agrAppScopes.stream().noneMatch(a -> a.getAgrItemId().equals(agrItemId))).collect(Collectors.toList());
        } else {
            otherAgrItemIds = reqBO.getAgrItemIds();
        }
        if (!CollectionUtils.isEmpty(otherAgrItemIds)) {
            AgrAgrQryBo agrAgrQryBo1 = new AgrAgrQryBo();
            agrAgrQryBo1.setAgrItemIds(reqBO.getAgrItemIds());
            agrAgrQryBo1.setScopeCodes(scopeCodes);
            agrAgrQryBo.setAgrType(AgrCommConstant.AgrType.AGR);
            List<AgrAppScope> otherAgrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo1);
            if (!CollectionUtils.isEmpty(otherAgrAppScopes)) {
                otherAgrAppScopes.forEach(bo -> {
                    AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                    agrCheckScopeBO.setAgrId(bo.getAgrId());
                    agrCheckScopeBO.setAgrItemId(bo.getAgrItemId());
                    agrCheckScopeBO.setCheckFlag(Boolean.valueOf(true));
                    tempAgrCheckScopeBOS.add(agrCheckScopeBO);
                });
                lastAgrItemIds = reqBO.getAgrItemIds().stream().filter(agrItemId -> otherAgrAppScopes.stream().noneMatch(a -> a.getAgrItemId().equals(agrItemId))).collect(Collectors.toList());
            } else {
                lastAgrItemIds = reqBO.getAgrItemIds();
            }
        }
        if (!CollectionUtils.isEmpty(lastAgrItemIds)) {
            lastAgrItemIds.forEach(agrItemId -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrItemId(agrItemId);
                agrCheckScopeBO.setCheckFlag(Boolean.valueOf(false));
                tempAgrCheckScopeBOS.add(agrCheckScopeBO);
            });
        }
        for (AgrCheckScopeBO bo2 : agrCheckScopeBOS) {
            if (agrMap == null || !agrMap.containsKey(bo2.getAgrId())) continue;
            bo2.setAgrName((String)agrMap.get(bo2.getAgrId()));
        }
        log.debug("tempAgrCheckScopeBOS:" + JSON.toJSONString(tempAgrCheckScopeBOS));
        HashSet<Long> seenAgrItemIds = new HashSet<Long>();
        for (AgrCheckScopeBO agrCheckScopeBO : tempAgrCheckScopeBOS) {
            if (seenAgrItemIds.contains(agrCheckScopeBO.getAgrItemId())) continue;
            seenAgrItemIds.add(agrCheckScopeBO.getAgrItemId());
            agrCheckScopeBOS.add(agrCheckScopeBO);
        }
        log.debug("agrCheckScopeBOS:" + JSON.toJSONString(agrCheckScopeBOS));
    }

    private void validParam(AgrCheckAgrAppScopeReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("22000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrIds()) && CollectionUtils.isEmpty((Collection)reqBO.getAgrItemIds())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u534f\u8baeID\u96c6\u5408\u548c\u534f\u8bae\u660e\u7ec6ID\u96c6\u5408\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgTreePathIn())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5355\u4f4d\u6811\u8def\u5f84\u9519\u8bef");
        }
    }
}

