/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agr.sub.AgrRel;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService;
import com.tydic.dyc.agr.service.agr.bo.AgrAccessoryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCataScopeBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainExtBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainExtendBo;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrRelBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService"})
public class AgrGetAgrDetailServiceImpl
implements AgrGetAgrDetailService {
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @PostMapping(value={"getAgrDetail"})
    public AgrGetAgrDetailRspBo getAgrDetail(@RequestBody AgrGetAgrDetailReqBo agrGetAgrDetailReqBo) {
        this.validationParam(agrGetAgrDetailReqBo);
        AgrAgrQryBo agrAgrQryBo = AgrRu.js(agrGetAgrDetailReqBo, AgrAgrQryBo.class);
        AgrAgrDo agrDetail = this.agrAgrModel.getAgrDetail(agrAgrQryBo);
        AgrGetAgrDetailRspBo rspBo = this.setRspBoInfo(agrDetail);
        if (agrDetail != null) {
            rspBo.setProcInstId(this.qryProInstId(agrDetail));
            rspBo.setTaskInstId(this.qryTaskInstId(rspBo.getProcInstId(), agrGetAgrDetailReqBo.getUserId()));
            rspBo.setBusiProclnstld(this.qryBusiProInstId(agrDetail));
            this.getParentAgrCode(rspBo);
            AgrMainExtendBo agrMainExtendBo = AgrRu.js(agrDetail, AgrMainExtendBo.class);
            rspBo.getAgrMainSaveBO().setAgrMainExtendBo(agrMainExtendBo);
        }
        if (null != rspBo && null != rspBo.getAgrMainSaveBO() && !CollectionUtils.isEmpty((Collection)rspBo.getAgrMainSaveBO().getAgrMainExtBOs())) {
            StringBuilder agrOperatorName = new StringBuilder();
            rspBo.getAgrMainSaveBO().getAgrMainExtBOs().forEach(agrMainExtBO -> {
                if (agrMainExtBO.getFieldCode().equals("agrOperatorName")) {
                    if (StrUtil.isBlank((CharSequence)agrOperatorName)) {
                        agrOperatorName.append(agrMainExtBO.getFieldValue());
                    } else {
                        agrOperatorName.append(",").append(agrMainExtBO.getFieldValue());
                    }
                }
            });
            rspBo.getAgrMainSaveBO().setAgrOperatorName(agrOperatorName.toString());
        }
        return rspBo;
    }

    private String qryBusiProInstId(AgrAgrDo agrDetail) {
        String procInstId = "";
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setOrderId(agrDetail.getAgrId());
        agrProcInstDo.setObjId(agrDetail.getAgrId());
        agrProcInstDo.setObjType(AgrCommConstant.ObjType.AGREEMENT);
        agrProcInstDo.setOrderBy("id desc LIMIT 1");
        AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
        if (agrProcInstDo1 != null) {
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }

    private void validationParam(AgrGetAgrDetailReqBo agrGetAgrDetailReqBo) {
        if (agrGetAgrDetailReqBo.getAgrId() == null && StringUtils.isEmpty((Object)agrGetAgrDetailReqBo.getAgrCode())) {
            throw new BaseBusinessException("AGR00002", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrId]\u548c\u534f\u8bae\u7f16\u53f7[agrCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private void getParentAgrCode(AgrGetAgrDetailRspBo rspBo) {
        if (rspBo != null && rspBo.getAgrMainSaveBO() != null && rspBo.getAgrMainSaveBO().getParentAgrId() != null) {
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrId(rspBo.getAgrMainSaveBO().getParentAgrId());
            AgrAgrDo agrAgrDo = this.agrAgrModel.getAgrMain(agrAgrQryBo);
            if (agrAgrDo != null) {
                rspBo.getAgrMainSaveBO().setParentAgrCode(agrAgrDo.getAgrCode());
                rspBo.setAgrMainParentBO(AgrRu.js(agrAgrDo, AgrMainDetailBo.class));
            }
        }
    }

    private String qryProInstId(AgrAgrDo agrDetail) {
        String procInstId = "";
        AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
        agrAuditOrderQryBo.setObjType(AgrCommConstant.ObjType.AGREEMENT);
        agrAuditOrderQryBo.setOrderId(agrDetail.getAgrId());
        agrAuditOrderQryBo.setOrderBy("id desc");
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        if (!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())) {
            Long auditOrderId = agrAuditOrderDo.getUocApprovalObj().get(0).getAuditOrderId();
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setOrderId(agrDetail.getAgrId());
            agrProcInstDo.setObjId(auditOrderId);
            agrProcInstDo.setObjType(AgrCommConstant.ObjType.APPROVE);
            agrProcInstDo.setOrderBy("create_time desc limit 1");
            AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
            if (agrProcInstDo1 != null) {
                procInstId = agrProcInstDo1.getProcInstId();
            }
        }
        return procInstId;
    }

    private String qryTaskInstId(String procInstId, Long userId) {
        String taskInstId = "";
        if (!ObjectUtil.isEmpty((Object)procInstId) && !ObjectUtil.isEmpty((Object)userId)) {
            AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
            agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
            agrTaskQryBo.setProcInstId(procInstId);
            agrTaskQryBo.setDealOperId(userId);
            UocOrderTaskInst uocOrderTaskInst = this.iAgrProcInstModel.getTaskIdWithDealUser(agrTaskQryBo);
            if (uocOrderTaskInst != null) {
                taskInstId = uocOrderTaskInst.getTaskInstId();
            }
        }
        return taskInstId;
    }

    public AgrGetAgrDetailRspBo setRspBoInfo(AgrAgrDo agrDetail) {
        AgrGetAgrDetailRspBo rspBo = new AgrGetAgrDetailRspBo();
        if (agrDetail != null) {
            AgrMainDetailBo agrMainBO = AgrRu.js(agrDetail, AgrMainDetailBo.class);
            AgrMainDetailBo agrMain = this.agrMainTransferredMeaning(agrMainBO);
            rspBo.setAgrMainSaveBO(agrMain);
            rspBo.setAgrAppScopeBOs(AgrRu.jsl(agrDetail.getAgrAppScope(), AgrAppScopeBo.class));
            rspBo.setAgrAccessoryBOs(AgrRu.jsl(agrDetail.getAgrAccessory(), AgrAccessoryBo.class));
            rspBo.setAgrCataScopeBOs(AgrRu.jsl(agrDetail.getAgrCataScope(), AgrCataScopeBo.class));
            List<AgrPayConfig> agrPayConfig = agrDetail.getAgrPayConfig();
            if (!agrPayConfig.isEmpty()) {
                ArrayList<String> pCodeList = new ArrayList<String>();
                for (AgrPayConfig item : agrPayConfig) {
                    AgrPayConfigDetailBo payConfigDetailBo = AgrRu.js(item, AgrPayConfigDetailBo.class);
                    if (ObjectUtil.isNotEmpty((Object)payConfigDetailBo.getAssign())) {
                        pCodeList.add("ASSIGN_PCODE");
                        if (item.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())) {
                            pCodeList.add("IS_ASSIGN");
                        } else if (item.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                            pCodeList.add("NO_ASSIGN_PCODE");
                        }
                    }
                    pCodeList.add("PAY_TYPE_PCODE");
                    if (AgrCommConstant.payObj.PAY_OBJ_PURCHASE.equals(item.getPayObj())) {
                        rspBo.getAgrMainSaveBO().setPayTypePur(payConfigDetailBo);
                        pCodeList.add("PAY_OBJ_PCODE");
                    }
                    if (AgrCommConstant.payObj.PAY_OBJ_SUPPLY.equals(item.getPayObj())) {
                        rspBo.getAgrMainSaveBO().setPayTypeSup(payConfigDetailBo);
                        pCodeList.add("PAY_OBJ_PCODE");
                    }
                    if (rspBo.getAgrMainSaveBO().getPayTypePur() == null) {
                        rspBo.getAgrMainSaveBO().setPayTypePur(new AgrPayConfigDetailBo());
                    }
                    if (rspBo.getAgrMainSaveBO().getPayTypeSup() != null) continue;
                    rspBo.getAgrMainSaveBO().setPayTypeSup(new AgrPayConfigDetailBo());
                }
                Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
                List<AgrPayConfigDetailBo> payConfigDetailBoList = ListUtil.list((boolean)false, (Object[])new AgrPayConfigDetailBo[]{rspBo.getAgrMainSaveBO().getPayTypePur(), rspBo.getAgrMainSaveBO().getPayTypeSup()}).stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (MapUtil.isNotEmpty(dicMap) && CollectionUtil.isNotEmpty(payConfigDetailBoList)) {
                    payConfigDetailBoList.forEach(e -> {
                        if (ObjectUtil.isNotEmpty((Object)e.getAssign())) {
                            e.setAssignStr(MapUtil.isEmpty((Map)((Map)dicMap.get("ASSIGN_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("ASSIGN_PCODE")).get(e.getAssign().toString())).getTitle());
                            if (e.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())) {
                                e.setBusiNodeStr(MapUtil.isEmpty((Map)((Map)dicMap.get("IS_ASSIGN"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("IS_ASSIGN")).get(e.getBusiNode().toString())).getTitle());
                            } else if (e.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                                e.setBusiNodeStr(MapUtil.isEmpty((Map)((Map)dicMap.get("NO_ASSIGN_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("NO_ASSIGN_PCODE")).get(e.getBusiNode().toString())).getTitle());
                            }
                        }
                        if (e.getPayType() != null) {
                            e.setPayTypeStr(MapUtil.isEmpty((Map)((Map)dicMap.get("PAY_TYPE_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("PAY_TYPE_PCODE")).get(e.getPayType().toString())).getTitle());
                        }
                        if (e.getPayObj() != null) {
                            e.setPayObjStr(MapUtil.isEmpty((Map)((Map)dicMap.get("PAY_OBJ_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("PAY_OBJ_PCODE")).get(e.getPayObj().toString())).getTitle());
                        }
                    });
                }
            } else {
                rspBo.getAgrMainSaveBO().setPayTypePur(new AgrPayConfigDetailBo());
                rspBo.getAgrMainSaveBO().setPayTypeSup(new AgrPayConfigDetailBo());
            }
            AgrAdjustCfg agrAdjustCfg = agrDetail.getAgrAdjustCfg();
            if (ObjectUtil.isNotEmpty((Object)agrAdjustCfg)) {
                rspBo.getAgrMainSaveBO().setWhetherAddPrice(agrAdjustCfg.getWhetherAddPrice());
                rspBo.getAgrMainSaveBO().setMarkupRate(agrAdjustCfg.getMarkupRate());
                rspBo.getAgrMainSaveBO().setWhetherAdjustPriceFormula(agrAdjustCfg.getWhetherAdjustPriceFormula());
                rspBo.getAgrMainSaveBO().setWhetherModifyBuyPrice(agrAdjustCfg.getWhetherModifyBuyPrice());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaId(agrAdjustCfg.getAdjustPriceFormulaId());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaName(agrAdjustCfg.getAdjustPriceFormulaName());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaValue(agrAdjustCfg.getAdjustPriceFormulaValue());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormula(agrAdjustCfg.getAdjustPriceFormula());
            }
            List<AgrRel> agrRel = agrDetail.getAgrRel();
            rspBo.setAgrRel(AgrRu.jsl(agrRel, AgrRelBo.class));
            List<AgrMainExt> agrMainExt = agrDetail.getAgrMainExtBOs();
            List<AgrMainExtBo> agrMainExtBos = AgrRu.jsl(agrMainExt, AgrMainExtBo.class);
            rspBo.getAgrMainSaveBO().setAgrMainExtBOs(agrMainExtBos);
        }
        return rspBo;
    }

    private AgrMainDetailBo agrMainTransferredMeaning(AgrMainDetailBo rspBo) {
        Map<String, Map<String, DicDictionaryBo>> dicMap;
        ArrayList<String> pCodeList = new ArrayList<String>();
        if (rspBo.getAgrMode() != null) {
            pCodeList.add("AGR_MODE_PCODE");
        }
        if (rspBo.getAgrType() != null) {
            pCodeList.add("AGR_TYPE_PCODE");
        }
        if (rspBo.getAgrStatus() != null) {
            pCodeList.add("AGREEMENT_STATUS_PCODE");
        }
        if (rspBo.getAgrPriceType() != null) {
            pCodeList.add("AGR_PRICE_TYPE_PCODE");
        }
        if (rspBo.getAgrSrc() != null) {
            pCodeList.add("AGREEMENT_SRC");
        }
        if (rspBo.getTradeMode() != null) {
            pCodeList.add("TRADE_MODE_PCODE");
        }
        if (rspBo.getWhetherDispatch() != null) {
            pCodeList.add("IS_DISPATCH_PCODE");
        }
        if (rspBo.getWhetherAssign() != null) {
            pCodeList.add("IS_ASSIGN_PCODE");
        }
        if (rspBo.getAgreementVariety() != null) {
            pCodeList.add("AGREEMENT_VARIETY_PCODE");
        }
        if (rspBo.getAgrLocation() != null) {
            pCodeList.add("AGR_LOCATION_PCODE");
        }
        if (rspBo.getWhetherStorePlan() != null) {
            pCodeList.add("IS_STORE_PLAN_PCODE");
        }
        if (rspBo.getScopeType() != null) {
            pCodeList.add("SCOPE_TYPE_PCODE");
        }
        if (rspBo.getAdjustPrice() != null) {
            pCodeList.add("ADJUST_PRICE_PCODE");
        }
        if (rspBo.getWhetherHaveItem() != null) {
            pCodeList.add("IS_HAVE_ITEM_PCODE");
        }
        if (rspBo.getVendorMode() != null) {
            pCodeList.add("SUPPLIER_MODE_PCODE");
        }
        if (rspBo.getAgrBusinessType() != null) {
            pCodeList.add("AGR_BUSINESS_TYPE");
        }
        if (MapUtil.isNotEmpty(dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList))) {
            rspBo.setAgrModeStr(MapUtil.isEmpty(dicMap.get("AGR_MODE_PCODE")) ? null : dicMap.get("AGR_MODE_PCODE").get(rspBo.getAgrMode().toString()).getTitle());
            rspBo.setAgrTypeStr(MapUtil.isEmpty(dicMap.get("AGR_TYPE_PCODE")) ? null : dicMap.get("AGR_TYPE_PCODE").get(rspBo.getAgrType().toString()).getTitle());
            rspBo.setAgrStatusStr(MapUtil.isEmpty(dicMap.get("AGREEMENT_STATUS_PCODE")) ? null : dicMap.get("AGREEMENT_STATUS_PCODE").get(rspBo.getAgrStatus().toString()).getTitle());
            rspBo.setAgrPriceTypeStr(MapUtil.isEmpty(dicMap.get("AGR_PRICE_TYPE_PCODE")) ? null : dicMap.get("AGR_PRICE_TYPE_PCODE").get(rspBo.getAgrPriceType().toString()).getTitle());
            rspBo.setAgrSrcStr(MapUtil.isEmpty(dicMap.get("AGREEMENT_SRC")) ? null : dicMap.get("AGREEMENT_SRC").get(rspBo.getAgrSrc().toString()).getTitle());
            rspBo.setAgrSrcName(MapUtil.isEmpty(dicMap.get("AGREEMENT_SRC")) ? null : dicMap.get("AGREEMENT_SRC").get(rspBo.getAgrSrc().toString()).getTitle());
            rspBo.setTradeModeStr(MapUtil.isEmpty(dicMap.get("TRADE_MODE_PCODE")) ? null : dicMap.get("TRADE_MODE_PCODE").get(rspBo.getTradeMode().toString()).getTitle());
            rspBo.setWhetherDispatchStr(MapUtil.isEmpty(dicMap.get("IS_DISPATCH_PCODE")) ? null : dicMap.get("IS_DISPATCH_PCODE").get(rspBo.getWhetherDispatch().toString()).getTitle());
            rspBo.setWhetherAssignStr(MapUtil.isEmpty(dicMap.get("IS_ASSIGN_PCODE")) ? null : dicMap.get("IS_ASSIGN_PCODE").get(rspBo.getWhetherAssign().toString()).getTitle());
            rspBo.setAgreementVarietyStr(MapUtil.isEmpty(dicMap.get("AGREEMENT_VARIETY_PCODE")) ? null : dicMap.get("AGREEMENT_VARIETY_PCODE").get(rspBo.getAgreementVariety().toString()).getTitle());
            rspBo.setAgrLocationStr(MapUtil.isEmpty(dicMap.get("AGR_LOCATION_PCODE")) ? null : dicMap.get("AGR_LOCATION_PCODE").get(rspBo.getAgrLocation().toString()).getTitle());
            rspBo.setWhetherStorePlanStr(MapUtil.isEmpty(dicMap.get("IS_STORE_PLAN_PCODE")) ? null : dicMap.get("IS_STORE_PLAN_PCODE").get(rspBo.getWhetherStorePlan().toString()).getTitle());
            rspBo.setScopeTypeStr(MapUtil.isEmpty(dicMap.get("SCOPE_TYPE_PCODE")) ? null : dicMap.get("SCOPE_TYPE_PCODE").get(rspBo.getScopeType().toString()).getTitle());
            rspBo.setAdjustPriceStr(MapUtil.isEmpty(dicMap.get("ADJUST_PRICE_PCODE")) ? null : dicMap.get("ADJUST_PRICE_PCODE").get(rspBo.getAdjustPrice().toString()).getTitle());
            rspBo.setWhetherHaveItemStr(MapUtil.isEmpty(dicMap.get("IS_HAVE_ITEM_PCODE")) ? null : dicMap.get("IS_HAVE_ITEM_PCODE").get(rspBo.getWhetherHaveItem().toString()).getTitle());
            rspBo.setVendorModeStr(MapUtil.isEmpty(dicMap.get("SUPPLIER_MODE_PCODE")) ? null : dicMap.get("SUPPLIER_MODE_PCODE").get(rspBo.getVendorMode().toString()).getTitle());
            rspBo.setAgrBusinessTypeStr(MapUtil.isEmpty(dicMap.get("AGR_BUSINESS_TYPE")) ? null : dicMap.get("AGR_BUSINESS_TYPE").get(rspBo.getAgrBusinessType().toString()).getTitle());
        }
        return rspBo;
    }
}

