/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListPriceExecutionQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListPriceExecutionQryRspPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListCheckService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListCheckReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListCheckRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrItemNumBo;
import com.tydic.dyc.agr.service.agr.bo.AgrItemPriceExecutionBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrGetAgrItemListCheckService"})
public class AgrGetAgrItemListCheckServiceImpl
implements AgrGetAgrItemListCheckService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrItemListCheckServiceImpl.class);
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"getAgrItemListCheck"})
    public AgrGetAgrItemListCheckRspBo getAgrItemListCheck(@RequestBody AgrGetAgrItemListCheckReqBo reqBO) {
        this.virifyReq(reqBO);
        List<Long> agrItemIds = reqBO.getAgrItemNumInfoList().stream().map(AgrItemNumBo::getAgrItemId).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> extAgrItemIds = reqBO.getAgrItemNumInfoList().stream().map(AgrItemNumBo::getExtAgrItemId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> agrIds = new ArrayList<Long>(reqBO.getAgrItemNumInfoList().size());
        Map<Object, Object> agrMap = new HashMap(reqBO.getAgrItemNumInfoList().size());
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        if (CollectionUtil.isNotEmpty(agrItemIds) && agrItemIds.size() > 0 && !agrItemIds.stream().allMatch(Objects::isNull)) {
            agrItemListQryReqPageBo.setAgrItemIds(agrItemIds);
        }
        if (CollectionUtil.isNotEmpty(extAgrItemIds) && extAgrItemIds.size() > 0 && !extAgrItemIds.stream().allMatch(s -> s == null || s.isEmpty())) {
            agrItemListQryReqPageBo.setExtAgrItemIds(extAgrItemIds);
        }
        agrItemListQryReqPageBo.setPageNo(-1);
        agrItemListQryReqPageBo.setPageSize(-1);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);
        if (!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())) {
            agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> reqBO.getAgrItemNumInfoList().forEach(agrItemNumBo -> {
                if (agrItemNumBo.getAgrItemId().equals(agrItemDetailBo.getAgrItemId()) || agrItemNumBo.getExtAgrItemId().equals(agrItemDetailBo.getExtAgrItemId())) {
                    if (agrItemNumBo.getPurNum().compareTo(agrItemDetailBo.getLeftNumber()) > 0) {
                        agrItemDetailBo.setIsExceed(1);
                    } else {
                        agrItemDetailBo.setIsExceed(0);
                    }
                }
            }));
            agrIds = agrItemListQryRspPageBo.getRows().stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(agrIds)) {
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(agrIds);
            agrAgrQryBo.setPageNo(-1);
            agrAgrQryBo.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrMainList = this.iAgrAgrModel.getAgrMainList(agrAgrQryBo);
            agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
        }
        HashMap finalAgrMap = agrMap;
        log.debug("finalAgrMap:{}", (Object)JSONObject.toJSONString(finalAgrMap));
        if (1 == reqBO.getReturnFlag()) {
            agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> {
                if (finalAgrMap.containsKey(agrItemDetailBo.getAgrId()) && !((AgrAgrDo)finalAgrMap.get(agrItemDetailBo.getAgrId())).getAgrStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                    throw new BaseBusinessException("0001", "\u534f\u8bae\u7f16\u53f7\u4e3a[" + ((AgrAgrDo)finalAgrMap.get(agrItemDetailBo.getAgrId())).getAgrCode() + "]\u7684\u534f\u8bae\u72b6\u6001\u4e3a\u7ec8\u6b62");
                }
                if (agrItemDetailBo.getIsExceed() == 1 && 1 == agrItemDetailBo.getIsControlPurchaseNum()) {
                    throw new BaseBusinessException("0001", "\u534f\u8bae\u660e\u7ec6ID\u4e3a[" + agrItemDetailBo.getAgrItemId() + "]\u7684\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u534f\u8bae\u660e\u7ec6\u5269\u4f59\u6570\u91cf");
                }
                if (agrItemDetailBo.getAgrItemStatus() == 0) {
                    throw new BaseBusinessException("0001", "\u534f\u8bae\u660e\u7ec6ID\u4e3a[" + agrItemDetailBo.getAgrItemId() + "]\u7684\u534f\u8bae\u660e\u7ec6\u72b6\u6001\u4e3a[\u505c\u7528]");
                }
            });
        }
        AgrItemListPriceExecutionQryReqPageBo itemListPriceExecutionQryReqPageBo = new AgrItemListPriceExecutionQryReqPageBo();
        itemListPriceExecutionQryReqPageBo.setPageNo(-1);
        itemListPriceExecutionQryReqPageBo.setPageSize(-1);
        itemListPriceExecutionQryReqPageBo.setAgrItemIds(agrItemIds);
        itemListPriceExecutionQryReqPageBo.setAuditStatus(2);
        AgrItemListPriceExecutionQryRspPageBo agrItemListPriceExecutionQryRspPageBo = this.iAgrAgrModel.getAgrItemPriceExecutionList(itemListPriceExecutionQryReqPageBo);
        if (CollectionUtil.isNotEmpty(agrItemListPriceExecutionQryRspPageBo.getRows())) {
            Map<Long, List<AgrItemPriceExecutionBo>> agrItemPriceExecutionBoMap = agrItemListPriceExecutionQryRspPageBo.getRows().stream().collect(Collectors.groupingBy(AgrItemPriceExecutionBo::getAgrItemId));
            agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> {
                if (agrItemPriceExecutionBoMap.containsKey(agrItemDetailBo.getAgrItemId())) {
                    agrItemDetailBo.setAgrItemPriceExecutionBoList((List)agrItemPriceExecutionBoMap.get(agrItemDetailBo.getAgrItemId()));
                }
            });
        }
        agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> {
            log.debug("agrItemDetailBo:{}", (Object)JSONObject.toJSONString((Object)agrItemDetailBo));
            if (finalAgrMap.containsKey(agrItemDetailBo.getAgrId())) {
                agrItemDetailBo.setWhetherStorePlan(((AgrAgrDo)finalAgrMap.get(agrItemDetailBo.getAgrId())).getWhetherStorePlan());
                agrItemDetailBo.setSupplierId(((AgrAgrDo)finalAgrMap.get(agrItemDetailBo.getAgrId())).getSupplierId());
                agrItemDetailBo.setSupplierName(((AgrAgrDo)finalAgrMap.get(agrItemDetailBo.getAgrId())).getSupplierName());
                if (!((AgrAgrDo)finalAgrMap.get(agrItemDetailBo.getAgrId())).getAgrStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                    agrItemDetailBo.setAgrItemStatus(0);
                }
                if (!ObjectUtil.isEmpty(agrItemDetailBo.getAgrItemPriceExecutionBoList())) {
                    List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList = agrItemDetailBo.getAgrItemPriceExecutionBoList().stream().sorted(Comparator.comparing(AgrItemPriceExecutionBo::getExecutionEffDate).reversed()).collect(Collectors.toList());
                    agrItemDetailBo.setAgrItemPriceExecutionBoList(agrItemPriceExecutionBoList);
                }
            }
        });
        return (AgrGetAgrItemListCheckRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)agrItemListQryRspPageBo), AgrGetAgrItemListCheckRspBo.class);
    }

    private void virifyReq(AgrGetAgrItemListCheckReqBo reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrItemNumInfoList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getReturnFlag()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd4\u56de\u6807\u8bc6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (1 != reqBO.getReturnFlag() && 2 != reqBO.getReturnFlag()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd4\u56de\u6807\u8bc6]\u7c7b\u578b\u9519\u8bef");
        }
    }
}

